/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.javaops;

import com.singularsys.jep.EmptyOperatorTable;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.configurableparser.TernaryOperator;
import com.singularsys.jep.misc.bitwise.BitwiseOperatorTable;
import com.singularsys.jep.misc.javaops.OpEquals;
import com.singularsys.jep.misc.javaops.PostDec;
import com.singularsys.jep.misc.javaops.PostInc;
import com.singularsys.jep.misc.javaops.PreDec;
import com.singularsys.jep.misc.javaops.PreInc;
import com.singularsys.jep.misc.javaops.TernaryConditional;

public class JavaOperatorTable
extends BitwiseOperatorTable {
    private static final long serialVersionUID = 302L;
    Operator preinc = new Operator("preinc", "++", null, 513);
    Operator postinc = new Operator("postinc", "++", null, 1025);
    Operator predec = new Operator("predec", "--", null, 513);
    Operator postdec = new Operator("postdec", "--", null, 1025);
    TernaryOperator ternaryCond = new TernaryOperator("conditional", "?", ":", new TernaryConditional(), 32768);
    Operator pluseq = new Operator("+=", null, 10);
    Operator minuseq = new Operator("-=", null, 10);
    Operator muleq = new Operator("*=", null, 10);
    Operator diveq = new Operator("/=", null, 10);
    Operator modeq = new Operator("%=", null, 10);
    Operator andeq = new Operator("&=", null, 10);
    Operator oreq = new Operator("|=", null, 10);
    Operator xoreq = new Operator("^=", null, 10);
    Operator lseq = new Operator("<<=", null, 10);
    Operator rseq = new Operator(">>=", null, 10);
    Operator urseq = new Operator(">>>=", null, 10);

    public JavaOperatorTable() {
        this("**", "^");
    }

    public JavaOperatorTable(String string) {
        this(string, "^");
    }

    public JavaOperatorTable(String string, String string2) {
        super(string, string2);
        this.addJavaOps();
        this.setJavaPfmcs();
    }

    public JavaOperatorTable(OperatorTable2 operatorTable2, String string, String string2) {
        super(operatorTable2, string, string2);
        this.addJavaOps();
        this.setJavaPfmcs();
    }

    protected void addJavaOps() {
        this.addOperator(JavaOperators.PREINC, this.preinc, this.getUMinus());
        this.addOperator(JavaOperators.PREDEC, this.predec, this.getUMinus());
        this.addOperator(JavaOperators.POSTINC, this.postinc, this.getUMinus());
        this.addOperator(JavaOperators.POSTDEC, this.postdec, this.getUMinus());
        this.insertOperator(JavaOperators.TERNCOND, this.ternaryCond, this.getAssign());
        this.addOperator(JavaOperators.PLUSEQUAL, this.pluseq, this.getAssign());
        this.addOperator(JavaOperators.MINUSEQUAL, this.minuseq, this.getAssign());
        this.addOperator(JavaOperators.TIMESEQUAL, this.muleq, this.getAssign());
        this.addOperator(JavaOperators.DIVIDEEQUAL, this.diveq, this.getAssign());
        this.addOperator(JavaOperators.MODEQUAL, this.modeq, this.getAssign());
        this.addOperator(JavaOperators.ANDEQUAL, this.andeq, this.getAssign());
        this.addOperator(JavaOperators.OREQUAL, this.oreq, this.getAssign());
        this.addOperator(JavaOperators.XOREQUAL, this.xoreq, this.getAssign());
        this.addOperator(JavaOperators.LSHIFTEQUAL, this.lseq, this.getAssign());
        this.addOperator(JavaOperators.RSHIFTEQUAL, this.rseq, this.getAssign());
        this.addOperator(JavaOperators.URSHIFTEQUAL, this.urseq, this.getAssign());
    }

    protected void setJavaPfmcs() {
        this.getPreInc().setPFMC(new PreInc());
        this.getPreDec().setPFMC(new PreDec());
        this.getPostInc().setPFMC(new PostInc());
        this.getPostDec().setPFMC(new PostDec());
        this.getPlusEquals().setPFMC(new OpEquals(this.getAdd().getPFMC()));
        this.getMinusEquals().setPFMC(new OpEquals(this.getSubtract().getPFMC()));
        this.getTimesEquals().setPFMC(new OpEquals(this.getMultiply().getPFMC()));
        this.getDivideEquals().setPFMC(new OpEquals(this.getDivide().getPFMC()));
        this.getModEquals().setPFMC(new OpEquals(this.getMod().getPFMC()));
        this.getAndEquals().setPFMC(new OpEquals(this.getBitAnd().getPFMC()));
        this.getOrEquals().setPFMC(new OpEquals(this.getBitOr().getPFMC()));
        this.getXOrEquals().setPFMC(new OpEquals(this.getBitXor().getPFMC()));
        this.getLShiftEquals().setPFMC(new OpEquals(this.getLShift().getPFMC()));
        this.getRShiftEquals().setPFMC(new OpEquals(this.getRShift().getPFMC()));
        this.getURShiftEquals().setPFMC(new OpEquals(this.getURShift().getPFMC()));
    }

    public Operator getPreInc() {
        return this.getOperator(JavaOperators.PREINC);
    }

    public Operator getPreDec() {
        return this.getOperator(JavaOperators.PREDEC);
    }

    public Operator getPostInc() {
        return this.getOperator(JavaOperators.POSTINC);
    }

    public Operator getPostDec() {
        return this.getOperator(JavaOperators.POSTDEC);
    }

    public TernaryOperator getTernCond() {
        return (TernaryOperator)this.getOperator(JavaOperators.TERNCOND);
    }

    public Operator getPlusEquals() {
        return this.getOperator(JavaOperators.PLUSEQUAL);
    }

    public Operator getMinusEquals() {
        return this.getOperator(JavaOperators.MINUSEQUAL);
    }

    public Operator getTimesEquals() {
        return this.getOperator(JavaOperators.TIMESEQUAL);
    }

    public Operator getDivideEquals() {
        return this.getOperator(JavaOperators.DIVIDEEQUAL);
    }

    public Operator getModEquals() {
        return this.getOperator(JavaOperators.MODEQUAL);
    }

    public Operator getAndEquals() {
        return this.getOperator(JavaOperators.ANDEQUAL);
    }

    public Operator getOrEquals() {
        return this.getOperator(JavaOperators.OREQUAL);
    }

    public Operator getXOrEquals() {
        return this.getOperator(JavaOperators.XOREQUAL);
    }

    public Operator getLShiftEquals() {
        return this.getOperator(JavaOperators.LSHIFTEQUAL);
    }

    public Operator getRShiftEquals() {
        return this.getOperator(JavaOperators.RSHIFTEQUAL);
    }

    public Operator getURShiftEquals() {
        return this.getOperator(JavaOperators.URSHIFTEQUAL);
    }

    public static enum JavaOperators implements EmptyOperatorTable.OperatorKey
    {
        PREINC,
        PREDEC,
        POSTINC,
        POSTDEC,
        TERNCOND,
        PLUSEQUAL,
        MINUSEQUAL,
        TIMESEQUAL,
        DIVIDEEQUAL,
        MODEQUAL,
        ANDEQUAL,
        OREQUAL,
        XOREQUAL,
        LSHIFTEQUAL,
        RSHIFTEQUAL,
        URSHIFTEQUAL;

    }
}

