/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.javaops;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.LValueI;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.Stack;

public class OpEquals
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;
    PostfixMathCommandI fun;
    Stack<Object> stack = new Stack();

    public OpEquals(PostfixMathCommandI postfixMathCommandI) {
        super(2);
        this.fun = postfixMathCommandI;
    }

    public PostfixMathCommandI getRoot() {
        return this.fun;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        Object object;
        if (node.jjtGetNumChildren() != 2) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArgumentsExpected"), this.getName(), 2));
        }
        Object object2 = evaluator.eval(node.jjtGetChild(1));
        Node node2 = node.jjtGetChild(0);
        Object object3 = evaluator.eval(node.jjtGetChild(0));
        if (this.fun instanceof BinaryFunction) {
            object = ((BinaryFunction)this.fun).eval(object3, object2);
        } else if (this.fun instanceof NaryBinaryFunction) {
            object = ((NaryBinaryFunction)this.fun).eval(object3, object2);
        } else {
            this.stack.clear();
            this.stack.push(object3);
            this.stack.push(object2);
            this.fun.setCurNumberOfParameters(2);
            this.fun.run(this.stack);
            if (this.stack.size() != 1) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.StackError"), this.getName()));
            }
            object = this.stack.pop();
        }
        if (node2 instanceof ASTVarNode) {
            ASTVarNode aSTVarNode = (ASTVarNode)node2;
            Variable variable = aSTVarNode.getVar();
            if (!variable.setValue(object)) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.AttemptToSetValueOfAConstantVariable"), this.getName(), variable.getName()));
            }
            return object;
        }
        if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).getPFMC() instanceof LValueI) {
            ((LValueI)((Object)((ASTFunNode)node2).getPFMC())).set(evaluator, node2, object);
            return object;
        }
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.AssignmentShouldHaveAnLValue"), this.getName(), node2.toString()));
    }
}

