/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.parser;

import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected final int id;
    protected Node.HookKey[] keys;
    protected Object[] vals;

    public SimpleNode(int n) {
        this.id = n;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) throws JepException {
        throw new JepException(MessageFormat.format(JepMessages.getString("IllegalNodeTypeEncountered"), this.getClass().getSimpleName()));
    }

    public Object childrenAccept(ParserVisitor parserVisitor, Object object) throws JepException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(parserVisitor, object);
            }
        }
        return object;
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + JepMessages.getString("parser.SimpleNode.Space"));
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    private int getHookIndex(Node.HookKey hookKey) {
        if (this.keys == null) {
            return -1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != hookKey) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getHook(Node.HookKey hookKey) {
        int n = this.getHookIndex(hookKey);
        if (n < 0) {
            return null;
        }
        return this.vals[n];
    }

    @Override
    public Object setHook(Node.HookKey hookKey, Object object) {
        if (this.keys == null) {
            this.keys = new Node.HookKey[1];
            this.vals = new Object[1];
            this.keys[0] = hookKey;
            this.vals[0] = object;
            return null;
        }
        int n = this.getHookIndex(hookKey);
        if (n >= 0) {
            Object object2 = this.vals[n];
            this.vals[n] = object;
            return object2;
        }
        Node.HookKey[] hookKeyArray = this.keys;
        Object[] objectArray = this.vals;
        int n2 = hookKeyArray.length;
        this.keys = new Node.HookKey[n2 + 1];
        this.vals = new Object[n2 + 1];
        System.arraycopy(hookKeyArray, 0, this.keys, 0, n2);
        System.arraycopy(objectArray, 0, this.vals, 0, n2);
        this.keys[n2] = hookKey;
        this.vals[n2] = object;
        return null;
    }

    @Override
    public Collection<Node.HookKey> hookKeys() {
        return Arrays.asList(this.keys);
    }

    @Override
    public Object removeHook(Node.HookKey hookKey) {
        if (this.keys == null) {
            return null;
        }
        int n = this.getHookIndex(hookKey);
        if (n < 0) {
            return null;
        }
        Object object = this.vals[n];
        Node.HookKey[] hookKeyArray = this.keys;
        Object[] objectArray = this.vals;
        int n2 = hookKeyArray.length;
        if (n2 == 1) {
            this.keys = null;
            this.vals = null;
            return object;
        }
        this.keys = new Node.HookKey[n2 - 1];
        this.vals = new Object[n2 - 1];
        System.arraycopy(hookKeyArray, 0, this.keys, 0, n);
        System.arraycopy(objectArray, 0, this.vals, 0, n);
        System.arraycopy(hookKeyArray, n + 1, this.keys, n, n2 - n - 1);
        System.arraycopy(objectArray, n + 1, this.vals, n, n2 - n - 1);
        return object;
    }

    @Override
    public Iterator<Node> childIterator() {
        return new ChildIterator();
    }

    @Override
    public Iterable<Node> children() {
        return new ChildIterable();
    }

    class ChildIterable
    implements Iterable<Node> {
        ChildIterable() {
        }

        @Override
        public Iterator<Node> iterator() {
            return SimpleNode.this.childIterator();
        }
    }

    class ChildIterator
    implements Iterator<Node> {
        int pos = 0;

        ChildIterator() {
        }

        @Override
        public boolean hasNext() {
            if (SimpleNode.this.children != null) {
                return this.pos < SimpleNode.this.children.length;
            }
            return false;
        }

        @Override
        public Node next() {
            return SimpleNode.this.children[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

