/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Diagram;
import de.didappslib.base.DocumentPanel;
import de.didappslib.base.DocumentPrefs;
import de.didappslib.base.Extras;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Model;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import de.didappslib.base.VergleichsTabelle;
import de.didappslib.guitools.AskSaveChangesDialog;
import de.didappslib.guitools.AutoDialog;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class Document {
    protected final Document me = this;
    protected final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Projekt", Statics.locale);
    private DocumentPanel viewer;
    protected DocumentPrefs documentPrefs;
    protected Model model;
    protected Extras extras;
    protected Diagram diagramm;
    protected JFileChooser fileDialog;
    private final Tabelle modelTable = new Tabelle(this, 1);
    private final Tabelle customTable = new Tabelle(this, 2);
    private final VergleichsTabelle compValTable = new VergleichsTabelle(this, 3);
    private String prjName = this.rbundle.getString("Neues_Projekt");
    protected String dateiVerzeichnis = "";
    protected String dateiName = Statics.prg_Bundle.getString("PrjDateiName_neu");
    protected Rectangle windowBounds;
    protected float sidebarDivLocFactor;
    protected Rectangle windowBounds_loaded = new Rectangle();
    protected float sidebarDivLocFactor_loaded;
    protected int tableViewSize_loaded = 0;
    public final Rectangle windowBounds_default = new Rectangle(-1, -1, -1, -1);
    public final int sidebarMinWidth_default = 315;
    protected float sidebarDivLocFactor_default = 1.0f;
    public int punktGroesse;
    public int linienStaerke;
    public int zeichFarbIndex;
    public int auswFarbIndex;
    public int fktBreite;
    public int fktStrichelung;
    public int fktFarbIndex;
    public int wertePktGr;
    public int werteFarbIndex;
    public int fontNumber;
    public float fontSize;
    public boolean showMainGrid;
    public boolean showSmallGrid;
    public boolean achsenFaerben;
    public boolean scrollRad;
    public boolean achsenDehnen;
    public boolean showLegend;
    public int punktGroesse_default = 7;
    public int linienStaerke_default = 2;
    public int zeichFarbIndex_default = 0;
    public int auswFarbIndex_default = 160;
    public int fktBreite_default = 2;
    public int fktStrichelung_default = 5;
    public int fktFarbIndex_default = 200;
    public int wertePktGr_default = 7;
    public int werteFarbIndex_default = 100;
    public int fontNumber_default = 4;
    public float fontSize_default = 14.0f;
    public boolean showMainGrid_default = true;
    public boolean showSmallGrid_default = true;
    public boolean achsenFaerben_default = true;
    public boolean scrollRad_default = true;
    public boolean achsenDehnen_default = true;
    public boolean showLegend_default = false;
    public int punktGroesse_loaded;
    public int linienStaerke_loaded;
    public int zeichFarbIndex_loaded;
    public int auswFarbIndex_loaded;
    public int fktBreite_loaded;
    public int fktStrichelung_loaded;
    public int fktFarbIndex_loaded;
    public int wertePktGr_loaded;
    public int werteFarbIndex_loaded;
    public int fontNumber_loaded;
    public float fontSize_loaded;
    public boolean showMainGrid_loaded;
    public boolean showSmallGrid_loaded;
    public boolean achsenFaerben_loaded;
    public boolean scrollRad_loaded;
    public boolean achsenDehnen_loaded;
    public boolean showLegend_loaded;
    private boolean changed = false;
    private boolean errorOccured = false;
    public boolean autoCalc = true;
    public String[] defaultAuftrStrR = new String[]{"", "", "", ""};
    public String[] defaultAuftrStrH = new String[]{"", "", "", ""};
    public String[] defaultAuftrStr3D = new String[]{"", "", ""};

    public Document() {
    }

    public Document(int dummy) {
        int j = 0;
        for (Document prj : Statics.projektListe) {
            if (!prj.getPrjName().startsWith(this.prjName)) continue;
            ++j;
        }
        if (j > 0) {
            this.prjName = this.prjName + " " + (j + 1);
        }
        this.viewer = new DocumentPanel(this.me);
        this.documentPrefs = new DocumentPrefs(this.me);
        this.setVariablesToDefault();
        if (Statics.templateDoc != null) {
            this.setLoadedToTemplate();
        } else {
            this.setLoadedToDefault();
        }
        this.adaptToTemplate();
        this.diagramm = new Diagram(this.me);
        this.model = Statics.modelLauncher.newStdModel(this.me);
        this.model.neu();
        this.extras = new Extras(this.me);
        this.viewer.init();
        this.scale(Statics.prefsDialog.guiScale);
        this.changed = false;
        this.viewer.updateWindowTitle();
    }

    public void setVariablesToDefault() {
        this.windowBounds = new Rectangle(this.windowBounds_default);
        this.sidebarDivLocFactor = this.sidebarDivLocFactor_default;
        this.punktGroesse = this.punktGroesse_default;
        this.linienStaerke = this.linienStaerke_default;
        this.zeichFarbIndex = this.zeichFarbIndex_default;
        this.auswFarbIndex = this.auswFarbIndex_default;
        this.fktBreite = this.fktBreite_default;
        this.fktStrichelung = this.fktStrichelung_default;
        this.fktFarbIndex = this.fktFarbIndex_default;
        this.wertePktGr = this.wertePktGr_default;
        this.werteFarbIndex = this.werteFarbIndex_default;
        this.fontNumber = this.fontNumber_default;
        this.fontSize = this.fontSize_default;
        this.showMainGrid = this.showMainGrid_default;
        this.showSmallGrid = this.showSmallGrid_default;
        this.achsenFaerben = this.achsenFaerben_default;
        this.scrollRad = this.scrollRad_default;
        this.achsenDehnen = this.achsenDehnen_default;
        this.showLegend = this.showLegend_default;
    }

    public void adaptToTemplate() {
        if (Statics.templateDoc != null) {
            this.windowBounds = new Rectangle(Statics.templateDoc.windowBounds);
            this.sidebarDivLocFactor = Statics.templateDoc.sidebarDivLocFactor;
            this.punktGroesse = Statics.templateDoc.punktGroesse;
            this.linienStaerke = Statics.templateDoc.linienStaerke;
            this.zeichFarbIndex = Statics.templateDoc.zeichFarbIndex;
            this.auswFarbIndex = Statics.templateDoc.auswFarbIndex;
            this.fktBreite = Statics.templateDoc.fktBreite;
            this.fktStrichelung = Statics.templateDoc.fktStrichelung;
            this.fktFarbIndex = Statics.templateDoc.fktFarbIndex;
            this.wertePktGr = Statics.templateDoc.wertePktGr;
            this.werteFarbIndex = Statics.templateDoc.werteFarbIndex;
            this.fontNumber = Statics.templateDoc.fontNumber;
            this.fontSize = Statics.templateDoc.fontSize;
            this.showMainGrid = Statics.templateDoc.showMainGrid;
            this.showSmallGrid = Statics.templateDoc.showSmallGrid;
            this.achsenFaerben = Statics.templateDoc.achsenFaerben;
            this.scrollRad = Statics.templateDoc.scrollRad;
            this.achsenDehnen = Statics.templateDoc.achsenDehnen;
            this.showLegend = Statics.templateDoc.showLegend;
        }
    }

    public void setVariablesToLoaded() {
        this.windowBounds = Statics.prefsDialog.adjustWindowToScreen ? new Rectangle(-1, -1, -1, -1) : new Rectangle(this.windowBounds_loaded);
        this.sidebarDivLocFactor = this.sidebarDivLocFactor_loaded;
        this.punktGroesse = this.punktGroesse_loaded;
        this.linienStaerke = this.linienStaerke_loaded;
        this.zeichFarbIndex = this.zeichFarbIndex_loaded;
        this.auswFarbIndex = this.auswFarbIndex_loaded;
        this.fktBreite = this.fktBreite_loaded;
        this.fktStrichelung = this.fktStrichelung_loaded;
        this.fktFarbIndex = this.fktFarbIndex_loaded;
        this.wertePktGr = this.wertePktGr_loaded;
        this.werteFarbIndex = this.werteFarbIndex_loaded;
        this.fontNumber = this.fontNumber_loaded;
        this.fontSize = this.fontSize_loaded;
        this.showMainGrid = this.showMainGrid_loaded;
        this.showSmallGrid = this.showSmallGrid_loaded;
        this.achsenFaerben = this.achsenFaerben_loaded;
        this.scrollRad = this.scrollRad_loaded;
        this.achsenDehnen = this.achsenDehnen_loaded;
        this.showLegend = this.showLegend_loaded;
    }

    public void setLoadedToVariables() {
        this.sidebarDivLocFactor_loaded = this.sidebarDivLocFactor;
        this.punktGroesse_loaded = this.punktGroesse;
        this.linienStaerke_loaded = this.linienStaerke;
        this.zeichFarbIndex_loaded = this.zeichFarbIndex;
        this.auswFarbIndex_loaded = this.auswFarbIndex;
        this.fktBreite_loaded = this.fktBreite;
        this.fktStrichelung_loaded = this.fktStrichelung;
        this.fktFarbIndex_loaded = this.fktFarbIndex;
        this.wertePktGr_loaded = this.wertePktGr;
        this.werteFarbIndex_loaded = this.werteFarbIndex;
        this.fontNumber_loaded = this.fontNumber;
        this.fontSize_loaded = this.fontSize;
        this.showMainGrid_loaded = this.showMainGrid;
        this.showSmallGrid_loaded = this.showSmallGrid;
        this.achsenFaerben_loaded = this.achsenFaerben;
        this.scrollRad_loaded = this.scrollRad;
        this.achsenDehnen_loaded = this.achsenDehnen;
        this.showLegend_loaded = this.showLegend;
    }

    public boolean areVariablesDefault() {
        if (this.sidebarDivLocFactor != this.sidebarDivLocFactor) {
            return false;
        }
        if (this.punktGroesse != this.punktGroesse_default) {
            return false;
        }
        if (this.linienStaerke != this.linienStaerke_default) {
            return false;
        }
        if (this.zeichFarbIndex != this.zeichFarbIndex_default) {
            return false;
        }
        if (this.auswFarbIndex != this.auswFarbIndex_default) {
            return false;
        }
        if (this.fktBreite != this.fktBreite_default) {
            return false;
        }
        if (this.fktStrichelung != this.fktStrichelung_default) {
            return false;
        }
        if (this.fktFarbIndex != this.fktFarbIndex_default) {
            return false;
        }
        if (this.wertePktGr != this.wertePktGr_default) {
            return false;
        }
        if (this.werteFarbIndex != this.werteFarbIndex_default) {
            return false;
        }
        if (this.fontNumber != this.fontNumber_default) {
            return false;
        }
        if (this.fontSize != this.fontSize_default) {
            return false;
        }
        if (this.showMainGrid != this.showMainGrid_default) {
            return false;
        }
        if (this.showSmallGrid != this.showSmallGrid_default) {
            return false;
        }
        if (this.achsenFaerben != this.achsenFaerben_default) {
            return false;
        }
        if (this.scrollRad != this.scrollRad_default) {
            return false;
        }
        if (this.achsenDehnen != this.achsenDehnen_default) {
            return false;
        }
        return this.showLegend == this.showLegend_default;
    }

    public boolean areVariablesEqToTemplate() {
        if (this.sidebarDivLocFactor != Statics.templateDoc.sidebarDivLocFactor) {
            return false;
        }
        if (this.punktGroesse != Statics.templateDoc.punktGroesse) {
            return false;
        }
        if (this.linienStaerke != Statics.templateDoc.linienStaerke) {
            return false;
        }
        if (this.zeichFarbIndex != Statics.templateDoc.zeichFarbIndex) {
            return false;
        }
        if (this.auswFarbIndex != Statics.templateDoc.auswFarbIndex) {
            return false;
        }
        if (this.fktBreite != Statics.templateDoc.fktBreite) {
            return false;
        }
        if (this.fktStrichelung != Statics.templateDoc.fktStrichelung) {
            return false;
        }
        if (this.fktFarbIndex != Statics.templateDoc.fktFarbIndex) {
            return false;
        }
        if (this.wertePktGr != Statics.templateDoc.wertePktGr) {
            return false;
        }
        if (this.werteFarbIndex != Statics.templateDoc.werteFarbIndex) {
            return false;
        }
        if (this.fontNumber != Statics.templateDoc.fontNumber) {
            return false;
        }
        if (this.fontSize != Statics.templateDoc.fontSize) {
            return false;
        }
        if (this.showMainGrid != Statics.templateDoc.showMainGrid) {
            return false;
        }
        if (this.showSmallGrid != Statics.templateDoc.showSmallGrid) {
            return false;
        }
        if (this.achsenFaerben != Statics.templateDoc.achsenFaerben) {
            return false;
        }
        if (this.scrollRad != Statics.templateDoc.scrollRad) {
            return false;
        }
        if (this.achsenDehnen != Statics.templateDoc.achsenDehnen) {
            return false;
        }
        return this.showLegend == Statics.templateDoc.showLegend;
    }

    public boolean areVariablesEqToLoadedOnes() {
        if (this.sidebarDivLocFactor != this.sidebarDivLocFactor_loaded) {
            return false;
        }
        if (this.punktGroesse != this.punktGroesse_loaded) {
            return false;
        }
        if (this.linienStaerke != this.linienStaerke_loaded) {
            return false;
        }
        if (this.zeichFarbIndex != this.zeichFarbIndex_loaded) {
            return false;
        }
        if (this.auswFarbIndex != this.auswFarbIndex_loaded) {
            return false;
        }
        if (this.fktBreite != this.fktBreite_loaded) {
            return false;
        }
        if (this.fktStrichelung != this.fktStrichelung_loaded) {
            return false;
        }
        if (this.fktFarbIndex != this.fktFarbIndex_loaded) {
            return false;
        }
        if (this.wertePktGr != this.wertePktGr_loaded) {
            return false;
        }
        if (this.werteFarbIndex != this.werteFarbIndex_loaded) {
            return false;
        }
        if (this.fontNumber != this.fontNumber_loaded) {
            return false;
        }
        if (this.fontSize != this.fontSize_loaded) {
            return false;
        }
        if (this.showMainGrid != this.showMainGrid_loaded) {
            return false;
        }
        if (this.showSmallGrid != this.showSmallGrid_loaded) {
            return false;
        }
        if (this.achsenFaerben != this.achsenFaerben_loaded) {
            return false;
        }
        if (this.scrollRad != this.scrollRad_loaded) {
            return false;
        }
        if (this.achsenDehnen != this.achsenDehnen_loaded) {
            return false;
        }
        return this.showLegend == this.showLegend_loaded;
    }

    public String getPrjName() {
        return this.prjName;
    }

    public String getFileName() {
        return this.dateiName;
    }

    public String getPath() {
        if (!this.dateiVerzeichnis.endsWith(File.separator)) {
            return this.dateiVerzeichnis + File.separator;
        }
        return this.dateiVerzeichnis;
    }

    public Model getModel() {
        return this.model;
    }

    public Extras getExtras() {
        return this.extras;
    }

    public Diagram getDiagramm() {
        return this.diagramm;
    }

    public DocumentPanel getViewer() {
        return this.viewer;
    }

    public Tabelle getModelTable() {
        return this.modelTable;
    }

    public Tabelle getCustomTable() {
        return this.customTable;
    }

    public VergleichsTabelle getCompValTable() {
        return this.compValTable;
    }

    public void show() {
        this.viewer.getWindow().setVisible(true);
        this.viewer.getWindow().toFront();
    }

    public boolean isEditierbar() {
        if (this.model != null) {
            return this.model.editierbar;
        }
        return false;
    }

    public void setPrjName(String name) {
        this.prjName = name;
        try {
            this.viewer.updateWindowTitle();
            this.viewer.setPrjNameFieldText(this.prjName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setViewer(DocumentPanel az) {
        this.viewer = az;
    }

    public void setDiagramm(Diagram diag) {
        this.diagramm = diag;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setErrorOccured(boolean eo) {
        this.errorOccured = eo;
    }

    public boolean errorOccured() {
        return this.errorOccured;
    }

    public void errorMsg(String errText, String descrText, JComponent comp, boolean showDialog) {
        if (this.errorOccured() && !showDialog) {
            return;
        }
        if (comp != null) {
            comp.setBackground(Statics.fieldErrorColor);
        }
        if (showDialog) {
            new AutoDialog(this.getViewer().getWindow()).display(errText, Statics.translateErrMsg(descrText), Statics.rBundle.getString("OK"));
        } else if (this.getViewer() != null) {
            this.getViewer().setErrorLabel(errText + "\n" + Statics.translateErrMsg(descrText), 1);
        }
        if (errText != null) {
            this.setErrorOccured(true);
        }
    }

    public void clrError() {
        if (this.getViewer() != null) {
            this.getViewer().setErrorLabel("", 0);
        }
        this.setErrorOccured(false);
    }

    public void warningMsg(String errText, String descrText) {
        this.getViewer().setErrorLabel(errText + "\n" + descrText, 2);
    }

    public void clrErrColor(JComponent comp) {
        if (comp != null) {
            comp.setBackground(Statics.fieldBackColor);
        }
    }

    public void setChanged(boolean ch) {
        if (this.changed == ch) {
            return;
        }
        this.changed = ch;
        if (this.viewer != null) {
            this.viewer.updateWindowTitle();
        }
    }

    public void showPrefs() {
        this.documentPrefs.showPrefs();
    }

    public void aktivieren() {
        this.viewer.getWindow().toFront();
    }

    public void scale(float newscale) {
        this.viewer.scaleSidebar(newscale);
        this.viewer.updateAll();
    }

    public void checkDefaultAuftragungsStrings() {
        int i;
        for (i = 0; i < 4; ++i) {
            if (this.defaultAuftrStrR[i].isEmpty() || this.defaultAuftrStrR[i].equals("#")) {
                this.defaultAuftrStrR[i] = this.getModel().getVarName(0);
            }
            if (!this.defaultAuftrStrH[i].isEmpty() && !this.defaultAuftrStrH[i].equals("#")) continue;
            this.defaultAuftrStrH[i] = this.getModel().getVarName(i + 1);
        }
        for (i = 0; i < 3; ++i) {
            if (!this.defaultAuftrStr3D[i].isEmpty() && !this.defaultAuftrStr3D[i].equals("#")) continue;
            this.defaultAuftrStr3D[i] = this.getModel().getVarName(i + 1);
        }
    }

    public void clearDefaultAuftragungsStrings() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.defaultAuftrStrR[i] = "#";
            this.defaultAuftrStrH[i] = "#";
        }
        for (i = 0; i < 3; ++i) {
            this.defaultAuftrStr3D[i] = "#";
        }
    }

    public void switchModel(String dimension) {
        if (this.hasChanged() && this.viewer != null) {
            switch (new AskSaveChangesDialog(this).display()) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    if (this.projektSpeichern(true)) break;
                    return;
                }
            }
        }
        this.clearDefaultAuftragungsStrings();
        this.model = Statics.modelLauncher.newModel(this.me, dimension);
        this.model.neu();
        this.extras.neu();
        if (this.viewer != null) {
            this.viewer.setModelPanel(this.model);
            this.viewer.validateSidebar();
            this.viewer.scaleSidebar(Statics.prefsDialog.guiScale);
            this.viewer.showHideTable(0.0);
            this.diagramm.clearKSListe();
            this.diagramm.createKSysteme(1, true, true);
            this.model.werteAuslesen(false);
        }
        this.setChanged(false);
    }

    public void speichereMeineVariablen(ObjectOutputStream ostr) throws Exception {
        this.windowBounds = this.viewer.getWindowBounds();
        ostr.writeInt(this.windowBounds.x);
        ostr.writeInt(this.windowBounds.y);
        ostr.writeInt(this.windowBounds.width);
        ostr.writeInt(this.windowBounds.height);
        ostr.writeFloat(this.sidebarDivLocFactor);
        ostr.writeInt(this.punktGroesse);
        ostr.writeInt(this.linienStaerke);
        ostr.writeInt(this.zeichFarbIndex);
        ostr.writeInt(this.auswFarbIndex);
        ostr.writeInt(this.fktBreite);
        ostr.writeInt(this.fktStrichelung);
        ostr.writeInt(this.fktFarbIndex);
        ostr.writeInt(this.wertePktGr);
        ostr.writeInt(this.werteFarbIndex);
        ostr.writeInt(this.fontNumber);
        ostr.writeFloat(this.fontSize);
        ostr.writeBoolean(this.showMainGrid);
        ostr.writeBoolean(this.showSmallGrid);
        ostr.writeBoolean(this.achsenFaerben);
        ostr.writeBoolean(this.scrollRad);
        ostr.writeBoolean(this.achsenDehnen);
        ostr.writeBoolean(this.showLegend);
    }

    public void ladeMeineVariablen(ObjectInputStream ostr) throws Exception {
        this.windowBounds_loaded.x = ostr.readInt();
        this.windowBounds_loaded.y = ostr.readInt();
        this.windowBounds_loaded.width = ostr.readInt();
        this.windowBounds_loaded.height = ostr.readInt();
        this.sidebarDivLocFactor_loaded = ostr.readFloat();
        this.punktGroesse_loaded = ostr.readInt();
        this.linienStaerke_loaded = ostr.readInt();
        this.zeichFarbIndex_loaded = ostr.readInt();
        this.auswFarbIndex_loaded = ostr.readInt();
        this.fktBreite_loaded = ostr.readInt();
        this.fktStrichelung_loaded = ostr.readInt();
        this.fktFarbIndex_loaded = ostr.readInt();
        this.wertePktGr_loaded = ostr.readInt();
        this.werteFarbIndex_loaded = ostr.readInt();
        this.fontNumber_loaded = ostr.readInt();
        this.fontSize_loaded = ostr.readFloat();
        this.showMainGrid_loaded = ostr.readBoolean();
        this.showSmallGrid_loaded = ostr.readBoolean();
        this.achsenFaerben_loaded = ostr.readBoolean();
        this.scrollRad_loaded = ostr.readBoolean();
        this.achsenDehnen_loaded = ostr.readBoolean();
        this.showLegend_loaded = ostr.readBoolean();
        this.setVariablesToLoaded();
    }

    public void setLoadedToDefault() {
        this.sidebarDivLocFactor_loaded = this.sidebarDivLocFactor_default;
        this.punktGroesse_loaded = this.punktGroesse_default;
        this.linienStaerke_loaded = this.linienStaerke_default;
        this.zeichFarbIndex_loaded = this.zeichFarbIndex_default;
        this.auswFarbIndex_loaded = this.auswFarbIndex_default;
        this.fktBreite_loaded = this.fktBreite_default;
        this.fktStrichelung_loaded = this.fktStrichelung_default;
        this.fktFarbIndex_loaded = this.fktFarbIndex_default;
        this.wertePktGr_loaded = this.wertePktGr_default;
        this.werteFarbIndex_loaded = this.werteFarbIndex_default;
        this.fontNumber_loaded = this.fontNumber_default;
        this.fontSize_loaded = this.fontSize_default;
        this.showMainGrid_loaded = this.showMainGrid_default;
        this.showSmallGrid_loaded = this.showSmallGrid_default;
        this.achsenFaerben_loaded = this.achsenFaerben_default;
        this.scrollRad_loaded = this.scrollRad_default;
        this.achsenDehnen_loaded = this.achsenDehnen_default;
        this.showLegend_loaded = this.showLegend_default;
    }

    public void setLoadedToTemplate() {
        if (Statics.templateDoc != null) {
            this.windowBounds = new Rectangle(Statics.templateDoc.windowBounds);
            this.sidebarDivLocFactor_loaded = Statics.templateDoc.sidebarDivLocFactor;
            this.punktGroesse_loaded = Statics.templateDoc.punktGroesse;
            this.linienStaerke_loaded = Statics.templateDoc.linienStaerke;
            this.zeichFarbIndex_loaded = Statics.templateDoc.zeichFarbIndex;
            this.auswFarbIndex_loaded = Statics.templateDoc.auswFarbIndex;
            this.fktBreite_loaded = Statics.templateDoc.fktBreite;
            this.fktStrichelung_loaded = Statics.templateDoc.fktStrichelung;
            this.fktFarbIndex_loaded = Statics.templateDoc.fktFarbIndex;
            this.wertePktGr_loaded = Statics.templateDoc.wertePktGr;
            this.werteFarbIndex_loaded = Statics.templateDoc.werteFarbIndex;
            this.fontNumber_loaded = Statics.templateDoc.fontNumber;
            this.fontSize_loaded = Statics.templateDoc.fontSize;
            this.showMainGrid_loaded = Statics.templateDoc.showMainGrid;
            this.showSmallGrid_loaded = Statics.templateDoc.showSmallGrid;
            this.achsenFaerben_loaded = Statics.templateDoc.achsenFaerben;
            this.scrollRad_loaded = Statics.templateDoc.scrollRad;
            this.achsenDehnen_loaded = Statics.templateDoc.achsenDehnen;
            this.showLegend_loaded = Statics.templateDoc.showLegend;
        }
    }

    protected boolean ladeDaten(ObjectInputStream ostr) throws Exception {
        String kennung;
        float datversion;
        String datformat = ostr.readUTF();
        if (datformat.contains("DataFormat")) {
            datversion = 1.0f;
        } else {
            datversion = Float.valueOf(datformat.substring(datformat.indexOf("_V") + 2).replace('_', '.')).floatValue();
            float max_datVersion = Float.valueOf(Statics.prg_Bundle.getString("DataFormat").substring(Statics.prg_Bundle.getString("DataFormat").indexOf("_V") + 2)).floatValue();
            if (Statics.prgName.contains("Fluxion") && datformat.contains("Newton")) {
                max_datVersion += 1.0f;
            }
            if (datversion > max_datVersion) {
                if (!new AutoDialog((JFrame)null).display(this.rbundle.getString("Fehler_beim_Oeffnen_der_Projektdatei"), this.rbundle.getString("Zu_neue_Dateiversion"), this.rbundle.getString("OK"), this.rbundle.getString("Download_Website"))) {
                    Desktop.getDesktop().browse(new URI(Statics.prg_Bundle.getString("Download_link")));
                }
                return false;
            }
            if (datformat.contains("Newton")) {
                datversion -= 1.0f;
            }
        }
        String prjname = ostr.readUTF();
        this.setPrjName(prjname);
        if ((double)datversion > 2.1) {
            this.ladeMeineVariablen(ostr);
        }
        if (!(kennung = ostr.readUTF()).contains("DGLData") && !kennung.contains("ModelData")) {
            throw new Exception(this.rbundle.getString("Datei_fehlerhaft!"));
        }
        kennung = ostr.readUTF();
        if (Statics.prgName.contains("Newton") || Statics.prgName.contains("Lagrange")) {
            this.switchModel(kennung);
        }
        this.model.readData(ostr, datversion, kennung);
        this.model.calculationHasFinished(true);
        Statics.println("Model properly read.");
        kennung = ostr.readUTF();
        if (!kennung.contains("ExtrasData")) {
            throw new Exception(this.rbundle.getString("Datei_fehlerhaft!"));
        }
        this.extras.readData(ostr, datversion, kennung);
        Statics.println("Extras properly read.");
        kennung = ostr.readUTF();
        if (!kennung.contains("DiagrammData") && !kennung.contains("KSData")) {
            throw new Exception(this.rbundle.getString("Datei_fehlerhaft!"));
        }
        if (this.viewer != null) {
            this.diagramm.readDiagramm(ostr, datversion, kennung);
            Statics.println("Diagramm properly read.");
            if ((double)datversion < 2.2) {
                kennung = ostr.readUTF();
                String[] split = kennung.split("\u2666\ufe0e");
                if (!(kennung = split[0]).contains("InfoData")) {
                    throw new Exception(this.rbundle.getString("Datei_fehlerhaft!"));
                }
                int height = -1;
                int width = -1;
                int ypos = -1;
                int xpos = -1;
                try {
                    xpos = Integer.parseInt(split[1]);
                    ypos = Integer.parseInt(split[2]);
                    width = Integer.parseInt(split[3]);
                    height = Integer.parseInt(split[4]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (xpos != -1 && !Statics.prefsDialog.adjustWindowToScreen) {
                    this.windowBounds.setBounds(xpos, ypos, width, height);
                }
            }
            this.viewer.checkInfoFile();
            this.viewer.setWindowBoundsAndDividerLocation(this.windowBounds, this.sidebarDivLocFactor);
            try {
                this.tableViewSize_loaded = ostr.readInt();
            }
            catch (Exception split) {
                // empty catch block
            }
            int tabellenart = 0;
            try {
                tabellenart = ostr.readInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tabellenart < 0 || tabellenart > 3) {
                tabellenart = 0;
            }
            this.getViewer().setAktTableByType(tabellenart);
            this.modelTable.updateTab();
            this.customTable.updateTab();
        }
        return true;
    }

    public int projektLadenMitDialog() {
        String folder = "";
        String filename = "";
        JFrame frame = this.getViewer() != null ? this.getViewer().getWindow() : null;
        this.model.stopCalculation(false);
        String text = this.rbundle.getString("Waehlen_Sie_eine_Projekt-Datei_aus");
        FileDialog fileOpenDialog = new FileDialog((Frame)frame, text, 0);
        if (Statics.prefsDialog.defaultFolder.length() != 0 && this.dateiVerzeichnis.length() == 0) {
            this.dateiVerzeichnis = Statics.prefsDialog.defaultFolder;
        }
        fileOpenDialog.setDirectory(this.dateiVerzeichnis);
        fileOpenDialog.setFile(this.dateiName);
        fileOpenDialog.setFilenameFilter(new MyFilenameFilter(Statics.fileExtension));
        fileOpenDialog.setVisible(true);
        if (fileOpenDialog.getFile() == null) {
            return 1;
        }
        folder = fileOpenDialog.getDirectory();
        boolean success = this.projektLaden(folder, filename = fileOpenDialog.getFile());
        if (success) {
            return 2;
        }
        return 0;
    }

    public boolean projektLaden(String folder, String filename) {
        boolean success = false;
        Document prj = Statics.lookupProjekt(folder, filename);
        if (prj != null) {
            prj.aktivieren();
            return true;
        }
        this.dateiVerzeichnis = folder;
        this.dateiName = filename;
        this.aktivieren();
        try {
            ObjectInputStream objstr = new ObjectInputStream(new FileInputStream(new File(folder, filename)));
            success = this.ladeDaten(objstr);
            objstr.close();
            if (!success) {
                return false;
            }
        }
        catch (Exception e) {
            new AutoDialog(this.viewer.getWindow()).display(this.rbundle.getString("Fehler_beim_Oeffnen_der_Projektdatei"), e.toString(), this.rbundle.getString("OK"));
            e.printStackTrace();
            return false;
        }
        this.setChanged(false);
        if (this.getViewer() != null) {
            this.getViewer().scaleSidebar(Statics.prefsDialog.guiScale);
        }
        Statics.usedDocs.insertNewElement(filename, folder);
        return true;
    }

    public boolean projektSpeichern(boolean fragen) {
        if (fragen || this.dateiVerzeichnis.equals("")) {
            String text = this.rbundle.getString("Geben_Sie_Name_und_Ort_der_Projekt-Datei_an");
            FileDialog fileOpenDialog = new FileDialog((Frame)this.viewer.getWindow(), text, 1);
            if (Statics.prefsDialog.defaultFolder.length() != 0) {
                this.dateiVerzeichnis = Statics.prefsDialog.defaultFolder;
            }
            fileOpenDialog.setDirectory(this.dateiVerzeichnis);
            fileOpenDialog.setFile(this.adjustSuffix(this.dateiName, Statics.fileExtension));
            fileOpenDialog.setFilenameFilter(new MyFilenameFilter(Statics.fileExtension));
            fileOpenDialog.setVisible(true);
            if (fileOpenDialog.getFile() == null) {
                return false;
            }
            this.dateiVerzeichnis = fileOpenDialog.getDirectory();
            this.dateiName = fileOpenDialog.getFile();
        }
        this.dateiName = this.adjustSuffix(this.dateiName, Statics.fileExtension);
        File file = new File(this.dateiVerzeichnis, this.dateiName);
        if (file.exists()) {
            if (this.dateiVerzeichnis.equals(Statics.prefsDialog.examplesFolder_absolutePath)) {
                new AutoDialog(this.viewer.getWindow()).display("Sie versuchen eine Beispieldatei zu ver\u00e4ndern!", "Bitte die Datei unter einem anderen Namen oder an einem anderen Ort speichern.");
                return false;
            }
            if (this.dateiVerzeichnis.equals(Statics.prefsDialog.stdTemplatesFolder_absolutePath)) {
                new AutoDialog(this.viewer.getWindow()).display("Sie versuchen eine Vorlagendatei zu ver\u00e4ndern!", "Bitte die Datei unter einem anderen Namen oder an einem anderen Ort speichern.");
                return false;
            }
        }
        try (ObjectOutputStream objstr = new ObjectOutputStream(new FileOutputStream(file));){
            objstr.writeUTF(Statics.prg_Bundle.getString("DataFormat") + "\n");
            objstr.writeUTF(this.prjName);
            this.speichereMeineVariablen(objstr);
            objstr.writeUTF("\nModelData\n");
            this.model.writeData(objstr);
            objstr.writeUTF("\nExtrasData\n");
            this.extras.writeData(objstr);
            this.diagramm.writeDiagramm(objstr);
            objstr.writeInt(this.getViewer().getAnzeigePane().getWidth() - this.getViewer().getAnzeigePane().getDividerLocation());
            try {
                objstr.writeInt(this.getViewer().getAktTable().getType());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setChanged(false);
            Statics.usedDocs.insertNewElement(this.getFileName(), this.getPath());
        }
        catch (Exception e) {
            new AutoDialog(this.viewer.getWindow()).display(this.rbundle.getString("Fehler_beim_Speichern_der_Projektdatei"), e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void projektDatenAlsTextExportieren() {
        Object text = this.rbundle.getString("Geben_Sie_Name_und_Ort_der_Text-Datei_(.txt)_an");
        FileDialog fileOpenDialog = new FileDialog((Frame)this.viewer.getWindow(), (String)text, 1);
        if (Statics.prefsDialog.defaultFolder.length() != 0) {
            this.dateiVerzeichnis = Statics.prefsDialog.defaultFolder;
        }
        fileOpenDialog.setDirectory(this.dateiVerzeichnis);
        fileOpenDialog.setFile(this.adjustSuffix(this.dateiName, "txt"));
        fileOpenDialog.setFilenameFilter(new MyFilenameFilter("txt"));
        fileOpenDialog.setVisible(true);
        if (fileOpenDialog.getFile() == null) {
            return;
        }
        String fname = this.adjustSuffix(fileOpenDialog.getFile(), "txt");
        File file = new File(fileOpenDialog.getDirectory(), fname);
        try (PrintWriter pwfile = new PrintWriter(file, "UTF-8");){
            text = this.prjName + "(" + Statics.prg_Bundle.getString("DOKUMENT_ART") + ")";
            pwfile.print((String)text + "\n");
            this.model.printTextData(pwfile);
            this.extras.printTextData(pwfile);
            pwfile.flush();
        }
        catch (Exception e) {
            new AutoDialog(this.viewer.getWindow()).display(this.rbundle.getString("Fehler_beim_Speichern_der_Textdatei"), e.toString(), Statics.rBundle.getString("OK"));
        }
    }

    public void tabelleAlsTextExportieren() {
        String text = this.rbundle.getString("Geben_Sie_Name_und_Ort_der_Tabellen-Datei_(.txt)_an");
        FileDialog fileOpenDialog = new FileDialog((Frame)this.viewer.getWindow(), text, 1);
        if (Statics.prefsDialog.defaultFolder.length() != 0) {
            this.dateiVerzeichnis = Statics.prefsDialog.defaultFolder;
        }
        fileOpenDialog.setDirectory(this.dateiVerzeichnis);
        fileOpenDialog.setFile(this.adjustSuffix(this.dateiName, "txt"));
        fileOpenDialog.setFilenameFilter(new MyFilenameFilter("txt"));
        fileOpenDialog.setVisible(true);
        if (fileOpenDialog.getFile() == null) {
            return;
        }
        String fname = this.adjustSuffix(fileOpenDialog.getFile(), "txt");
        File file = new File(fileOpenDialog.getDirectory(), fname);
        try (PrintWriter pwfile = new PrintWriter(file, "UTF-8");){
            text = this.prjName;
            pwfile.print(text.concat(" (" + Statics.prg_Bundle.getString("DOKUMENT_ART") + ")\n"));
            this.model.printTextData(pwfile);
            pwfile.print("\n" + this.rbundle.getString("Wertetabelle") + ":\n");
            this.modelTable.printDataAsText(pwfile);
            if (this.customTable.tab.getTableHeader().getColumnModel().getColumnCount() > 1) {
                pwfile.print("\n" + this.rbundle.getString("Selbst_definierte_Tabelle") + ":\n");
                this.customTable.printDataAsText(pwfile);
            }
            pwfile.flush();
        }
        catch (Exception e) {
            new AutoDialog(this.viewer.getWindow()).display(this.rbundle.getString("Fehler_beim_Speichern_der_Textdatei"), e.toString(), Statics.rBundle.getString("OK"));
        }
    }

    public void exportDiagramAsPicture(String format) {
        String text = this.rbundle.getString("Geben_Sie_Name_und_Ort_der_Datei_an").replace("#", "." + format);
        FileDialog fileOpenDialog = new FileDialog((Frame)this.viewer.getWindow(), text, 1);
        if (Statics.prefsDialog.defaultFolder.length() != 0) {
            this.dateiVerzeichnis = Statics.prefsDialog.defaultFolder;
        }
        fileOpenDialog.setDirectory(this.dateiVerzeichnis);
        fileOpenDialog.setFile(this.adjustSuffix(this.dateiName, format));
        fileOpenDialog.setFilenameFilter(new MyFilenameFilter(format));
        fileOpenDialog.setVisible(true);
        if (fileOpenDialog.getFile() == null) {
            return;
        }
        for (int i = 0; i < this.diagramm.koordinatensysteme.size(); ++i) {
            Koordinatensystem ks = this.diagramm.koordinatensysteme.get(i);
            try {
                String fname;
                if (this.diagramm.koordinatensysteme.size() == 1) {
                    fname = this.adjustSuffix(fileOpenDialog.getFile(), format);
                } else {
                    String s = fileOpenDialog.getFile();
                    try {
                        s = s.substring(0, fileOpenDialog.getFile().lastIndexOf(46));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fname = this.adjustSuffix(s + "_" + (i + 1), format);
                }
                File file = new File(fileOpenDialog.getDirectory(), fname);
                AbstractVectorGraphicsIO graphics = null;
                if (format.equals("png")) {
                    ImageIO.write((RenderedImage)ks.getImage(), "png", file);
                }
                if (format.equals("jpg")) {
                    ImageIO.write((RenderedImage)ks.getImage(), "jpg", file);
                }
                graphics = null;
                if (format.equals("pdf")) {
                    graphics = new PDFGraphics2D(file, (Component)ks);
                }
                if (format.equals("svg")) {
                    graphics = new SVGGraphics2D(file, (Component)ks);
                }
                if (graphics == null) continue;
                ((VectorGraphics)graphics).startExport();
                ks.export(graphics);
                ((VectorGraphics)graphics).endExport();
                continue;
            }
            catch (Exception e) {
                new AutoDialog(this.viewer.getWindow()).display(this.rbundle.getString("Fehler_beim_Speichern_der_Bilddatei"), this.dateiName + "_" + i, Statics.rBundle.getString("OK"));
                return;
            }
        }
    }

    public String adjustSuffix(String fname, String suffix) {
        int pindex = fname.lastIndexOf(46);
        if (pindex > 0) {
            fname = fname.substring(0, pindex);
        }
        return fname + "." + suffix;
    }

    public class MyFilenameFilter
    implements FilenameFilter {
        public String extension;

        public MyFilenameFilter(String ext) {
            this.extension = ext;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        @Override
        public boolean accept(File f, String s) {
            if (s.lastIndexOf(".") > -1) {
                String fextension = s.substring(s.lastIndexOf(".") + 1);
                if (fextension == null) {
                    return false;
                }
                if (fextension.equals(this.extension)) {
                    return true;
                }
                if (this.extension.equals("fluxion") && fextension.equals("newton2")) {
                    return true;
                }
            }
            return false;
        }
    }
}

