/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.extensions.xjep.XEvaluator;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.parser.TokenMgrError;
import de.didappslib.base.Diagram;
import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Koordinatensystem3D;
import de.didappslib.base.Statics;
import de.didappslib.base.VergleichsTabelle;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.SuperSlider;
import de.didappslib.guitools.UndoableTextFieldEdit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class Extras
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Extras", Statics.locale);
    private final Document document;
    public ArrayList<SuperSlider> sliderListe = new ArrayList();
    private final ArrayList<Funktion> funktionen = new ArrayList();
    public BasicStroke fktStroke;
    protected boolean plotAll = true;
    private JMenuItem ParabSFormMI;
    private JMenuItem ParabStdFormMI;
    private JButton addKonstButton;
    private JMenuItem cosAMI;
    private JMenuItem cosFMI;
    private JMenuItem exp10MI;
    private JMenuItem expMI;
    public JCheckBox fktCBox;
    private JTextArea fktField;
    private JPanel fktPanel;
    private JScrollPane fktScrollPane;
    private JMenuItem hyperbelMI;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JMenuItem linFktMI;
    private JMenu linFktMennu;
    private JMenuItem lnlMI;
    private JMenuItem loglMI;
    private JMenuItem nParabMI;
    private JPanel paramPanel;
    private JMenuItem poly3aMI;
    private JMenuItem poly3uMI;
    private JMenuItem poly4aMI;
    private JMenuItem poly4gMI;
    private JMenu polyMenu;
    private JMenuItem propMI;
    private JButton showTabButton;
    private JMenuItem sinAMI;
    private JMenuItem sinFMI;
    private JMenu sonstMenu;
    private JMenuItem tanAMI;
    private JMenuItem tanFMI;
    private JButton templMenuButt;
    private JPopupMenu templateMenu;
    private JMenu trigMenu;
    public JCheckBox werteCBox;
    private JLabel werteLabel;
    private JPanel wertePanel;

    public Extras(Document doc) {
        this.document = doc;
        this.initComponents();
        this.addKonstButton.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/plus", 1.0f));
        this.addKonstButton.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/plus_dk", 1.0f));
        this.fktField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.templMenuButt.setVisible(false);
        this.fktScrollPane.setVisible(false);
        this.paramPanel.setVisible(false);
        this.showTabButton.setVisible(false);
        this.neu();
    }

    private void initComponents() {
        this.templateMenu = new JPopupMenu();
        this.linFktMennu = new JMenu();
        this.propMI = new JMenuItem();
        this.linFktMI = new JMenuItem();
        this.polyMenu = new JMenu();
        this.nParabMI = new JMenuItem();
        this.ParabSFormMI = new JMenuItem();
        this.ParabStdFormMI = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.poly3uMI = new JMenuItem();
        this.poly3aMI = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.poly4gMI = new JMenuItem();
        this.poly4aMI = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.trigMenu = new JMenu();
        this.sinFMI = new JMenuItem();
        this.sinAMI = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.cosFMI = new JMenuItem();
        this.cosAMI = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.tanFMI = new JMenuItem();
        this.tanAMI = new JMenuItem();
        this.sonstMenu = new JMenu();
        this.hyperbelMI = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.exp10MI = new JMenuItem();
        this.expMI = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.loglMI = new JMenuItem();
        this.lnlMI = new JMenuItem();
        this.fktPanel = new JPanel();
        this.fktCBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.templMenuButt = new JButton();
        this.fktScrollPane = new JScrollPane();
        this.fktField = new JTextArea();
        this.paramPanel = new JPanel();
        this.addKonstButton = new JButton();
        this.wertePanel = new JPanel();
        this.werteCBox = new JCheckBox();
        this.werteLabel = new JLabel();
        this.showTabButton = new JButton();
        this.linFktMennu.setText(rbundle.getString("lineare_Funktionen"));
        this.propMI.setText(rbundle.getString("prop_MI"));
        this.propMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.propMIActionPerformed(evt);
            }
        });
        this.linFktMennu.add(this.propMI);
        this.linFktMI.setText(rbundle.getString("linFktMI"));
        this.linFktMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.linFktMIActionPerformed(evt);
            }
        });
        this.linFktMennu.add(this.linFktMI);
        this.templateMenu.add(this.linFktMennu);
        this.polyMenu.setText(rbundle.getString("Polynomfunktionen"));
        this.nParabMI.setText(rbundle.getString("ParabelVFaktMI"));
        this.nParabMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.nParabMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.nParabMI);
        this.ParabSFormMI.setText(rbundle.getString("ParabelSFormMI"));
        this.ParabSFormMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.ParabSFormMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.ParabSFormMI);
        this.ParabStdFormMI.setText(rbundle.getString("ParabelStdMI"));
        this.ParabStdFormMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.ParabStdFormMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.ParabStdFormMI);
        this.polyMenu.add(this.jSeparator4);
        this.poly3uMI.setText(rbundle.getString("Polynom3.Grad(ungerade)MI"));
        this.poly3uMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.poly3uMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.poly3uMI);
        this.poly3aMI.setText(rbundle.getString("Polynom3.GradAllgMI"));
        this.poly3aMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.poly3aMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.poly3aMI);
        this.polyMenu.add(this.jSeparator2);
        this.poly4gMI.setText(rbundle.getString("Polynom4.Grad(gerade)MI"));
        this.poly4gMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.poly4gMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.poly4gMI);
        this.poly4aMI.setText(rbundle.getString("Polynom4.Grad(allg)MI"));
        this.poly4aMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.poly4aMIActionPerformed(evt);
            }
        });
        this.polyMenu.add(this.poly4aMI);
        this.templateMenu.add(this.polyMenu);
        this.templateMenu.add(this.jSeparator1);
        this.trigMenu.setText(rbundle.getString("trig_Fkt"));
        this.sinFMI.setText(rbundle.getString("SinusVFaktMI"));
        this.sinFMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.sinFMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.sinFMI);
        this.sinAMI.setText(rbundle.getString("SinusAllgMI"));
        this.sinAMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.sinAMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.sinAMI);
        this.trigMenu.add(this.jSeparator5);
        this.cosFMI.setText(rbundle.getString("KosinunsVFaktMI"));
        this.cosFMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.cosFMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.cosFMI);
        this.cosAMI.setText(rbundle.getString("KosinusAllg"));
        this.cosAMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.cosAMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.cosAMI);
        this.trigMenu.add(this.jSeparator6);
        this.tanFMI.setText(rbundle.getString("TangensVorfaktMI"));
        this.tanFMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.tanFMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.tanFMI);
        this.tanAMI.setText(rbundle.getString("TangensAllgMI"));
        this.tanAMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.tanAMIActionPerformed(evt);
            }
        });
        this.trigMenu.add(this.tanAMI);
        this.templateMenu.add(this.trigMenu);
        this.sonstMenu.setText(rbundle.getString("sonst_Fkt"));
        this.hyperbelMI.setText(rbundle.getString("HyperbelMI"));
        this.hyperbelMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.hyperbelMIActionPerformed(evt);
            }
        });
        this.sonstMenu.add(this.hyperbelMI);
        this.sonstMenu.add(this.jSeparator3);
        this.exp10MI.setText(rbundle.getString("ExpFkt10MI"));
        this.exp10MI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.exp10MIActionPerformed(evt);
            }
        });
        this.sonstMenu.add(this.exp10MI);
        this.expMI.setText(rbundle.getString("ExpEMI"));
        this.expMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.expMIActionPerformed(evt);
            }
        });
        this.sonstMenu.add(this.expMI);
        this.sonstMenu.add(this.jSeparator7);
        this.loglMI.setText(rbundle.getString("Log10MI"));
        this.loglMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.loglMIActionPerformed(evt);
            }
        });
        this.sonstMenu.add(this.loglMI);
        this.lnlMI.setText(rbundle.getString("lnMI"));
        this.lnlMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.lnlMIActionPerformed(evt);
            }
        });
        this.sonstMenu.add(this.lnlMI);
        this.templateMenu.add(this.sonstMenu);
        this.setBackground(Statics.sidebarBackColor);
        this.setLayout(new GridBagLayout());
        this.fktPanel.setBackground(Statics.sidebarBackColor);
        this.fktPanel.setLayout(new GridBagLayout());
        this.fktCBox.setBackground(new Color(222, 222, 222));
        this.fktCBox.setToolTipText(rbundle.getString("Vergleichsfunktion_TIP"));
        this.fktCBox.setContentAreaFilled(false);
        this.fktCBox.setMargin(new Insets(0, 0, 0, 0));
        this.fktCBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Extras.this.fktCBoxItemStateChanged(evt);
            }
        });
        this.fktCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.fktCBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.fktPanel.add((Component)this.fktCBox, gridBagConstraints);
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setForeground(new Color(40, 40, 40));
        this.jLabel1.setText(rbundle.getString("Vergleichsfunktion"));
        this.jLabel1.setToolTipText(rbundle.getString("Vergleichsfunktion_TIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.fktPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.templMenuButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/dreieckrunter_kl.png")));
        this.templMenuButt.setToolTipText(rbundle.getString("VerglFktTemplateMenuButton_TIP"));
        this.templMenuButt.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51)));
        this.templMenuButt.setBorderPainted(false);
        this.templMenuButt.setContentAreaFilled(false);
        this.templMenuButt.setMargin(new Insets(0, 0, 0, 2));
        this.templMenuButt.setMaximumSize(new Dimension(12, 12));
        this.templMenuButt.setMinimumSize(new Dimension(12, 12));
        this.templMenuButt.setPreferredSize(new Dimension(13, 9));
        this.templMenuButt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Extras.this.templMenuButtMousePressed(evt);
            }
        });
        this.templMenuButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.templMenuButtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 100.0;
        this.fktPanel.add((Component)this.templMenuButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.fktPanel, gridBagConstraints);
        this.fktScrollPane.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.fktScrollPane.setVerticalScrollBarPolicy(21);
        this.fktScrollPane.setAlignmentX(0.0f);
        this.fktScrollPane.setAlignmentY(0.0f);
        this.fktField.setBackground(new Color(249, 249, 249));
        this.fktField.setFont(new Font("Serif", 2, 15));
        this.fktField.setTabSize(4);
        this.fktField.setToolTipText(rbundle.getString("VerglFktField_TIP"));
        this.fktField.setMargin(new Insets(1, 3, 1, 2));
        this.fktField.setMinimumSize(new Dimension(10, 16));
        this.fktField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Extras.this.fktFieldKeyTyped(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                Extras.this.fktFieldKeyReleased(evt);
            }
        });
        this.fktScrollPane.setViewportView(this.fktField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        this.add((Component)this.fktScrollPane, gridBagConstraints);
        this.paramPanel.setBackground(new Color(222, 222, 222));
        this.paramPanel.setMaximumSize(new Dimension(255, 16));
        this.paramPanel.setName("dummy");
        this.paramPanel.setOpaque(false);
        this.paramPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Extras.this.paramPanelPropChanged(evt);
            }
        });
        this.paramPanel.setLayout(new GridBagLayout());
        this.addKonstButton.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/plus.png")));
        this.addKonstButton.setBorderPainted(false);
        this.addKonstButton.setContentAreaFilled(false);
        this.addKonstButton.setMargin(new Insets(0, 0, 0, 0));
        this.addKonstButton.setMaximumSize(new Dimension(16, 16));
        this.addKonstButton.setMinimumSize(new Dimension(12, 12));
        this.addKonstButton.setPreferredSize(new Dimension(12, 12));
        this.addKonstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.addKonstButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.paramPanel.add((Component)this.addKonstButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.paramPanel, gridBagConstraints);
        this.wertePanel.setOpaque(false);
        this.wertePanel.setLayout(new GridBagLayout());
        this.werteCBox.setBackground(new Color(222, 222, 222));
        this.werteCBox.setToolTipText(rbundle.getString("Vergleichswerte_TIP"));
        this.werteCBox.setContentAreaFilled(false);
        this.werteCBox.setMargin(new Insets(0, 0, 0, 0));
        this.werteCBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Extras.this.werteCBoxItemStateChanged(evt);
            }
        });
        this.werteCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.werteCBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.wertePanel.add((Component)this.werteCBox, gridBagConstraints);
        this.werteLabel.setFont(new Font("Lucida Grande", 1, 13));
        this.werteLabel.setForeground(new Color(40, 40, 40));
        this.werteLabel.setText(rbundle.getString("Vergleichswerte"));
        this.werteLabel.setToolTipText(rbundle.getString("Vergleichswerte_TIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.wertePanel.add((Component)this.werteLabel, gridBagConstraints);
        this.showTabButton.setBackground(Statics.sidebarBackColor);
        this.showTabButton.setFont(this.showTabButton.getFont().deriveFont((float)this.showTabButton.getFont().getSize() - 2.0f));
        this.showTabButton.setText(rbundle.getString("einblenden"));
        this.showTabButton.setToolTipText(rbundle.getString("VWerteTabeinblenden_TIP"));
        this.showTabButton.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.showTabButton.setMargin(new Insets(1, 14, 1, 14));
        this.showTabButton.setOpaque(true);
        this.showTabButton.setPreferredSize(new Dimension(110, 16));
        this.showTabButton.setRolloverEnabled(true);
        this.showTabButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Extras.this.showTabButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Extras.this.showTabButtonMouseExited(evt);
            }
        });
        this.showTabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extras.this.showTabButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(2, 0, 2, 3);
        this.wertePanel.add((Component)this.showTabButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.wertePanel, gridBagConstraints);
    }

    private void werteCBoxItemStateChanged(ItemEvent evt) {
        this.showTabButton.setVisible(this.werteCBox.isSelected());
    }

    private void fktCBoxItemStateChanged(ItemEvent evt) {
        this.templMenuButt.setVisible(this.fktCBox.isSelected());
        this.fktScrollPane.setVisible(this.fktCBox.isSelected());
        this.paramPanel.setVisible(this.fktCBox.isSelected());
        this.document.setChanged(true);
        if (this.document.getDiagramm().koordinatensysteme.get(0) instanceof Koordinatensystem3D) {
            if (this.fktCBox.isSelected()) {
                this.document.warningMsg(rbundle.getString("Hinweis"), rbundle.getString("In_3D_keine_Funktionen"));
            } else {
                this.document.clrError();
            }
            return;
        }
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void paramPanelPropChanged(PropertyChangeEvent evt) {
        if (evt.getPropertyName().startsWith("NameChanged")) {
            this.document.setChanged(true);
            this.werteAuslesenVglFkt(false);
        }
        if (evt.getPropertyName().contains("SuperSliderValueChanged")) {
            this.document.setChanged(true);
        }
        if (evt.getPropertyName().startsWith("Deleted")) {
            String ss = evt.getPropertyName().substring(8);
            for (SuperSlider sliderListe1 : this.sliderListe) {
                if (!sliderListe1.getName().equals(ss)) continue;
                this.konstanteWeg(sliderListe1);
                break;
            }
            this.document.setChanged(true);
        }
        if (evt.getPropertyName().startsWith("ActionEvent")) {
            this.document.setChanged(true);
        }
        this.document.getDiagramm().redrawDiagram();
    }

    private void addKonstButtonActionPerformed(ActionEvent evt) {
        if (this.sliderListe.size() < 9) {
            this.konstanteHinzu(GreekLetterConstPanel.applySmartInputOnLoad("c_" + (this.sliderListe.size() + 1)), 1.0, 0.0, 2.0);
        } else {
            this.konstanteHinzu("c" + (this.sliderListe.size() + 1), 1.0, 0.0, 2.0);
        }
        this.document.getDiagramm().redrawDiagram();
    }

    private void fktFieldKeyReleased(KeyEvent evt) {
        JTextComponent tf = (JTextComponent)evt.getSource();
        GreekLetterConstPanel.tfInputHook(tf);
        if (tf.getName().equals(tf.getText())) {
            return;
        }
        this.document.getViewer().addEdit(new UndoableTextFieldEdit(tf, tf.getName(), tf.getText()));
        tf.setName(tf.getText());
        this.document.setChanged(true);
        this.werteAuslesenVglFkt(false);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void fktFieldKeyTyped(KeyEvent evt) {
        int rows;
        JTextComponent tf = (JTextComponent)evt.getSource();
        int lines = ((JTextArea)tf).getLineCount();
        if (lines != (rows = ((JTextArea)tf).getRows())) {
            ((JTextArea)tf).setRows(lines);
            this.document.getViewer().validate();
        }
    }

    private void propMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("C", 1.0, 0.0, 5.0);
        this.insertToFktField(var + "(" + uvar + ") = C*" + uvar);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void linFktMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -1.0, 1.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + " + B");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void nParabMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "\u00b2");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void ParabSFormMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*(" + uvar + "-B)\u00b2+C");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void ParabStdFormMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "\u00b2+B*" + uvar + "+C");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void poly3uMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "\u00b3+B*" + uvar + "+C");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void poly3aMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.konstanteHinzu("D", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "\u00b3+B*" + uvar + "\u00b2+C*" + uvar + "+D");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void poly4gMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "^4+B*" + uvar + "\u00b2+C");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void sinFMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spez = "A";
        if (uvar.equals("t")) {
            spez = "\\omega_0";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spez), 0.5, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*sin(" + spez + "*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void sinAMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spezb = "B";
        String spezc = "C";
        if (uvar.equals("t")) {
            spezb = "\\omega_0";
            spezc = "B";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spezb), 0.5, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr("\\phi_0"), 1.0, -2.0, 2.0);
        this.konstanteHinzu(spezc, 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*sin(" + spezb + "*" + uvar + "+\\phi_0)+" + spezc);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void hyperbelMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*1/" + uvar);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void poly4aMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.konstanteHinzu("C", 1.0, -2.0, 2.0);
        this.konstanteHinzu("D", 1.0, -2.0, 2.0);
        this.konstanteHinzu("E", 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*" + uvar + "^4+B*" + uvar + "\u00b3+C*" + uvar + "\u00b2+D*" + uvar + "+E");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void cosFMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spez = "B";
        if (uvar.equals("t")) {
            spez = "\\omega_0";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spez), 0.5, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*cos(" + spez + "*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void cosAMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spezb = "B";
        String spezc = "C";
        if (uvar.equals("t")) {
            spezb = "\\omega_0";
            spezc = "B";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spezb), 0.5, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr("\\phi_0"), 1.0, -2.0, 2.0);
        this.konstanteHinzu(spezc, 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*cos(" + spezb + "*" + uvar + "+\\phi_0)+" + spezc);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void tanFMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spez = "B";
        if (uvar.equals("t")) {
            spez = "\\omega_0";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spez), 0.5, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*tan(" + spez + "*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void tanAMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        String spezb = "B";
        String spezc = "C";
        if (uvar.equals("t")) {
            spezb = "\\omega_0";
            spezc = "B";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr(spezb), 0.5, -2.0, 2.0);
        this.konstanteHinzu(GreekLetterConstPanel.factorASCIIStr("\\phi_0"), 1.0, -2.0, 2.0);
        this.konstanteHinzu(spezc, 1.0, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*tan(" + spezb + "*" + uvar + "+\\phi_0)+" + spezc);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void loglMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 1.0, 0.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*log(B*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void lnlMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 1.0, 0.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*ln(B*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void templMenuButtMousePressed(MouseEvent evt) {
        if (this.templMenuButt.isEnabled()) {
            this.templateMenu.show(this.templMenuButt, 5, 2);
        }
    }

    private void templMenuButtActionPerformed(ActionEvent evt) {
    }

    private void showTabButtonActionPerformed(ActionEvent evt) {
        this.document.getViewer().showVWerteTab();
    }

    private void exp10MIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, 0.0, 1.0);
        this.insertToFktField(var + "(" + uvar + ") = A*10^(B*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void expMIActionPerformed(ActionEvent evt) {
        String var;
        String uvar = this.document.getModel().getVarName(0);
        if (uvar.length() == 0) {
            uvar = "t";
        }
        if ((var = this.document.getModel().getVarName(1)).length() == 0) {
            var = "x";
        }
        this.konstanteHinzu("A", 1.0, -2.0, 2.0);
        this.konstanteHinzu("B", 0.5, -2.0, 2.0);
        this.insertToFktField(var + "(" + uvar + ") = A*exp(B*" + uvar + ")");
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void showTabButtonMouseEntered(MouseEvent evt) {
        this.showTabButton.setBackground(Statics.sidebarBackButtColor_ro);
    }

    private void showTabButtonMouseExited(MouseEvent evt) {
        this.showTabButton.setBackground(Statics.sidebarButtColor);
    }

    private void werteCBoxActionPerformed(ActionEvent evt) {
        this.showTabButton.setVisible(this.werteCBox.isSelected());
        this.document.setChanged(true);
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void fktCBoxActionPerformed(ActionEvent evt) {
        this.templMenuButt.setVisible(this.fktCBox.isSelected());
        this.fktScrollPane.setVisible(this.fktCBox.isSelected());
        this.paramPanel.setVisible(this.fktCBox.isSelected());
        this.document.setChanged(true);
        if (this.document.getDiagramm().koordinatensysteme.get(0) instanceof Koordinatensystem3D) {
            if (this.fktCBox.isSelected()) {
                this.document.warningMsg(rbundle.getString("Hinweis"), rbundle.getString("In_3D_keine_Funktionen"));
            } else {
                this.document.clrError();
            }
            return;
        }
        this.document.getDiagramm().updateDiagramPlus();
    }

    private void insertToFktField(String txt) {
        if (this.fktField.getSelectedText() != null) {
            this.fktField.replaceSelection(GreekLetterConstPanel.factorASCIIStr(txt));
            return;
        }
        if (this.fktField.getText().length() > 0) {
            this.fktField.setText(this.fktField.getText() + "; " + GreekLetterConstPanel.factorASCIIStr(txt));
        } else {
            this.fktField.setText(GreekLetterConstPanel.factorASCIIStr(txt));
        }
    }

    public void konstanteHinzu(String n, double v, double mi, double ma) {
        boolean inListe = false;
        for (SuperSlider el : this.sliderListe) {
            if (!el.getName().equals(n)) continue;
            inListe = true;
        }
        if (inListe) {
            return;
        }
        this.sliderListe.add(new SuperSlider(n, v, mi, ma, this.document.getViewer()));
        this.updateParamPanel();
        this.document.getModel().werteAuslesen(false);
        this.werteAuslesenVglFkt(false);
    }

    public void konstanteWeg(SuperSlider slider) {
        this.document.getModel().parser.getVariableTable().remove(slider.getName());
        this.sliderListe.remove(slider);
        this.updateParamPanel();
        this.document.getModel().werteAuslesen(false);
        this.werteAuslesenVglFkt(false);
    }

    private void updateParamPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 18;
        SuperSlider slider = null;
        this.paramPanel.removeAll();
        int i = 0;
        while (i < this.sliderListe.size()) {
            slider = this.sliderListe.get(i);
            gridBagConstraints.gridy = i++;
            gridBagConstraints.fill = 2;
            this.paramPanel.add((Component)slider, gridBagConstraints);
            slider.resize(Statics.prefsDialog.guiScale);
        }
        if (this.document.isEditierbar()) {
            if (slider == null) {
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(1, 3, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                this.paramPanel.add((Component)this.addKonstButton, gridBagConstraints);
            } else {
                slider.adjustAddKonstButton(this.addKonstButton);
            }
        }
        this.addKonstButton.setEnabled(this.document.isEditierbar());
        this.fktField.setRows(this.fktField.getLineCount());
        if (this.document.getViewer() != null) {
            this.document.getViewer().validateSidebar();
        }
        this.document.setChanged(true);
    }

    public void panelResized() {
        float scale = Statics.prefsDialog.guiScale;
        float newLabFontSize = (float)Statics.labelFontSize * scale * (scale == 1.0f ? 1.0f : 0.98f);
        float newFieldFontSize = (float)Statics.mathFontSize * scale * (scale == 1.0f ? 1.0f : 1.05f);
        this.compChangeFont(this.fktCBox, newLabFontSize);
        this.compChangeFont(this.jLabel1, newLabFontSize);
        this.compChangeFont(this.fktField, newFieldFontSize);
        this.sliderListe.forEach(slider -> slider.resize(scale));
        this.compChangeFont(this.werteCBox, newLabFontSize);
        this.compChangeFont(this.werteLabel, newLabFontSize);
        this.showTabButton.setPreferredSize(new Dimension((int)(110.0f * scale), (int)(16.0f * scale)));
        this.compChangeFont(this.showTabButton, 11.0f * scale);
    }

    private void compChangeFont(JComponent comp, float newSize) {
        comp.setFont(comp.getFont().deriveFont(newSize));
    }

    private Funktion parseFunctionText(XJep parser, String inputstring) throws Exception {
        Funktion fkt = new Funktion();
        String[] inputs = inputstring.split(":");
        String input = inputs[0];
        int pos1 = (input = input.trim()).indexOf("(");
        if (pos1 < 1 && input.length() > 0) {
            throw new Exception(rbundle.getString("Keine_Klammerauf_gefunden"));
        }
        fkt.fktName = input.substring(0, pos1).trim();
        int pos2 = input.indexOf(")");
        if (pos2 < 1) {
            throw new Exception(rbundle.getString("Keine_Klammerzu_gefunden"));
        }
        fkt.varName = input.substring(pos1 + 1, pos2).trim();
        if (fkt.varName.isEmpty()) {
            throw new Exception(rbundle.getString("Funktionsvaiable_fehlt"));
        }
        pos1 = input.indexOf("=");
        if (pos1 < 1) {
            throw new Exception(rbundle.getString("Kein_Gleichheitszeichen"));
        }
        String s = input.substring(pos1 + 1, input.length());
        fkt.fktNode = parser.parse(GreekLetterConstPanel.refactorStr(s));
        fkt.fktNode = parser.preprocess(fkt.fktNode);
        if (inputs.length == 2) {
            input = inputs[1];
            pos1 = (input = input.trim()).indexOf("=");
            if (pos1 < 1) {
                throw new Exception(rbundle.getString("Kein_Gleichheitszeichen"));
            }
            fkt.varName = input.substring(0, pos1).trim();
            pos2 = input.indexOf("...");
            if (pos2 < 1) {
                throw new Exception(rbundle.getString("Keine_'...'"));
            }
            Node node = parser.parse(input.substring(pos1 + 1, pos2).replace(',', '.'));
            fkt.varVon = (Double)parser.evaluate(node);
            pos1 = input.indexOf("#");
            node = parser.parse(input.substring(pos2 + 3).replace(',', '.'));
            fkt.varBis = (Double)parser.evaluate(node);
        }
        return fkt;
    }

    private boolean werteAuslesenVglFkt(boolean verbose) {
        if (!this.fktCBox.isSelected()) {
            return false;
        }
        this.document.getModel().sliderParsen(verbose);
        String input = this.fktField.getText().replace("\t", " ").replace("\n", ";");
        if (input.length() != 0) {
            try {
                while ((input = input.trim().replace("; ", ";")).contains("; ")) {
                }
                while ((input = input.replace(";;", ";")).contains(";;")) {
                }
                String[] inputs = input.split(";");
                this.funktionen.clear();
                for (String input1 : inputs) {
                    Funktion fkt = this.parseFunctionText(this.document.getModel().parser, input1);
                    if (fkt == null) continue;
                    this.funktionen.add(fkt);
                }
                this.document.clrErrColor(this.fktField);
            }
            catch (TokenMgrError e) {
                this.document.errorMsg(rbundle.getString("Fehlerhafte_Definition!"), Statics.translateErrMsg(e.getMessage()), this.fktField, verbose);
                return false;
            }
            catch (Exception e) {
                this.document.errorMsg(rbundle.getString("Fehlerhafte_Definition!"), Statics.translateErrMsg(e.getMessage().replace("\n", "  ")), this.fktField, verbose);
                return false;
            }
        }
        try {
            Iterator<Funktion> iterator = this.funktionen.iterator();
            while (iterator.hasNext()) {
                Funktion funktionen1;
                Funktion fkt = funktionen1 = iterator.next();
                this.document.getModel().parser.addVariable(fkt.varName, fkt.varVon);
                this.document.getModel().parser.evaluate(fkt.fktNode);
            }
            this.document.clrErrColor(this.fktField);
        }
        catch (StackOverflowError e) {
            this.document.errorMsg(rbundle.getString("Die_Definition_der_Funktion_ist_fehlerhaft!"), rbundle.getString("Etwas_ist_durch_sich_selbst_definiert!"), this.fktField, verbose);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(rbundle.getString("Kann_die_Funktion_nicht_berechnen!"), Statics.translateErrMsg(e.getLocalizedMessage()), this.fktField, verbose);
            return false;
        }
        return true;
    }

    public void createFunctionPlotArray(Koordinatensystem ks) {
        Funktion fkt;
        if (!this.showFunction()) {
            return;
        }
        for (int i = 0; i < this.funktionen.size(); ++i) {
            fkt = this.funktionen.get(i);
            fkt.polygons.clear();
        }
        XJep parser = this.document.getModel().parser;
        if (ks == null || parser == null) {
            return;
        }
        ((XEvaluator)parser.getEvaluator()).setForce(false);
        if (!this.werteAuslesenVglFkt(false)) {
            return;
        }
        if (!ks.parseAchsen(parser)) {
            return;
        }
        Set<Variable> varvec_x = parser.getVarsInEquation(ks.xnode);
        for (int f_index = 0; f_index < this.funktionen.size(); ++f_index) {
            fkt = this.funktionen.get(f_index);
            block6: for (int jj = 0; jj < ks.ynodes.size(); ++jj) {
                double drv;
                double rvar;
                Set<Variable> varvec = parser.getVarsInEquation(ks.ynodes.get(jj));
                if (!this.varNameInVariableVector(varvec, fkt.fktName) || !this.varNameInVariableVector(varvec_x, fkt.varName)) continue;
                Polygon pol = new Polygon();
                fkt.polygons.add(pol);
                int stepnum = fkt.varSteps;
                if (stepnum < 0) {
                    stepnum = ks.getWidth();
                }
                if (Double.isNaN(fkt.varVon) || Double.isNaN(fkt.varBis)) {
                    rvar = ks.XMin;
                    drv = (ks.XMax - rvar) / (double)(stepnum - 1);
                } else {
                    rvar = fkt.varVon;
                    stepnum = ks.XyToScreen((double)fkt.varBis, (double)1.0).x - ks.XyToScreen((double)fkt.varVon, (double)1.0).x;
                    drv = (fkt.varBis - fkt.varVon) / (double)(stepnum - 1);
                }
                for (int i = 0; i < stepnum; ++i) {
                    try {
                        parser.addVariable(fkt.varName, rvar);
                        parser.addVariable(fkt.fktName, parser.evaluate(fkt.fktNode));
                        Point point = ks.XyToImage((Double)parser.evaluate(ks.xnode), (Double)parser.evaluate(ks.ynodes.get(jj)));
                        pol.addPoint(point.x, point.y);
                    }
                    catch (StackOverflowError e) {
                        this.document.errorMsg(rbundle.getString("Die_Definition_der_Funktion_ist_fehlerhaft!"), rbundle.getString("Etwas_ist_durch_sich_selbst_definiert!"), this.fktField, false);
                        continue block6;
                    }
                    catch (ClassCastException e) {
                    }
                    catch (Exception ex) {
                        this.document.errorMsg(rbundle.getString("Kann_die_Funktion_nicht_berechnen!"), ex.getLocalizedMessage(), this.fktField, false);
                        continue block6;
                    }
                    rvar += drv;
                }
            }
        }
        ((XEvaluator)parser.getEvaluator()).setForce(true);
    }

    public void createWertePlotArray(Koordinatensystem ks) {
        int j;
        int j2;
        String s;
        Double value = null;
        VergleichsTabelle vtabelle = this.document.getCompValTable();
        if (!this.showVglWerte()) {
            return;
        }
        XJep parser = this.document.getModel().parser;
        if (parser == null) {
            return;
        }
        ((XEvaluator)parser.getEvaluator()).setForce(false);
        int wAnzahl = vtabelle.tab.getRowCount();
        Object[] vars = parser.getVarsInEquation(ks.xnode).toArray();
        boolean gefunden = false;
        Object[] objectArray = vars;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object var = objectArray[i];
            s = var.toString();
            s = s.substring(0, s.indexOf(":"));
            for (j2 = 0; j2 < vtabelle.tab.getColumnCount(); ++j2) {
                if (!s.equals(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j2)))) continue;
                gefunden = true;
            }
        }
        if (!gefunden) {
            ks.wertePlotArray = new double[0][3];
            return;
        }
        ks.wertePlotArray = ks instanceof Koordinatensystem3D ? new double[wAnzahl][3] : new double[wAnzahl][1 + ks.ynodes.size()];
        for (int i = 0; i < wAnzahl; ++i) {
            try {
                for (j = 0; j < vtabelle.tab.getColumnCount(); ++j) {
                    value = (Double)vtabelle.tab.getValueAt(i, j);
                    if (value == null) {
                        value = Double.NaN;
                    }
                    parser.addVariable(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j)), value);
                }
                ks.wertePlotArray[i][0] = (Double)parser.evaluate(ks.xnode);
                continue;
            }
            catch (Exception e) {
                if (e.getMessage().contains("null value")) continue;
                this.document.errorMsg(rbundle.getString("Fehler_bei_der_Berechnung_der_Vergleichswerte_fuer_das_Diagramm!"), e.getMessage(), null, false);
            }
        }
        if (ks instanceof Koordinatensystem3D) {
            gefunden = false;
            for (Object var : vars = parser.getVarsInEquation(ks.ynode).toArray()) {
                s = var.toString();
                s = s.substring(0, s.indexOf(":"));
                for (j2 = 0; j2 < vtabelle.tab.getColumnCount(); ++j2) {
                    if (!s.equals(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j2)))) continue;
                    gefunden = true;
                }
            }
            for (int i = 0; i < wAnzahl; ++i) {
                ks.wertePlotArray[i][1] = Double.NaN;
                if (!gefunden) continue;
                try {
                    for (j = 0; j < vtabelle.tab.getColumnCount(); ++j) {
                        value = (Double)vtabelle.tab.getValueAt(i, j);
                        if (value == null) continue;
                        parser.addVariable(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j)), value);
                    }
                    ks.wertePlotArray[i][1] = (Double)parser.evaluate(ks.ynode);
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage().contains("null value")) continue;
                    this.document.errorMsg(rbundle.getString("Fehler_bei_der_Berechnung_der_Vergleichswerte_fuer_das_Diagramm!"), e.getMessage(), null, false);
                }
            }
            gefunden = false;
            for (Object var : vars = parser.getVarsInEquation(ks.znode).toArray()) {
                s = var.toString();
                s = s.substring(0, s.indexOf(":"));
                for (j2 = 0; j2 < vtabelle.tab.getColumnCount(); ++j2) {
                    if (!s.equals(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j2)))) continue;
                    gefunden = true;
                }
            }
            for (int i = 0; i < wAnzahl; ++i) {
                ks.wertePlotArray[i][2] = Double.NaN;
                if (!gefunden) continue;
                try {
                    for (j = 0; j < vtabelle.tab.getColumnCount(); ++j) {
                        value = (Double)vtabelle.tab.getValueAt(i, j);
                        if (value == null) continue;
                        parser.addVariable(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j)), value);
                    }
                    ks.wertePlotArray[i][2] = (Double)parser.evaluate(ks.znode);
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage().contains("null value")) continue;
                    this.document.errorMsg(rbundle.getString("Fehler_bei_der_Berechnung_der_Vergleichswerte_fuer_das_Diagramm!"), e.getMessage(), null, false);
                }
            }
        } else {
            for (int jj = 0; jj < ks.ynodes.size(); ++jj) {
                int gefundeneSpalte = -1;
                block21: for (Object var : vars = parser.getVarsInEquation(ks.ynodes.get(jj)).toArray()) {
                    s = ((Variable)var).getName();
                    for (int j3 = 0; j3 < vtabelle.tab.getColumnCount(); ++j3) {
                        if (!s.equals(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(j3)))) continue;
                        gefundeneSpalte = j3;
                        continue block21;
                    }
                }
                for (int i = 0; i < wAnzahl; ++i) {
                    ks.wertePlotArray[i][1 + jj] = Double.NaN;
                    if (gefundeneSpalte == -1) continue;
                    try {
                        value = (Double)vtabelle.tab.getValueAt(i, gefundeneSpalte);
                        if (value != null) {
                            parser.addVariable(GreekLetterConstPanel.refactorStr(vtabelle.tab.getColumnName(gefundeneSpalte)), value);
                        }
                        ks.wertePlotArray[i][1 + jj] = (Double)parser.evaluate(ks.ynodes.get(jj));
                        continue;
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("null value")) continue;
                        this.document.errorMsg(rbundle.getString("Fehler_bei_der_Berechnung_der_Vergleichswerte_fuer_das_Diagramm!"), e.getMessage(), null, false);
                    }
                }
            }
        }
        ((XEvaluator)parser.getEvaluator()).setForce(true);
    }

    private boolean isInKS(Point p, Koordinatensystem ks) {
        boolean b = false;
        if (p.x > 0 && p.x < ks.getImage().getWidth() && p.y > 0 && p.y < ks.getImage().getHeight()) {
            return true;
        }
        return b;
    }

    private boolean varNameInVariableVector(Set<Variable> varset, String vname) {
        Object[] vars;
        for (Object v : vars = varset.toArray()) {
            String s = v.toString();
            if (!(s = s.substring(0, s.indexOf(":"))).equals(vname)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnFktGraph(Point point, double sf) {
        point.x = (int)((double)point.x * sf);
        point.y = (int)((double)point.y * sf);
        for (Funktion fkt : this.funktionen) {
            for (Polygon pol : fkt.polygons) {
                for (int i = 1; i < pol.npoints; ++i) {
                    if (!(Line2D.ptSegDist(pol.xpoints[i - 1], pol.ypoints[i - 1], pol.xpoints[i], pol.ypoints[i], point.x, point.y) < 3.0 * sf)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void zeichneFkt(Koordinatensystem ks, Graphics g) {
        ks.fktPlotted = false;
        if (!this.showFunction()) {
            return;
        }
        this.createFunctionPlotArray(ks);
        Graphics2D g2 = (Graphics2D)g;
        float gscale = Statics.prefsDialog.graphicsScale * ks.getScale();
        float lSt = (float)this.document.fktBreite * gscale;
        if (lSt < 1.0f) {
            lSt = 1.0f;
        }
        if (this.document.fktStrichelung > 0) {
            float[] dash1 = new float[]{(float)this.document.fktStrichelung * lSt, (float)this.document.fktStrichelung * lSt};
            if (this.document.fktStrichelung > 4) {
                dash1[1] = (float)(this.document.fktStrichelung / 2) * lSt;
            }
            this.fktStroke = new BasicStroke(lSt, 0, 0, lSt, dash1, 0.0f);
        } else {
            this.fktStroke = new BasicStroke(lSt, 0, 0, lSt);
        }
        g2.setStroke(this.fktStroke);
        g2.setColor(Diagram.colorArray[this.document.fktFarbIndex]);
        this.funktionen.forEach(fkt -> fkt.polygons.forEach(pol -> {
            g2.drawPolyline(pol.xpoints, pol.ypoints, pol.npoints);
            ks.fktPlotted = true;
        }));
    }

    public void zeichneVglWerte(Koordinatensystem ks, Graphics g) {
        ks.wertePlotted = false;
        if (!this.showVglWerte() || ks.wertePlotArray.length < 1) {
            return;
        }
        Statics.print("zeichneVglWerte");
        float gscale = Statics.prefsDialog.graphicsScale * ks.getScale();
        float pGr = (float)this.document.wertePktGr * gscale * (Statics.prefsDialog.graphicsScale == 1.0f ? 0.9f : 0.7f);
        int pGr2 = (int)(pGr / 2.0f);
        float lSt = (float)this.document.wertePktGr * gscale * 0.2f;
        ((Graphics2D)g).setStroke(new BasicStroke(lSt));
        g.setColor(Diagram.colorArray[this.document.werteFarbIndex]);
        for (double[] wertePlotArray : ks.wertePlotArray) {
            for (int jj = 0; jj < ks.ynodes.size(); ++jj) {
                if (Double.isNaN(wertePlotArray[0]) || Double.isNaN(wertePlotArray[1 + jj])) continue;
                Point point = ks.XyToImage(wertePlotArray[0], wertePlotArray[1 + jj]);
                g.drawLine(point.x - pGr2, point.y - pGr2, point.x + pGr2, point.y + pGr2);
                g.drawLine(point.x - pGr2, point.y + pGr2, point.x + pGr2, point.y - pGr2);
                ks.wertePlotted = true;
            }
        }
    }

    public void zeichneAlles(Koordinatensystem ks, Graphics g) {
        this.zeichneFkt(ks, g);
        this.zeichneVglWerte(ks, g);
    }

    public boolean showFunction() {
        return this.fktCBox.isSelected();
    }

    public boolean showVglWerte() {
        return this.werteCBox.isSelected();
    }

    public void neu() {
        this.fktCBox.setSelected(false);
        String s = "";
        this.fktField.setName(s);
        this.fktField.setText(s);
        this.sliderListe.clear();
        this.werteCBox.setSelected(false);
    }

    public void setPlotAll(boolean bool) {
        this.plotAll = bool;
    }

    public void readData(ObjectInputStream objstr, float datversion, String kennung) throws Exception {
        int i;
        int fbr = 1;
        int ffi = 160;
        int wpktgr = 5;
        int wfi = 180;
        Statics.print("now reading Extras...");
        boolean fktCB = objstr.readBoolean();
        String fF = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        objstr.readUTF();
        this.sliderListe.clear();
        int canz = objstr.readInt();
        for (int i2 = 0; i2 < canz; ++i2) {
            String c1N = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
            double c1V = objstr.readDouble();
            double c1Min = objstr.readDouble();
            double c1Max = objstr.readDouble();
            this.konstanteHinzu(c1N, c1V, c1Min, c1Max);
        }
        if ((double)datversion < 2.2) {
            fbr = objstr.readInt();
            ffi = objstr.readInt();
        }
        boolean werteCB = objstr.readBoolean();
        int rowanz = objstr.readInt();
        int colanz = objstr.readInt();
        String[] snamen = new String[colanz];
        if ((double)datversion > 2.5) {
            for (i = 0; i < colanz; ++i) {
                snamen[i] = objstr.readUTF();
            }
        } else {
            snamen = this.document.getModel().getSpaltenNamen();
        }
        Double[][] tabdata = new Double[rowanz][colanz];
        for (i = 0; i < rowanz; ++i) {
            for (int j = 0; j < colanz; ++j) {
                double dat = objstr.readDouble();
                tabdata[i][j] = dat != Double.MAX_VALUE ? Double.valueOf(dat) : null;
            }
        }
        if ((double)datversion < 2.2) {
            wpktgr = objstr.readInt();
            wfi = objstr.readInt();
        }
        this.fktField.setText(fF);
        if (this.fktField.getLineCount() != this.fktField.getRows()) {
            this.fktField.setRows(this.fktField.getLineCount());
            if (this.document.getViewer() != null) {
                this.document.getViewer().validate();
            }
        }
        if ((double)datversion < 2.2) {
            this.document.fktBreite = this.document.fktBreite_loaded = fbr;
            this.document.fktFarbIndex = this.document.fktFarbIndex_loaded = ffi;
            this.document.fktStrichelung_loaded = 0;
            this.document.fktStrichelung = 0;
        }
        this.fktCBox.setSelected(fktCB);
        this.document.getCompValTable().update(tabdata, snamen);
        if ((double)datversion < 2.2) {
            this.document.wertePktGr = this.document.wertePktGr_loaded = wpktgr;
            this.document.werteFarbIndex = this.document.werteFarbIndex_loaded = wfi;
        }
        this.werteCBox.setSelected(werteCB);
    }

    public void writeData(ObjectOutputStream objstr) throws Exception {
        int i;
        VergleichsTabelle vtabelle = this.document.getCompValTable();
        objstr.writeBoolean(this.fktCBox.isSelected());
        objstr.writeUTF(this.fktField.getText());
        objstr.writeUTF("");
        objstr.writeInt(this.sliderListe.size());
        Iterator<SuperSlider> iterator = this.sliderListe.iterator();
        while (iterator.hasNext()) {
            SuperSlider sliderListe1;
            SuperSlider slider = sliderListe1 = iterator.next();
            objstr.writeUTF(slider.getName());
            objstr.writeDouble(slider.getValue());
            objstr.writeDouble(slider.getMin());
            objstr.writeDouble(slider.getMax());
        }
        objstr.writeBoolean(this.werteCBox.isSelected());
        objstr.writeInt(vtabelle.tab.getRowCount());
        objstr.writeInt(vtabelle.tab.getColumnCount());
        for (i = 0; i < vtabelle.tab.getColumnCount(); ++i) {
            objstr.writeUTF(vtabelle.tab.getColumnName(i));
        }
        for (i = 0; i < vtabelle.tab.getRowCount(); ++i) {
            for (int j = 0; j < vtabelle.tab.getColumnCount(); ++j) {
                if (vtabelle.tab.getValueAt(i, j) != null) {
                    objstr.writeDouble((Double)vtabelle.tab.getValueAt(i, j));
                    continue;
                }
                objstr.writeDouble(Double.MAX_VALUE);
            }
        }
    }

    public void writeTextData(RandomAccessFile f) throws Exception {
        f.writeBytes(GreekLetterConstPanel.refactorASCIIStr(this.getDataString()));
    }

    public void printTextData(PrintWriter f) throws Exception {
        f.print(GreekLetterConstPanel.refactorASCIIStr(this.getDataString()));
    }

    public String getDataString() {
        Object s = "";
        if (this.fktCBox.isSelected()) {
            s = rbundle.getString("Definierte_Funktionen") + "\n     ";
            s = ((String)s).concat(this.fktField.getText().replace("\n", "; ") + "\n     ");
            if (this.sliderListe.size() > 0) {
                s = ((String)s).concat(rbundle.getString("mit") + ": ");
                Object constString = "";
                int constZeilen = 1;
                for (int i = 0; i < this.sliderListe.size(); ++i) {
                    SuperSlider slider = this.sliderListe.get(i);
                    if (((String)(constString = (String)constString + GreekLetterConstPanel.factorASCIIStr(slider.getName()) + "=" + Statics.doubleToString(slider.getValue()))).length() > constZeilen * 200) {
                        constString = (String)constString + "\n     ";
                        ++constZeilen;
                    }
                    if (i >= this.sliderListe.size() - 1) continue;
                    constString = (String)constString + "; ";
                }
                s = ((String)s).concat((String)constString);
            }
        }
        return (String)s + "\n";
    }

    class Funktion {
        public String fktName;
        public String varName;
        double varVon = Double.NaN;
        double varBis = Double.NaN;
        int varSteps = -1;
        Node fktNode;
        ArrayList<Polygon> polygons = new ArrayList();

        Funktion() {
        }
    }
}

