/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Diagram;
import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Koordinatensystem3D;
import de.didappslib.base.Model;
import de.didappslib.base.Statics;
import de.didappslib.guitools.AutoDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ResourceBundle;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintPreviewWindow
extends JFrame
implements Printable,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle prgBundle = Statics.prg_Bundle;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/DruckFenster", Statics.locale);
    private static final PrinterJob pjob = PrinterJob.getPrinterJob();
    private static PageFormat pPage = pjob.defaultPage();
    private Document document;
    private Koordinatensystem[] ks;
    private Blatt blatt = new Blatt();
    private double zoomFaktor;
    private double contentScaling;
    private double fontKSRatio;
    private int phi = 0;
    private int xstart = 5;
    private int ystart = 15;
    private String projektName;
    private int modus;
    private PrintPreviewWindow me = this;
    private Point rechtsUnten;
    PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    BufferedImage[] ksPics;
    String merkeRechtsStr;
    String merkeHochStr;
    private JButton PapierFormatButt;
    private JToggleButton anpassButt;
    private JScrollPane blattPane;
    private JButton drehGegenButt;
    private JButton drehMitButt;
    private JButton druckenButt;
    private JTextField faktorField;
    private JPanel helpPanel;
    private JPanel jPanel1;
    private JButton minusButt;
    private JButton plusButt;
    private JSlider vergrSlider;

    public PrintPreviewWindow(Document doc) {
        this.document = doc;
        this.initComponents();
        this.blattPane.addMouseWheelListener(this.me);
        pjob.setPrintable(this.me);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length > 0) {
            Statics.println("selected printer " + services[0].getName());
            try {
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    pjob.setPrintService(service);
                } else {
                    pjob.setPrintService(services[0]);
                }
            }
            catch (PrinterException pe) {
                System.err.println(pe);
            }
        }
    }

    private void initComponents() {
        this.blattPane = new JScrollPane();
        this.helpPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.PapierFormatButt = new JButton();
        this.minusButt = new JButton();
        this.faktorField = new JTextField();
        this.plusButt = new JButton();
        this.anpassButt = new JToggleButton();
        this.vergrSlider = new JSlider();
        this.drehMitButt = new JButton();
        this.drehGegenButt = new JButton();
        this.druckenButt = new JButton();
        this.setTitle(this.rbundle.getString("Druckvorschau"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrintPreviewWindow.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.blattPane.setBackground(new Color(153, 153, 153));
        this.blattPane.setBorder(null);
        this.blattPane.setHorizontalScrollBarPolicy(32);
        this.blattPane.setVerticalScrollBarPolicy(22);
        this.blattPane.setEnabled(false);
        this.blattPane.setFocusable(false);
        this.blattPane.setOpaque(false);
        this.blattPane.setRequestFocusEnabled(false);
        this.blattPane.setVerifyInputWhenFocusTarget(false);
        this.blattPane.setWheelScrollingEnabled(false);
        this.blattPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PrintPreviewWindow.this.blattPaneResized(evt);
            }
        });
        this.blattPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrintPreviewWindow.this.blattPanepropChanged(evt);
            }
        });
        this.blattPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.helpPanel.setBackground(new Color(153, 153, 153));
        this.helpPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.helpPanel.setLayout(new GridBagLayout());
        this.blattPane.setViewportView(this.helpPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.blattPane, gridBagConstraints);
        this.jPanel1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.PapierFormatButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/papier.gif")));
        this.PapierFormatButt.setToolTipText(this.rbundle.getString("Aendern_des_Papierformats"));
        this.PapierFormatButt.setBorderPainted(false);
        this.PapierFormatButt.setContentAreaFilled(false);
        this.PapierFormatButt.setMargin(new Insets(5, 7, 5, 7));
        this.PapierFormatButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/papier_dk.gif")));
        this.PapierFormatButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.PapierFormatButtActionPerformed(evt);
            }
        });
        this.PapierFormatButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 7, 5, 5);
        this.jPanel1.add((Component)this.PapierFormatButt, gridBagConstraints);
        this.minusButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/verkleinern.gif")));
        this.minusButt.setToolTipText(this.rbundle.getString("Darstellung_verkleinern"));
        this.minusButt.setBorderPainted(false);
        this.minusButt.setContentAreaFilled(false);
        this.minusButt.setMargin(new Insets(8, 7, 8, 7));
        this.minusButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/verkleinern_dk.gif")));
        this.minusButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.minusButtActionPerformed(evt);
            }
        });
        this.minusButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)this.minusButt, gridBagConstraints);
        this.faktorField.setToolTipText(this.rbundle.getString("Angabe_der_Vergroesserung"));
        this.faktorField.setMinimumSize(new Dimension(55, 22));
        this.faktorField.setPreferredSize(new Dimension(55, 22));
        this.faktorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.faktorFieldAction(evt);
            }
        });
        this.faktorField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.faktorField, gridBagConstraints);
        this.plusButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/vergroessern.gif")));
        this.plusButt.setToolTipText(this.rbundle.getString("Darstellung_vergroessern"));
        this.plusButt.setBorderPainted(false);
        this.plusButt.setContentAreaFilled(false);
        this.plusButt.setMargin(new Insets(8, 7, 8, 7));
        this.plusButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/vergroessern_dk.gif")));
        this.plusButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.plusButtActionPerformed(evt);
            }
        });
        this.plusButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.plusButt, gridBagConstraints);
        this.anpassButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/anpass.gif")));
        this.anpassButt.setToolTipText(this.rbundle.getString("Darstellung_an_das_Fenster_anpassen"));
        this.anpassButt.setBorderPainted(false);
        this.anpassButt.setContentAreaFilled(false);
        this.anpassButt.setMargin(new Insets(8, 7, 8, 7));
        this.anpassButt.setMaximumSize(new Dimension(18, 24));
        this.anpassButt.setMinimumSize(new Dimension(18, 24));
        this.anpassButt.setPreferredSize(new Dimension(18, 24));
        this.anpassButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/anpass_dk.gif")));
        this.anpassButt.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/anpass_sel.gif")));
        this.anpassButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.anpassButtActionPerformed(evt);
            }
        });
        this.anpassButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.anpassButt, gridBagConstraints);
        this.vergrSlider.setMaximum(200);
        this.vergrSlider.setMinimum(30);
        this.vergrSlider.setToolTipText(this.rbundle.getString("Einstellen_der_Groesse_der_Ausgabe"));
        this.vergrSlider.setValue(90);
        this.vergrSlider.setMinimumSize(new Dimension(88, 22));
        this.vergrSlider.setPreferredSize(new Dimension(200, 22));
        this.vergrSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrintPreviewWindow.this.vergrSliderStateChanged(evt);
            }
        });
        this.vergrSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.jPanel1.add((Component)this.vergrSlider, new GridBagConstraints());
        this.drehMitButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/rechtsrum.gif")));
        this.drehMitButt.setToolTipText(this.rbundle.getString("Ausgabe_um_im_Uhrzeigersinn_drehen"));
        this.drehMitButt.setBorderPainted(false);
        this.drehMitButt.setContentAreaFilled(false);
        this.drehMitButt.setMargin(new Insets(8, 7, 8, 7));
        this.drehMitButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/rechtsrum_dk.gif")));
        this.drehMitButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.drehMitButtActionPerformed(evt);
            }
        });
        this.drehMitButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPredded(evt);
            }
        });
        this.jPanel1.add((Component)this.drehMitButt, new GridBagConstraints());
        this.drehGegenButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/linksrum.gif")));
        this.drehGegenButt.setToolTipText(this.rbundle.getString("Ausgabe_gegen_den_Uhrzeigersinn_drehen"));
        this.drehGegenButt.setBorderPainted(false);
        this.drehGegenButt.setContentAreaFilled(false);
        this.drehGegenButt.setMargin(new Insets(8, 7, 8, 7));
        this.drehGegenButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/linksrum_dk.gif")));
        this.drehGegenButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.drehGegenButtActionPerformed(evt);
            }
        });
        this.drehGegenButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        this.jPanel1.add((Component)this.drehGegenButt, new GridBagConstraints());
        this.druckenButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/print.png")));
        this.druckenButt.setToolTipText(this.rbundle.getString("Starten_des_Druckauftrags"));
        this.druckenButt.setBorderPainted(false);
        this.druckenButt.setContentAreaFilled(false);
        this.druckenButt.setMargin(new Insets(5, 7, 5, 7));
        this.druckenButt.setMaximumSize(new Dimension(37, 24));
        this.druckenButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewWindow.this.druckenAction(evt);
            }
        });
        this.druckenButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintPreviewWindow.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.jPanel1.add((Component)this.druckenButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void anpassButtActionPerformed(ActionEvent evt) {
        this.blattAnpassen();
    }

    private void blattPaneResized(ComponentEvent evt) {
        if (this.anpassButt.isSelected()) {
            this.blattAnpassen();
        }
    }

    private void drehMitButtActionPerformed(ActionEvent evt) {
        this.phi += 90;
        if (this.phi > 270) {
            this.phi = 0;
        }
        this.blattPane.repaint();
    }

    private void drehGegenButtActionPerformed(ActionEvent evt) {
        this.phi -= 90;
        if (this.phi < 0) {
            this.phi = 270;
        }
        this.blattPane.repaint();
    }

    private void vergrSliderStateChanged(ChangeEvent evt) {
        this.contentScaling = (double)this.vergrSlider.getValue() / 100.0;
        this.blattPane.repaint();
    }

    private void blattPanepropChanged(PropertyChangeEvent evt) {
        this.blattPane.repaint();
    }

    private void faktorFieldAction(ActionEvent evt) {
        double fkt = 0.0;
        try {
            fkt = (double)Integer.parseInt(this.faktorField.getText().replace('%', ' ').replaceAll(" ", "")) / 100.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fkt > 0.15 & fkt < 5.0) {
            this.zoomFaktor = fkt;
        }
        this.setzeBlattDimensionen();
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
        this.blattPane.repaint();
        this.anpassButt.setSelected(false);
    }

    private void minusButtActionPerformed(ActionEvent evt) {
        if (this.zoomFaktor < 0.2) {
            return;
        }
        this.zoomFaktor /= 1.19;
        this.setzeBlattDimensionen();
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
        this.blattPane.repaint();
        this.anpassButt.setSelected(false);
    }

    private void plusButtActionPerformed(ActionEvent evt) {
        if (this.zoomFaktor > 4.0) {
            return;
        }
        this.zoomFaktor = 1.19 * this.zoomFaktor;
        this.setzeBlattDimensionen();
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
        this.blattPane.repaint();
        this.anpassButt.setSelected(false);
    }

    private void druckenAction(ActionEvent evt) {
        this.drucken();
    }

    private void PapierFormatButtActionPerformed(ActionEvent evt) {
        PageFormat pf;
        if (pjob == null || pPage == null) {
            return;
        }
        pPage = pf = pjob.pageDialog(pPage);
        this.setzeBlattDimensionen();
        this.blattPane.repaint();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.document.getViewer().updateView();
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && evt.getKeyChar() == 'w') {
            this.setVisible(false);
        }
    }

    private void formKeyPredded(KeyEvent evt) {
    }

    public void setParameter(String prjname, int modus_p, Model dgl_p, Diagram diag) {
        int i;
        pPage.setOrientation(1);
        this.setSize((int)pPage.getImageableWidth(), (int)pPage.getImageableHeight());
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
        this.setzeBlattDimensionen();
        this.blatt.setBackground(Color.WHITE);
        this.helpPanel.add(this.blatt);
        this.projektName = prjname;
        this.ks = new Koordinatensystem[diag.koordinatensysteme.size()];
        for (i = 0; i < diag.koordinatensysteme.size(); ++i) {
            this.ks[i] = (Koordinatensystem)diag.koordinatensysteme.get(i).clone();
        }
        this.modus = modus_p;
        if (this.modus < 20) {
            this.ks = new Koordinatensystem[4];
            this.ks[0] = (Koordinatensystem)diag.aktKS.clone();
        } else {
            this.ks = new Koordinatensystem[diag.koordinatensysteme.size()];
            for (i = 0; i < diag.koordinatensysteme.size(); ++i) {
                this.ks[i] = (Koordinatensystem)diag.koordinatensysteme.get(i).clone();
            }
        }
        float ksScale = 1.75f * Statics.prefsDialog.displayScale;
        int ksWidth = (int)(688.0f * ksScale);
        int ksHeight = (int)(500.0f * ksScale);
        this.ks[0].setSize(ksWidth, ksHeight);
        this.ks[0].setLocation(0, 0);
        this.fontKSRatio = 0.5 / (double)Statics.prefsDialog.displayScale;
        this.rechtsUnten = new Point(ksWidth, ksHeight);
        this.contentScaling = pPage.getImageableWidth() / 612.0;
        if (this.modus == 21 && diag.koordinatensysteme.size() == 2) {
            ksHeight = (int)(315.0f * ksScale);
            this.ks[0].setLocation(0, 0);
            this.ks[0].setSize(ksWidth, ksHeight);
            this.ks[1].setLocation(0, ksHeight + 100);
            this.ks[1].setSize(ksWidth, ksHeight);
            this.rechtsUnten = new Point(ksWidth, 2 * ksHeight + 100);
        }
        if (this.modus == 21 && diag.koordinatensysteme.size() == 3) {
            ksHeight = (int)(235.0f * ksScale);
            this.ks[0].setLocation(0, 0);
            this.ks[0].setSize(ksWidth, ksHeight);
            this.ks[1].setLocation(0, ksHeight + 100);
            this.ks[1].setSize(ksWidth, ksHeight);
            this.ks[2].setLocation(0, 2 * ksHeight + 200);
            this.ks[2].setSize(ksWidth, ksHeight);
            this.rechtsUnten = new Point(ksWidth, 3 * ksHeight + 200);
        }
        if (this.modus == 20 && diag.koordinatensysteme.size() == 2) {
            ksWidth = (int)(339.0f * ksScale);
            this.ks[0].setLocation(0, 0);
            this.ks[0].setSize(ksWidth, ksHeight);
            this.ks[1].setLocation(ksWidth + 30, 0);
            this.ks[1].setSize(ksWidth, ksHeight);
            this.rechtsUnten = new Point(2 * ksWidth + 15, ksHeight);
        }
        if (this.modus == 20 && diag.koordinatensysteme.size() == 3) {
            ksWidth = (int)(224.0f * ksScale);
            this.ks[0].setLocation(0, 0);
            this.ks[0].setSize(ksWidth, ksHeight);
            this.ks[1].setLocation(ksWidth + 30, 0);
            this.ks[1].setSize(ksWidth, ksHeight);
            this.ks[2].setLocation(2 * ksWidth + 60, 0);
            this.ks[2].setSize(ksWidth, ksHeight);
            this.rechtsUnten = new Point(3 * ksWidth + 24, ksHeight);
        }
        if (diag.koordinatensysteme.size() == 4) {
            ksHeight = ksWidth = (int)(338.0f * ksScale);
            this.ks[0].setLocation(0, 0);
            this.ks[0].setSize(ksWidth, ksHeight);
            this.ks[1].setLocation(ksWidth + 30, 0);
            this.ks[1].setSize(ksWidth, ksHeight);
            this.ks[2].setLocation(0, ksHeight + 100);
            this.ks[2].setSize(ksWidth, ksHeight);
            this.ks[3].setLocation(ksWidth + 30, ksHeight + 100);
            this.ks[3].setSize(ksWidth, ksHeight);
            this.rechtsUnten = new Point(2 * ksWidth + 18, 2 * ksHeight + 100);
        }
        boolean save = this.document.achsenFaerben;
        this.document.achsenFaerben = false;
        this.createKSPictures();
        this.document.achsenFaerben = save;
    }

    private void setzeBlattDimensionen() {
        Dimension dim = new Dimension((int)(pPage.getWidth() * this.zoomFaktor), (int)(pPage.getHeight() * this.zoomFaktor));
        this.helpPanel.setMinimumSize(dim);
        this.helpPanel.setPreferredSize(dim);
        this.helpPanel.setSize(dim);
        this.blatt.setMinimumSize(dim);
        this.blatt.setPreferredSize(dim);
        this.blatt.setSize(dim);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page != 0) {
            return 1;
        }
        g.translate((int)pPage.getImageableX(), (int)pPage.getImageableY());
        this.blatt.paintContent(g, false);
        return 0;
    }

    public void drucken() {
        if (pjob == null) {
            new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Kein_Drucker_gefunden"));
            return;
        }
        try {
            if (pjob.printDialog()) {
                pjob.setPrintable(this, pPage);
                pjob.print();
                this.setVisible(false);
            }
        }
        catch (HeadlessException headlessException) {
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    public void blattAnpassen() {
        this.zoomFaktor = (double)this.blattPane.getWidth() / pPage.getWidth() * 0.98;
        if (pPage.getHeight() * this.zoomFaktor > (double)this.blattPane.getHeight()) {
            this.zoomFaktor = (double)this.blattPane.getHeight() / pPage.getHeight() * 0.98;
        }
        this.setzeBlattDimensionen();
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
        this.blattPane.repaint();
    }

    private void createKSPictures() {
        int i = 0;
        this.ksPics = new BufferedImage[this.ks.length];
        try {
            for (i = 0; i < this.ks.length; ++i) {
                if (this.ks[i] == null) continue;
                this.ksPics[i] = new BufferedImage(this.ks[i].getWidth(), this.ks[i].getHeight(), 1);
                Graphics2D g = this.ksPics[i].createGraphics();
                this.ks[i].zeichneAllesInImage(this.ksPics[i]);
                Koordinatensystem origKS = this.document.getDiagramm().koordinatensysteme.get(i);
                int legX = origKS.legendX * this.ksPics[i].getWidth() / origKS.getWidth();
                int legY = origKS.legendY * this.ksPics[i].getHeight() / origKS.getHeight();
                if (!this.document.showLegend) continue;
                float safescale = this.ks[i].legend.getScale();
                g.translate(legX, legY);
                float fac = 2.1f;
                this.ks[i].legend.setScale(safescale * fac);
                this.ks[i].legend.paint(g);
                g.translate(-legX, -legY);
                this.ks[i].legend.setScale(safescale);
            }
        }
        catch (OutOfMemoryError e) {
            new AutoDialog(this).display(this.rbundle.getString("Speicherfehler") + i, this.rbundle.getString("nicht_genug_Speicher"), Statics.prg_Bundle.getString("OK"));
            this.ksPics = null;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double zfak = e.getWheelRotation();
        if (zfak == 0.0) {
            return;
        }
        if (zfak < 0.0) {
            this.zoomFaktor /= 1.05 * Math.pow(-zfak, 0.05);
            if (this.zoomFaktor < 0.2) {
                this.zoomFaktor = 0.2;
            }
        } else {
            this.zoomFaktor = this.zoomFaktor * 1.05 * Math.pow(zfak, 0.05);
            if (this.zoomFaktor > 5.0) {
                this.zoomFaktor = 5.0;
            }
        }
        this.setzeBlattDimensionen();
        this.blattPane.repaint();
        this.faktorField.setText((int)(this.zoomFaktor * 100.0) + " %");
    }

    class Blatt
    extends JPanel {
        int mousex = -1;
        int mousey = -1;
        int xstart_merke;
        int ystart_merke;

        public Blatt() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    Blatt.this.mousedragged(evt);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    Blatt.this.mousepressed(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    Blatt.this.requestFocus();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PrintPreviewWindow.this.formKeyPressed(evt);
                }
            });
        }

        private void mousepressed(MouseEvent evt) {
            this.mousex = evt.getX();
            this.mousey = evt.getY();
            this.xstart_merke = PrintPreviewWindow.this.xstart;
            this.ystart_merke = PrintPreviewWindow.this.ystart;
        }

        private void mousedragged(MouseEvent evt) {
            if (this.mousex != -1) {
                int deltax = evt.getX() - this.mousex;
                int deltay = evt.getY() - this.mousey;
                switch (PrintPreviewWindow.this.phi) {
                    case 90: {
                        PrintPreviewWindow.this.xstart = this.xstart_merke + (int)((double)deltay / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        PrintPreviewWindow.this.ystart = this.ystart_merke - (int)((double)deltax / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        break;
                    }
                    case 180: {
                        PrintPreviewWindow.this.xstart = this.xstart_merke - (int)((double)deltax / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        PrintPreviewWindow.this.ystart = this.ystart_merke - (int)((double)deltay / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        break;
                    }
                    case 270: {
                        PrintPreviewWindow.this.xstart = this.xstart_merke - (int)((double)deltay / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        PrintPreviewWindow.this.ystart = this.ystart_merke + (int)((double)deltax / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        break;
                    }
                    default: {
                        PrintPreviewWindow.this.xstart = this.xstart_merke + (int)((double)deltax / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                        PrintPreviewWindow.this.ystart = this.ystart_merke + (int)((double)deltay / PrintPreviewWindow.this.contentScaling / PrintPreviewWindow.this.zoomFaktor);
                    }
                }
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.scale(PrintPreviewWindow.this.zoomFaktor, PrintPreviewWindow.this.zoomFaktor);
            g.translate((int)pPage.getImageableX(), (int)pPage.getImageableY());
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(-1, -1, (int)pPage.getImageableWidth() + 2, (int)pPage.getImageableHeight() + 2);
            g.clipRect(0, 0, (int)pPage.getImageableWidth(), (int)pPage.getImageableHeight());
            this.paintContent(g, true);
        }

        public void paintContent(Graphics g, boolean fast) {
            int yko = PrintPreviewWindow.this.ystart;
            Font textFont = new Font("Dialog", 0, 10);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(PrintPreviewWindow.this.contentScaling, PrintPreviewWindow.this.contentScaling);
            if (PrintPreviewWindow.this.phi != 0) {
                g2d.rotate(Math.PI / 180 * (double)PrintPreviewWindow.this.phi);
            }
            if (PrintPreviewWindow.this.phi == 90) {
                g.translate(0, -((int)((double)PrintPreviewWindow.this.blatt.getWidth() / PrintPreviewWindow.this.zoomFaktor)));
            }
            if (PrintPreviewWindow.this.phi == 180) {
                g.translate(-((int)((double)PrintPreviewWindow.this.blatt.getHeight() / PrintPreviewWindow.this.zoomFaktor)), -((int)((double)PrintPreviewWindow.this.blatt.getWidth() / PrintPreviewWindow.this.zoomFaktor)));
            }
            if (PrintPreviewWindow.this.phi == 270) {
                g.translate(-((int)((double)PrintPreviewWindow.this.blatt.getHeight() / PrintPreviewWindow.this.zoomFaktor)), 0);
            }
            g.setColor(Color.BLACK);
            int xko = PrintPreviewWindow.this.xstart;
            if (PrintPreviewWindow.this.projektName != null) {
                g.setFont(new Font("Dialog", 1, 14));
                g.drawString(PrintPreviewWindow.this.projektName, xko, yko);
            }
            g.setFont(textFont);
            if (PrintPreviewWindow.this.document.getModel() != null) {
                yko += 15;
                yko = Statics.drawText(g, PrintPreviewWindow.this.document.getModel().getDataString() + PrintPreviewWindow.this.document.getExtras().getDataString(), xko, yko);
            }
            yko += 10;
            xko = PrintPreviewWindow.this.xstart;
            for (int i = 0; i < PrintPreviewWindow.this.ks.length; ++i) {
                if (PrintPreviewWindow.this.ks[i] == null) continue;
                g.translate(xko + (int)((double)PrintPreviewWindow.this.ks[i].getX() * PrintPreviewWindow.this.fontKSRatio), yko + (int)((double)PrintPreviewWindow.this.ks[i].getY() * PrintPreviewWindow.this.fontKSRatio));
                g.setColor(Color.BLACK);
                g.setFont(textFont);
                Object s = PrintPreviewWindow.this.document.diagramm.koordinatensysteme.get(0) instanceof Koordinatensystem3D ? "" : PrintPreviewWindow.this.ks[i].varHochStr + " " + PrintPreviewWindow.this.rbundle.getString("als_Funktion_von") + " " + PrintPreviewWindow.this.ks[i].varRechtsStr;
                s = PrintPreviewWindow.this.rbundle.getString("Darstellung") + " " + (i + 1) + ":  " + (String)s;
                g.drawString((String)s, 0, -5);
                g2d.scale(PrintPreviewWindow.this.fontKSRatio, PrintPreviewWindow.this.fontKSRatio);
                g2d.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.BLACK);
                g.drawRect(-2, -2, PrintPreviewWindow.this.ks[i].getWidth() + 4, PrintPreviewWindow.this.ks[i].getHeight() + 4);
                Shape saveClipArea = g.getClip();
                g.clipRect(0, 0, PrintPreviewWindow.this.ks[i].getWidth(), PrintPreviewWindow.this.ks[i].getHeight());
                if (fast && PrintPreviewWindow.this.ksPics != null) {
                    g.drawImage(PrintPreviewWindow.this.ksPics[i], 0, 0, null);
                } else {
                    boolean save = PrintPreviewWindow.this.document.achsenFaerben;
                    PrintPreviewWindow.this.document.achsenFaerben = false;
                    PrintPreviewWindow.this.ks[i].zeichneAllesInGraphics(g, PrintPreviewWindow.this.ksPics[i]);
                    if (PrintPreviewWindow.this.document.showLegend) {
                        float safescale = PrintPreviewWindow.this.ks[i].legend.getScale();
                        float fac = 2.1f;
                        g.translate((int)((float)PrintPreviewWindow.this.ks[i].legendX * fac), (int)((float)PrintPreviewWindow.this.ks[i].legendY * fac));
                        PrintPreviewWindow.this.ks[i].legend.setScale(safescale * fac);
                        PrintPreviewWindow.this.ks[i].legend.paint(g);
                        g.translate((int)((float)(-PrintPreviewWindow.this.ks[i].legendX) * fac), (int)((float)(-PrintPreviewWindow.this.ks[i].legendY) * fac));
                        PrintPreviewWindow.this.ks[i].legend.setScale(safescale);
                    }
                    PrintPreviewWindow.this.document.achsenFaerben = save;
                }
                g.setClip(saveClipArea);
                g2d.scale(1.0 / PrintPreviewWindow.this.fontKSRatio, 1.0 / PrintPreviewWindow.this.fontKSRatio);
                g.translate(-xko - (int)((double)PrintPreviewWindow.this.ks[i].getX() * PrintPreviewWindow.this.fontKSRatio), -yko - (int)((double)PrintPreviewWindow.this.ks[i].getY() * PrintPreviewWindow.this.fontKSRatio));
            }
            g.setColor(Color.BLACK);
            g.setFont(new Font("Dialog", 0, 9));
            LocalDate date = LocalDate.now();
            DateTimeFormatter df = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
            Object createdString = PrintPreviewWindow.this.rbundle.getString("Created_&_printed_by").replace("#", date.format(df.withLocale(Statics.locale)));
            createdString = (String)createdString + " " + PrintPreviewWindow.this.prgBundle.getString("PROGRAM_NAME") + " V" + Statics.prgVersion;
            int swidth = g.getFontMetrics().stringWidth((String)createdString) - 2;
            g.drawString((String)createdString, (int)((double)xko + (double)PrintPreviewWindow.this.rechtsUnten.x * PrintPreviewWindow.this.fontKSRatio - (double)swidth), (int)((double)yko + (double)PrintPreviewWindow.this.rechtsUnten.y * PrintPreviewWindow.this.fontKSRatio + 11.0));
        }
    }
}

