/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Statics;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.VariablesPopup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KSEinstellung
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Koordinatensystem ks;
    private final Document projekt;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/KSEinstellung", Statics.locale);
    private boolean rechtsAuftrTFWasActive;
    private boolean hochAuftrTFWasActive;
    private final PopupMenuListener rechtsAuftrTFPopupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KSEinstellung.this.rechtsAuftrTFWasActive = KSEinstellung.this.rechtsAuftrTF.hasFocus();
        }
    };
    private final PopupMenuListener hochAuftrTFPopupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KSEinstellung.this.hochAuftrTFWasActive = KSEinstellung.this.hochAuftrTF.hasFocus();
        }
    };
    private JCheckBox achsenSichtbCB;
    private JTextField hAnfTF;
    private JCheckBox hAutoCB;
    private JCheckBox hAutoEintCB;
    private JTextField hEintBrTF;
    private JTextField hEndTF;
    private JTextField hFeinTF;
    public JTextField hochAuftrTF;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField rAnfTF;
    private JCheckBox rAutoCB;
    private JCheckBox rAutoEintCB;
    private JTextField rEintBrTF;
    private JTextField rEndTF;
    private JTextField rFeinTF;
    private JTextField rechtsAuftrTF;

    public KSEinstellung(Koordinatensystem k, Document prj) {
        this.ks = k;
        this.projekt = prj;
        this.initComponents();
        this.rechtsAuftrTF.setFont(Statics.mathFont);
        this.rechtsAuftrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    KSEinstellung.this.rechtsAuftrTF.setText(KSEinstellung.this.rechtsAuftrTF.getText() + " ");
                    GreekLetterConstPanel.tfInputHook(KSEinstellung.this.rechtsAuftrTF);
                    KSEinstellung.this.rechtsAuftrTF.setText(KSEinstellung.this.rechtsAuftrTF.getText().trim());
                    KSEinstellung.this.ks.setAuftragungsStringsMitZeichnen(KSEinstellung.this.rechtsAuftrTF.getText(), KSEinstellung.this.hochAuftrTF.getText());
                    KSEinstellung.this.hochAuftrTF.requestFocusInWindow();
                } else {
                    KSEinstellung.this.cbKeyPressed(evt);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.hochAuftrTF.setFont(Statics.mathFont);
        this.hochAuftrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    KSEinstellung.this.hochAuftrTF.setText(KSEinstellung.this.hochAuftrTF.getText() + " ");
                    GreekLetterConstPanel.tfInputHook(KSEinstellung.this.hochAuftrTF);
                    KSEinstellung.this.hochAuftrTF.setText(KSEinstellung.this.hochAuftrTF.getText().trim());
                    KSEinstellung.this.ks.setAuftragungsStringsMitZeichnen(KSEinstellung.this.rechtsAuftrTF.getText(), KSEinstellung.this.hochAuftrTF.getText());
                    KSEinstellung.this.rechtsAuftrTF.requestFocusInWindow();
                } else {
                    KSEinstellung.this.cbKeyPressed(evt);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.achsenSichtbCB.setSelected(this.ks.achseSichtbar);
    }

    public void activate(int x, int y) {
        this.updateFields();
        Rectangle scrBounds = Statics.getRealScreenBounds(this.projekt.getViewer().getWindow());
        if (x < 0 && y < 0) {
            this.setLocation(scrBounds.x + scrBounds.width / 2 - this.getWidth() / 2, scrBounds.y + scrBounds.height / 2 * 3 / 5 - this.getHeight() / 2);
        } else {
            if ((x -= this.getWidth() / 2) < scrBounds.x) {
                x = scrBounds.x;
            }
            if (x + this.getWidth() > scrBounds.x + scrBounds.width) {
                x = scrBounds.x + scrBounds.width - this.getWidth();
            }
            if ((y -= this.getHeight() / 2) < scrBounds.y) {
                y = scrBounds.y;
            }
            if (y + this.getHeight() > scrBounds.y + scrBounds.height) {
                y = scrBounds.y + scrBounds.height - this.getHeight();
            }
            this.setLocation(x, y);
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.rAnfTF = new JTextField();
        this.jLabel3 = new JLabel();
        this.rEndTF = new JTextField();
        this.rAutoCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.rEintBrTF = new JTextField();
        this.rAutoEintCB = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.rFeinTF = new JTextField();
        this.jLabel9 = new JLabel();
        this.hochAuftrTF = new JTextField();
        this.jLabel8 = new JLabel();
        this.hAnfTF = new JTextField();
        this.jLabel10 = new JLabel();
        this.hEndTF = new JTextField();
        this.hAutoCB = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.hEintBrTF = new JTextField();
        this.hAutoEintCB = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.hFeinTF = new JTextField();
        this.achsenSichtbCB = new JCheckBox();
        this.rechtsAuftrTF = new JTextField();
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/KSEinstellung");
        this.setTitle(bundle.getString("Einstellungen_der_Koordinatenachsen"));
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.rbundle.getString("Rechtsachse"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 14, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(this.rbundle.getString("Anfang"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 31, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.rAnfTF.setColumns(4);
        this.rAnfTF.setToolTipText(bundle.getString("Start_TIP"));
        this.rAnfTF.setOpaque(true);
        this.rAnfTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.rAnfTFFocusLost(evt);
            }
        });
        this.rAnfTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rAnfTFActionPerformed(evt);
            }
        });
        this.rAnfTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.rAnfTF, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.rbundle.getString("Ende"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.rEndTF.setColumns(4);
        this.rEndTF.setToolTipText(bundle.getString("End_TIP"));
        this.rEndTF.setOpaque(true);
        this.rEndTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.rEndTFFocusLost(evt);
            }
        });
        this.rEndTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rEndTFActionPerformed(evt);
            }
        });
        this.rEndTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.rEndTF, gridBagConstraints);
        this.rAutoCB.setText(this.rbundle.getString("auto"));
        this.rAutoCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.rAutoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rAutoCBActionPerformed(evt);
            }
        });
        this.rAutoCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 14);
        this.getContentPane().add((Component)this.rAutoCB, gridBagConstraints);
        this.jLabel4.setText(this.rbundle.getString("Division"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 31, 0, 0);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.rEintBrTF.setColumns(4);
        this.rEintBrTF.setToolTipText(bundle.getString("Division_TIP"));
        this.rEintBrTF.setOpaque(true);
        this.rEintBrTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.rEintBrTFFocusLost(evt);
            }
        });
        this.rEintBrTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rEintBrTFActionPerformed(evt);
            }
        });
        this.rEintBrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.rEintBrTF, gridBagConstraints);
        this.rAutoEintCB.setText(this.rbundle.getString("auto"));
        this.rAutoEintCB.setToolTipText(bundle.getString("autoDivision_TIP"));
        this.rAutoEintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rAutoEintCBActionPerformed(evt);
            }
        });
        this.rAutoEintCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.getContentPane().add((Component)this.rAutoEintCB, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.rbundle.getString("Feinteilung"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.rFeinTF.setColumns(4);
        this.rFeinTF.setToolTipText(bundle.getString("Subdivisions_TIP"));
        this.rFeinTF.setOpaque(true);
        this.rFeinTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.rFeinTFFocusLost(evt);
            }
        });
        this.rFeinTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.rFeinTFActionPerformed(evt);
            }
        });
        this.rFeinTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.rFeinTF, gridBagConstraints);
        this.jLabel9.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText(this.rbundle.getString("Hochachse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.hochAuftrTF.setColumns(8);
        this.hochAuftrTF.setToolTipText(bundle.getString("HochachseField_TIP"));
        this.hochAuftrTF.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.getContentPane().add((Component)this.hochAuftrTF, gridBagConstraints);
        this.jLabel8.setText(this.rbundle.getString("Anfang"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 31, 0, 0);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.hAnfTF.setColumns(4);
        this.hAnfTF.setToolTipText(bundle.getString("Start_TIP"));
        this.hAnfTF.setOpaque(true);
        this.hAnfTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.hAnfTFFocusLost(evt);
            }
        });
        this.hAnfTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hAnfTFActionPerformed(evt);
            }
        });
        this.hAnfTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.hAnfTF, gridBagConstraints);
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(this.rbundle.getString("Ende"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.hEndTF.setColumns(4);
        this.hEndTF.setToolTipText(bundle.getString("End_TIP"));
        this.hEndTF.setOpaque(true);
        this.hEndTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.hEndTFFocusLost(evt);
            }
        });
        this.hEndTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hEndTFActionPerformed(evt);
            }
        });
        this.hEndTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.hEndTF, gridBagConstraints);
        this.hAutoCB.setText(this.rbundle.getString("auto"));
        this.hAutoCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.hAutoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hAutoCBActionPerformed(evt);
            }
        });
        this.hAutoCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 0, 6);
        this.getContentPane().add((Component)this.hAutoCB, gridBagConstraints);
        this.jLabel11.setText(this.rbundle.getString("Division"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 22, 13, 0);
        this.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.hEintBrTF.setColumns(4);
        this.hEintBrTF.setToolTipText(bundle.getString("Division_TIP"));
        this.hEintBrTF.setOpaque(true);
        this.hEintBrTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.hEintBrTFFocusLost(evt);
            }
        });
        this.hEintBrTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hEintBrTFActionPerformed(evt);
            }
        });
        this.hEintBrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 13, 0);
        this.getContentPane().add((Component)this.hEintBrTF, gridBagConstraints);
        this.hAutoEintCB.setText(this.rbundle.getString("auto"));
        this.hAutoEintCB.setToolTipText(bundle.getString("autoDivision_TIP"));
        this.hAutoEintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hAutoEintCBActionPerformed(evt);
            }
        });
        this.hAutoEintCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 13, 6);
        this.getContentPane().add((Component)this.hAutoEintCB, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText(this.rbundle.getString("Feinteilung"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 10, 13, 0);
        this.getContentPane().add((Component)this.jLabel12, gridBagConstraints);
        this.hFeinTF.setColumns(4);
        this.hFeinTF.setToolTipText(bundle.getString("Subdivisions_TIP"));
        this.hFeinTF.setOpaque(true);
        this.hFeinTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung.this.hFeinTFFocusLost(evt);
            }
        });
        this.hFeinTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.hFeinTFActionPerformed(evt);
            }
        });
        this.hFeinTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 13, 0);
        this.getContentPane().add((Component)this.hFeinTF, gridBagConstraints);
        this.achsenSichtbCB.setText(bundle.getString("Axis_always_visible_at_automatic"));
        this.achsenSichtbCB.setToolTipText(bundle.getString("achseSichtbCB_TIP"));
        this.achsenSichtbCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung.this.achsenSichtbCBActionPerformed(evt);
            }
        });
        this.achsenSichtbCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                KSEinstellung.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 18;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 13, 12);
        this.getContentPane().add((Component)this.achsenSichtbCB, gridBagConstraints);
        this.rechtsAuftrTF.setColumns(8);
        this.rechtsAuftrTF.setToolTipText(bundle.getString("RechtsachseField_TIP"));
        this.rechtsAuftrTF.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(14, 5, 0, 0);
        this.getContentPane().add((Component)this.rechtsAuftrTF, gridBagConstraints);
        this.pack();
    }

    private void hAutoEintCBActionPerformed(ActionEvent evt) {
        this.ks.autoGitterY = this.hAutoEintCB.isSelected();
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAutoCBActionPerformed(ActionEvent evt) {
        this.ks.rechtsAnp = this.rAutoCB.isSelected();
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAutoEintCBActionPerformed(ActionEvent evt) {
        this.ks.autoGitterX = this.rAutoEintCB.isSelected();
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAutoCBActionPerformed(ActionEvent evt) {
        this.ks.hochAnp = this.hAutoCB.isSelected();
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAnfTFActionPerformed(ActionEvent evt) {
        this.ks.XMin = Statics.textFieldToDouble(this.rAnfTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEndTFActionPerformed(ActionEvent evt) {
        this.ks.XMax = Statics.textFieldToDouble(this.rEndTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAnfTFFocusLost(FocusEvent evt) {
        this.ks.XMin = Statics.textFieldToDouble(this.rAnfTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEndTFFocusLost(FocusEvent evt) {
        this.ks.XMax = Statics.textFieldToDouble(this.rEndTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEintBrTFActionPerformed(ActionEvent evt) {
        this.ks.XBigTickDist = Statics.textFieldToDouble(this.rEintBrTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEintBrTFFocusLost(FocusEvent evt) {
        this.ks.XBigTickDist = Statics.textFieldToDouble(this.rEintBrTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rFeinTFActionPerformed(ActionEvent evt) {
        this.ks.XSmallTicks = (int)Statics.textFieldToDouble(this.rFeinTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rFeinTFFocusLost(FocusEvent evt) {
        this.ks.XSmallTicks = (int)Statics.textFieldToDouble(this.rFeinTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAnfTFActionPerformed(ActionEvent evt) {
        this.ks.YMin = Statics.textFieldToDouble(this.hAnfTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAnfTFFocusLost(FocusEvent evt) {
        this.ks.YMin = Statics.textFieldToDouble(this.hAnfTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEndTFActionPerformed(ActionEvent evt) {
        this.ks.YMax = Statics.textFieldToDouble(this.hEndTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEndTFFocusLost(FocusEvent evt) {
        this.ks.YMax = Statics.textFieldToDouble(this.hEndTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEintBrTFActionPerformed(ActionEvent evt) {
        this.ks.YBigTickDist = Statics.textFieldToDouble(this.hEintBrTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEintBrTFFocusLost(FocusEvent evt) {
        this.ks.YBigTickDist = Statics.textFieldToDouble(this.hEintBrTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hFeinTFActionPerformed(ActionEvent evt) {
        this.ks.YSmallTicks = (int)Statics.textFieldToDouble(this.hFeinTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hFeinTFFocusLost(FocusEvent evt) {
        this.ks.YSmallTicks = (int)Statics.textFieldToDouble(this.hFeinTF, false);
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void cbKeyPressed(KeyEvent evt) {
        if (evt.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && evt.getKeyChar() == 'w') {
            this.setVisible(false);
        }
    }

    private void achsenSichtbCBActionPerformed(ActionEvent evt) {
        this.ks.achseSichtbar = this.achsenSichtbCB.isSelected();
        this.ks.adjustPlotRange();
        this.ks.zeichneAlles();
        this.projekt.getDiagramm().repaint();
    }

    public final void updateFields() {
        if (this.ks == null) {
            return;
        }
        UIManager.put("MenuItem.font", Statics.mathFont);
        VariablesPopup varPopup = new VariablesPopup(this.projekt.getModel(), e -> {
            if (this.rechtsAuftrTF.getSelectedText() != null) {
                this.rechtsAuftrTF.replaceSelection(e.getActionCommand());
            } else if (this.rechtsAuftrTFWasActive) {
                this.rechtsAuftrTF.replaceSelection(e.getActionCommand());
            } else {
                this.rechtsAuftrTF.setText(e.getActionCommand());
            }
            this.requestFocus();
            this.ks.setAuftragungsStringsMitZeichnen(this.rechtsAuftrTF.getText(), null);
        });
        varPopup.addPopupMenuListener(this.rechtsAuftrTFPopupMenuListener);
        this.rechtsAuftrTF.setComponentPopupMenu(varPopup);
        this.rechtsAuftrTF.setText(this.ks.varRechtsStr);
        this.rAnfTF.setText(Statics.doubleToString(this.ks.XMin));
        this.rEndTF.setText(Statics.doubleToString(this.ks.XMax));
        this.rAnfTF.setEnabled(!this.ks.rechtsAnp);
        this.rEndTF.setEnabled(!this.ks.rechtsAnp);
        this.rAutoCB.setSelected(this.ks.rechtsAnp);
        this.rEintBrTF.setText(Statics.doubleToString(this.ks.XBigTickDist));
        this.rEintBrTF.setEnabled(!this.ks.autoGitterX);
        this.rFeinTF.setText(Statics.doubleToString(this.ks.XSmallTicks));
        if (this.ks.XSmallTicks <= 1) {
            this.rFeinTF.setText("1");
        }
        this.rFeinTF.setEnabled(!this.ks.autoGitterX);
        this.rAutoEintCB.setSelected(this.ks.autoGitterX);
        varPopup = new VariablesPopup(this.projekt.getModel(), e -> {
            if (this.hochAuftrTF.getSelectedText() != null) {
                this.hochAuftrTF.replaceSelection(e.getActionCommand());
            } else if (this.hochAuftrTFWasActive) {
                this.hochAuftrTF.replaceSelection(e.getActionCommand());
            } else {
                this.hochAuftrTF.setText(e.getActionCommand());
            }
            this.requestFocus();
            this.ks.setAuftragungsStringsMitZeichnen(null, this.hochAuftrTF.getText());
        });
        varPopup.addPopupMenuListener(this.hochAuftrTFPopupMenuListener);
        this.hochAuftrTF.setComponentPopupMenu(varPopup);
        this.hochAuftrTF.setText(this.ks.varHochStr);
        this.hAnfTF.setText(Statics.doubleToString(this.ks.YMin));
        this.hEndTF.setText(Statics.doubleToString(this.ks.YMax));
        this.hAnfTF.setEnabled(!this.ks.hochAnp);
        this.hEndTF.setEnabled(!this.ks.hochAnp);
        this.hAutoCB.setSelected(this.ks.hochAnp);
        this.hEintBrTF.setText(Statics.doubleToString(this.ks.YBigTickDist));
        this.hEintBrTF.setEnabled(!this.ks.autoGitterY);
        this.hFeinTF.setText(Statics.doubleToString(this.ks.YSmallTicks));
        if (this.ks.YSmallTicks <= 1) {
            this.hFeinTF.setText("1");
        }
        this.hFeinTF.setEnabled(!this.ks.autoGitterY);
        this.hAutoEintCB.setSelected(this.ks.autoGitterY);
        if (this.ks.whatToDo == 6) {
            this.hochAuftrTF.requestFocus();
        } else {
            this.rechtsAuftrTF.requestFocus();
        }
        UIManager.put("MenuItem.font", null);
    }
}

