/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Diagram;
import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Statics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class Legend
extends JPanel {
    private static final long serialVersionUID = 1L;
    ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/Legend");
    Document projekt;
    private float myscale;
    private Koordinatensystem ks;
    String modelTxt = this.rbundle.getString("Berechnung");
    String fktTxt = this.rbundle.getString("Vergleichsfkt");
    String cvalTxt = this.rbundle.getString("VerglWerte");

    public Legend(Document prj) {
        this.projekt = prj;
        this.myscale = 1.0f;
    }

    public void setTxt(String mtxt, String ftxt, String cvtxt) {
        if (mtxt != null && mtxt.length() > 0) {
            this.modelTxt = mtxt;
        }
        if (ftxt != null && ftxt.length() > 0) {
            this.fktTxt = ftxt;
        }
        if (cvtxt != null && cvtxt.length() > 0) {
            this.cvalTxt = cvtxt;
        }
    }

    @Override
    public void paint(Graphics g) {
        String s;
        int i;
        if (this.ks == null) {
            return;
        }
        int textbreite = 0;
        float savescale = this.myscale;
        Graphics2D g2d = (Graphics2D)g;
        String[] vHochStr = this.ks.varHochStr.split(";");
        this.myscale *= Statics.prefsDialog.graphicsScale;
        g2d.scale(this.myscale, this.myscale);
        g.setFont(new Font("Dialog", 0, 12));
        int h = 4;
        h += 16 * vHochStr.length;
        if (this.ks.fktPlotted) {
            h += 16;
        }
        if (this.ks.wertePlotted) {
            h += 16;
        }
        h += 4;
        for (i = 0; i < vHochStr.length; ++i) {
            s = this.modelTxt + " " + vHochStr[i].strip() + ":";
            if (textbreite >= g.getFontMetrics().stringWidth(s)) continue;
            textbreite = g.getFontMetrics().stringWidth(s);
        }
        if (textbreite < g.getFontMetrics().stringWidth(this.fktTxt)) {
            textbreite = g.getFontMetrics().stringWidth(this.fktTxt);
        }
        if (textbreite < g.getFontMetrics().stringWidth(this.cvalTxt)) {
            textbreite = g.getFontMetrics().stringWidth(this.cvalTxt);
        }
        this.setSize(7 + textbreite + 10 + 50 + 3, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        g.setColor(new Color(0, 0, 0, 30));
        for (i = 3; i >= 0; --i) {
            g.fillRoundRect(i, i, this.getWidth() - 2 * i, this.getHeight() - 2 * i, 8, 8);
        }
        g.setColor(Color.WHITE);
        g.fillRect(1, 1, this.getWidth() - 4, this.getHeight() - 4);
        g.setColor(Color.BLACK);
        g.drawRect(1, 1, this.getWidth() - 4, this.getHeight() - 4);
        int yko = 15;
        for (int i2 = 0; i2 < vHochStr.length; ++i2) {
            s = this.modelTxt + " " + vHochStr[i2].strip() + ":";
            g.drawString(s, 7, yko);
            yko += 16;
        }
        yko = 15;
        Point point = new Point();
        for (int i3 = 0; i3 < vHochStr.length; ++i3) {
            g.setColor(Diagram.colorArray[this.projekt.zeichFarbIndex]);
            ((Graphics2D)g).setStroke(new BasicStroke(this.projekt.linienStaerke, 0, 2));
            if (this.projekt.linienStaerke > 0) {
                g.drawLine(10 + textbreite, yko - 5 + this.projekt.linienStaerke / 16, 10 + textbreite + 50, yko - 5 + this.projekt.linienStaerke / 16);
            }
            point.x = 10 + textbreite + 8;
            point.y = yko - 5;
            this.projekt.getModel().zeichnePunkt(g, point, this.projekt.punktGroesse, i3);
            point.x = 10 + textbreite + 25;
            this.projekt.getModel().zeichnePunkt(g, point, this.projekt.punktGroesse, i3);
            point.x = 10 + textbreite + 42;
            this.projekt.getModel().zeichnePunkt(g, point, this.projekt.punktGroesse, i3);
            yko += 16;
        }
        if (this.ks.fktPlotted) {
            BasicStroke fktStroke;
            float lSt = this.projekt.fktBreite;
            if (this.projekt.fktStrichelung > 0) {
                float[] dash1 = new float[]{(float)this.projekt.fktStrichelung * lSt, (float)this.projekt.fktStrichelung * lSt};
                if (this.projekt.fktStrichelung > 4) {
                    dash1[1] = (float)(this.projekt.fktStrichelung / 2) * lSt;
                }
                fktStroke = new BasicStroke(lSt, 0, 0, lSt, dash1, 0.0f);
            } else {
                fktStroke = new BasicStroke(lSt, 0, 0, lSt);
            }
            g.setColor(Color.BLACK);
            g.drawString(this.fktTxt, 7, yko);
            g.setColor(Diagram.colorArray[this.projekt.fktFarbIndex]);
            ((Graphics2D)g).setStroke(fktStroke);
            g.drawLine(10 + textbreite, yko - 4 + this.projekt.fktBreite / 16, 10 + textbreite + 50, yko - 4 + this.projekt.fktBreite / 16);
            yko += 16;
        }
        if (this.ks.wertePlotted) {
            g.setColor(Color.BLACK);
            g.drawString(this.cvalTxt, 7, yko);
            g.setColor(Diagram.colorArray[this.projekt.werteFarbIndex]);
            float pGr = (float)this.projekt.wertePktGr * (this.myscale == 1.0f ? 1.0f : 0.8f);
            int pGr2 = (int)(pGr / 2.0f);
            float lSt = 1.0f * (this.myscale == 1.0f ? 1.0f : 0.8f);
            ((Graphics2D)g).setStroke(new BasicStroke(lSt));
            point = new Point(10 + textbreite + 8, yko - 5);
            g.drawLine(point.x - pGr2, point.y - pGr2, point.x + pGr2, point.y + pGr2);
            g.drawLine(point.x - pGr2, point.y + pGr2, point.x + pGr2, point.y - pGr2);
            point.x = 10 + textbreite + 25;
            g.drawLine(point.x - pGr2, point.y - pGr2, point.x + pGr2, point.y + pGr2);
            g.drawLine(point.x - pGr2, point.y + pGr2, point.x + pGr2, point.y - pGr2);
            point.x = 10 + textbreite + 42;
            g.drawLine(point.x - pGr2, point.y - pGr2, point.x + pGr2, point.y + pGr2);
            g.drawLine(point.x - pGr2, point.y + pGr2, point.x + pGr2, point.y - pGr2);
        }
        g2d.scale(1.0f / this.myscale, 1.0f / this.myscale);
        this.myscale = savescale;
    }

    public float getScale() {
        return this.myscale;
    }

    public void setScale(float scale) {
        this.myscale = scale;
    }

    public void setKS(Koordinatensystem ksys) {
        this.ks = ksys;
    }

    public boolean isOnModel(Point p) {
        String[] vHochStr = this.ks.varHochStr.split(";");
        return p.y - 4 <= vHochStr.length * 16;
    }

    public boolean isOnFkt(Point p) {
        String[] vHochStr = this.ks.varHochStr.split(";");
        return p.y - 4 > vHochStr.length * 16 && p.y - 4 <= vHochStr.length * 16 + 16;
    }

    public boolean isOnWerte(Point p) {
        String[] vHochStr = this.ks.varHochStr.split(";");
        return p.y - 4 > vHochStr.length * 16 + 16;
    }
}

