/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TableImportDialog
extends JDialog {
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/TableImportDialog", Statics.locale);
    private final Document projekt;
    private ArrayList<String> inputList;
    private final Color redColor = new Color(181, 23, 0);
    private boolean importClicked = false;
    private String decimalString;
    private String sep1000String;
    public String[] spaltenTitel;
    private String[][] neueStrDaten;
    public Double[][] neueDaten;
    private JButton cancelButton;
    private JCheckBox colTitlesCB;
    private JCheckBox commaCB;
    private JComboBox<String> decimalCB;
    private JCheckBox ignoreCB;
    private JTextField ignoreTF;
    private JButton importButton;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel numSepPanel;
    private JCheckBox otherCB;
    private JTextField otherTF;
    private JTable prevTable;
    private JCheckBox semicolonCB;
    private JComboBox<String> sep1000CB;
    private JPanel sepPanel;
    private JSpinner skipColsSP;
    private JSpinner skipRowsSP;
    private JCheckBox spaceCB;
    private JCheckBox tabCB;
    private JScrollPane tablePane;
    private JSpinner titleRowSP;

    public TableImportDialog(Frame parent, boolean modal, Document prj) {
        super(parent, modal);
        this.projekt = prj;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.importButton);
        this.prevTable.setGridColor(Color.LIGHT_GRAY);
        this.prevTable.setDefaultRenderer(String.class, new MyCellRenderer());
        this.prevTable.getTableHeader().setDefaultRenderer(new MyHeaderCellRenderer());
        this.prevTable.setBackground(new Color(238, 255, 234));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.skipRowsSP = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel9 = new JLabel();
        this.skipColsSP = new JSpinner();
        this.jLabel10 = new JLabel();
        this.colTitlesCB = new JCheckBox();
        this.titleRowSP = new JSpinner();
        this.jLabel4 = new JLabel();
        this.sepPanel = new JPanel();
        this.tabCB = new JCheckBox();
        this.semicolonCB = new JCheckBox();
        this.commaCB = new JCheckBox();
        this.spaceCB = new JCheckBox();
        this.otherCB = new JCheckBox();
        this.otherTF = new JTextField();
        this.jLabel6 = new JLabel();
        this.numSepPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.decimalCB = new JComboBox();
        this.jLabel8 = new JLabel();
        this.sep1000CB = new JComboBox();
        this.jPanel1 = new JPanel();
        this.ignoreCB = new JCheckBox();
        this.ignoreTF = new JTextField();
        this.jLabel5 = new JLabel();
        this.tablePane = new JScrollPane();
        this.prevTable = new JTable();
        this.cancelButton = new JButton();
        this.importButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rbundle.getString("Text_import"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setText(this.rbundle.getString("Import_specifications"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(this.rbundle.getString("Skip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.skipRowsSP.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.skipRowsSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TableImportDialog.this.skipRowsSPStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.getContentPane().add((Component)this.skipRowsSP, gridBagConstraints);
        this.jLabel3.setText(this.rbundle.getString("lines"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel9.setText(this.rbundle.getString("Skip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 11, 0, 0);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.skipColsSP.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.skipColsSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TableImportDialog.this.skipColsSPStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.skipColsSP, gridBagConstraints);
        this.jLabel10.setText(this.rbundle.getString("columns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.colTitlesCB.setText(this.rbundle.getString("Use_column_titles"));
        this.colTitlesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.checkBoxAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.getContentPane().add((Component)this.colTitlesCB, gridBagConstraints);
        this.titleRowSP.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.titleRowSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TableImportDialog.this.titleRowSPStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.titleRowSP, gridBagConstraints);
        this.jLabel4.setText(this.rbundle.getString("Separation_symbols"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 11, 3, 0);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.sepPanel.setLayout(new GridBagLayout());
        this.tabCB.setSelected(true);
        this.tabCB.setText(this.rbundle.getString("Tabstop"));
        this.tabCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.checkBoxAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.sepPanel.add((Component)this.tabCB, gridBagConstraints);
        this.semicolonCB.setSelected(true);
        this.semicolonCB.setText(this.rbundle.getString("Semicolon"));
        this.semicolonCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.checkBoxAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.sepPanel.add((Component)this.semicolonCB, gridBagConstraints);
        this.commaCB.setText(this.rbundle.getString("Comma"));
        this.commaCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.checkBoxAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.sepPanel.add((Component)this.commaCB, gridBagConstraints);
        this.spaceCB.setSelected(true);
        this.spaceCB.setText(this.rbundle.getString("Space"));
        this.spaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.checkBoxAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.sepPanel.add((Component)this.spaceCB, gridBagConstraints);
        this.otherCB.setText(this.rbundle.getString("Other"));
        this.otherCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.otherCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.sepPanel.add((Component)this.otherCB, gridBagConstraints);
        this.otherTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TableImportDialog.this.otherTFKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 17;
        this.sepPanel.add((Component)this.otherTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.getContentPane().add((Component)this.sepPanel, gridBagConstraints);
        this.jLabel6.setText(this.rbundle.getString("Numerical_separators"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 11, 3, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.numSepPanel.setLayout(new GridBagLayout());
        this.jLabel7.setText(this.rbundle.getString("Decimal_point"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.numSepPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.decimalCB.setEditable(true);
        this.decimalCB.setMaximumRowCount(2);
        this.decimalCB.setModel(new DefaultComboBoxModel<String>(new String[]{".", ","}));
        this.decimalCB.setSelectedIndex(1);
        this.decimalCB.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
        this.decimalCB.setPreferredSize(new Dimension(50, 26));
        this.decimalCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.decimalCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.numSepPanel.add(this.decimalCB, gridBagConstraints);
        this.jLabel8.setText(this.rbundle.getString("1000_separator"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.numSepPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.sep1000CB.setEditable(true);
        this.sep1000CB.setMaximumRowCount(2);
        this.sep1000CB.setModel(new DefaultComboBoxModel<String>(new String[]{" ", ".", ","}));
        this.sep1000CB.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
        this.sep1000CB.setPreferredSize(new Dimension(50, 26));
        this.sep1000CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.sep1000CBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.numSepPanel.add(this.sep1000CB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 17, 0, 0);
        this.getContentPane().add((Component)this.numSepPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.ignoreCB.setText(this.rbundle.getString("Ignore_characters"));
        this.ignoreCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.ignoreCBActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.ignoreCB, new GridBagConstraints());
        this.ignoreTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TableImportDialog.this.ignoreTFKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                TableImportDialog.this.ignoreTFKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 75;
        this.jPanel1.add((Component)this.ignoreTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 11, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel5.setText(this.rbundle.getString("Table_preview"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.tablePane.setPreferredSize(new Dimension(300, 292));
        this.prevTable.setBackground(new Color(218, 235, 214));
        this.prevTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.prevTable.setRequestFocusEnabled(false);
        this.prevTable.setRowSelectionAllowed(false);
        this.tablePane.setViewportView(this.prevTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.getContentPane().add((Component)this.tablePane, gridBagConstraints);
        this.cancelButton.setText(this.rbundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.importButton.setText(this.rbundle.getString("Import"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableImportDialog.this.importButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.getContentPane().add((Component)this.importButton, gridBagConstraints);
        this.pack();
    }

    private void checkBoxAction(ActionEvent evt) {
        this.updateTable();
        this.titleRowSP.setEnabled(this.colTitlesCB.isSelected());
    }

    private void otherCBActionPerformed(ActionEvent evt) {
        this.otherTF.setEnabled(this.otherCB.isSelected());
        this.updateTable();
    }

    private void skipRowsSPStateChanged(ChangeEvent evt) {
        this.updateTable();
    }

    private void decimalCBActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private void sep1000CBActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.updateTable();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.importClicked = true;
        this.setVisible(false);
        this.updateTable();
    }

    private void skipColsSPStateChanged(ChangeEvent evt) {
        this.updateTable();
    }

    private void titleRowSPStateChanged(ChangeEvent evt) {
        this.updateTable();
    }

    private void otherTFKeyTyped(KeyEvent evt) {
        this.otherTF.setText("" + evt.getKeyChar());
        evt.consume();
        this.updateTable();
    }

    private void ignoreCBActionPerformed(ActionEvent evt) {
        this.ignoreTF.setEnabled(this.ignoreCB.isSelected());
        this.updateTable();
    }

    private void ignoreTFKeyTyped(KeyEvent evt) {
    }

    private void ignoreTFKeyReleased(KeyEvent evt) {
        this.updateTable();
    }

    private void updateTable() {
        int i;
        ArrayList<String> outputList;
        int cols = 0;
        int skipColumns = (Integer)this.skipColsSP.getValue();
        this.decimalString = (String)this.decimalCB.getSelectedItem();
        this.sep1000String = (String)this.sep1000CB.getSelectedItem();
        int rows = this.inputList.size();
        int skip = (Integer)this.skipRowsSP.getValue();
        Object regex = "[#";
        if (this.tabCB.isSelected()) {
            regex = (String)regex + "\t";
        }
        if (this.semicolonCB.isSelected()) {
            regex = (String)regex + ";";
        }
        if (this.commaCB.isSelected()) {
            regex = (String)regex + ",";
        }
        if (this.spaceCB.isSelected()) {
            regex = (String)regex + " ";
        }
        if (this.otherCB.isSelected()) {
            regex = (String)regex + this.otherTF.getText();
        }
        regex = (String)regex + "]";
        if (this.ignoreCB.isSelected()) {
            outputList = new ArrayList();
            char[] ignoredCharacters = this.ignoreTF.getText().toCharArray();
            for (i = 0; i < this.inputList.size(); ++i) {
                String zeile = this.inputList.get(i);
                for (char c : ignoredCharacters) {
                    zeile = zeile.replaceAll("" + c, "");
                }
                outputList.add(zeile);
            }
        } else {
            outputList = this.inputList;
        }
        if (this.colTitlesCB.isSelected()) {
            String[] sp = outputList.get((Integer)this.titleRowSP.getValue() - 1).split((String)regex);
            this.spaltenTitel = new String[sp.length - skipColumns];
            for (i = 0; i < sp.length - skipColumns; ++i) {
                this.spaltenTitel[i] = sp[i + skipColumns];
            }
            ++skip;
        } else {
            this.spaltenTitel = this.projekt.getCompValTable().getSpaltenNamen();
        }
        cols = this.spaltenTitel.length;
        this.neueStrDaten = new String[rows - skip][cols];
        for (i = skip; i < rows; ++i) {
            String[] zeilenTeile = outputList.get(i).split((String)regex);
            for (int j = skipColumns; j < cols + skipColumns; ++j) {
                if (j >= zeilenTeile.length) continue;
                this.neueStrDaten[i - skip][j - skipColumns] = zeilenTeile[j];
            }
        }
        this.prevTable.setModel(new myTableModel(this.spaltenTitel, this.neueStrDaten));
    }

    public boolean showDialog(ArrayList<String> inputList) {
        this.inputList = inputList;
        this.otherTF.setEnabled(this.otherCB.isSelected());
        this.titleRowSP.setEnabled(this.colTitlesCB.isSelected());
        this.ignoreTF.setEnabled(this.ignoreCB.isSelected());
        this.updateTable();
        Point p = this.getParent().getLocationOnScreen();
        p.translate((this.getParent().getWidth() - this.getWidth()) / 2, (this.getParent().getHeight() - this.getHeight()) / 3);
        this.setLocation(p);
        this.setVisible(true);
        if (this.importClicked) {
            this.neueDaten = new Double[this.neueStrDaten.length][this.neueStrDaten[0].length];
            for (int i = 0; i < this.neueDaten.length; ++i) {
                for (int j = 0; j < this.neueDaten[0].length; ++j) {
                    try {
                        this.neueDaten[i][j] = Double.valueOf(this.neueStrDaten[i][j].replace(this.decimalString, "\u00a7").replace(this.sep1000String, "").replace("\u00a7", "."));
                        continue;
                    }
                    catch (Exception ex) {
                        this.neueDaten[i][j] = null;
                    }
                }
            }
        }
        return this.importClicked;
    }

    class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            try {
                super.setValue(Tabelle.df.format(Double.valueOf(((String)value).replace(TableImportDialog.this.decimalString, "\u00a7").replace(TableImportDialog.this.sep1000String, "").replace("\u00a7", "."))));
                this.setForeground(Color.BLACK);
            }
            catch (Exception ex) {
                super.setValue(value);
                this.setForeground(TableImportDialog.this.redColor);
            }
        }
    }

    class MyHeaderCellRenderer
    extends DefaultTableCellRenderer {
        public MyHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setVerticalAlignment(0);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            table.setRowHeight(17);
            table.setFont(new Font("Dialog", 0, 13));
            this.setFont(Statics.mathFont.deriveFont(3, 13.0f));
            this.setPreferredSize(new Dimension(this.getWidth(), 16));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    class myTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames;
        private final Object[][] data;

        public myTableModel(String[] colNam, Object[][] dat) {
            this.columnNames = colNam;
            this.data = dat;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            try {
                this.data[row][col] = value;
            }
            catch (Exception e) {
                return;
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

