/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.freehep.util.io.DecodingInputStream;
import org.freehep.util.io.RouteListener;

public class RoutedInputStream
extends DecodingInputStream {
    private InputStream in;
    private Map<byte[], Object> routes;
    private Map<byte[], Object> listeners;
    private byte[] buffer;
    private int sob;
    private int eob;
    private int index;
    private int state;
    private byte[] start;
    private static final int UNROUTED = 0;
    private static final int ROUTEFOUND = 1;
    private static final int ROUTEINFORM = 2;
    private static final int ROUTED = 3;
    private static final int CLOSING = 4;
    private static final int CLOSED = 5;

    public RoutedInputStream(InputStream input) {
        this.in = input;
        this.routes = new HashMap<byte[], Object>();
        this.listeners = new HashMap<byte[], Object>();
        this.buffer = new byte[20];
        this.sob = -1;
        this.eob = 0;
        this.index = 0;
        this.state = 0;
    }

    @Override
    public int read() throws IOException {
        block7: while (true) {
            switch (this.state) {
                default: {
                    int b = -1;
                    while (this.sob != this.eob) {
                        if (this.sob < 0) {
                            this.sob = 0;
                        }
                        if ((b = this.in.read()) < 0) {
                            this.state = 4;
                            continue block7;
                        }
                        this.buffer[this.eob] = (byte)b;
                        this.eob = (this.eob + 1) % this.buffer.length;
                        for (byte[] this.start : this.routes.keySet()) {
                            this.index = (this.eob + this.buffer.length - this.start.length) % this.buffer.length;
                            if (!RoutedInputStream.equals(this.start, this.buffer, this.index)) continue;
                            this.state = 1;
                            continue block7;
                        }
                    }
                    int result = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return result;
                }
                case 1: {
                    if (this.sob == this.index) {
                        this.state = 2;
                        continue block7;
                    }
                    int result = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return result;
                }
                case 2: {
                    this.state = 3;
                    Route route = new Route(this.start, (byte[])this.routes.get(this.start));
                    ((RouteListener)this.listeners.get(this.start)).routeFound(route);
                    this.state = 0;
                    if (this.sob == this.eob) {
                        this.sob = -1;
                        this.eob = 0;
                        continue block7;
                    }
                    int result = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return result;
                }
                case 3: {
                    int result;
                    if (this.sob == this.eob) {
                        result = this.in.read();
                        if (result < 0) {
                            this.state = 5;
                            continue block7;
                        }
                    } else {
                        result = this.buffer[this.sob];
                        this.sob = (this.sob + 1) % this.buffer.length;
                    }
                    return result;
                }
                case 4: {
                    if (this.sob == this.eob) {
                        this.state = 5;
                        continue block7;
                    }
                    int result = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return result;
                }
                case 5: 
            }
            break;
        }
        return -1;
    }

    public void addRoute(String start, String end, RouteListener listener) {
        this.addRoute(start.getBytes(), end == null ? null : end.getBytes(), listener);
    }

    public void addRoute(byte[] start, byte[] end, RouteListener listener) {
        Iterator<byte[]> i = this.routes.keySet().iterator();
        while (i.hasNext()) {
            String name;
            String key = new String(i.next());
            if (!key.startsWith(name = new String(start)) && !name.startsWith(key)) continue;
            throw new IllegalArgumentException("Route '" + name + "' cannot be added since it overlaps with '" + key + "'.");
        }
        this.routes.put(start, end);
        this.listeners.put(start, listener);
        if (start.length > this.buffer.length - 1) {
            byte[] tmp = new byte[start.length + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
    }

    private static boolean equals(byte[] cmp, byte[] buf, int index) {
        for (int i = cmp.length - 1; i > 0; --i) {
            int j = (index + buf.length + i) % buf.length;
            if (buf[j] == cmp[i]) continue;
            return false;
        }
        return buf[(index + buf.length) % buf.length] == cmp[0];
    }

    public class Route
    extends InputStream {
        private byte[] start;
        private byte[] end;
        private byte[] buffer;
        private int index;
        private boolean closed;

        public Route(byte[] start, byte[] end) {
            this.start = start;
            this.end = end;
            if (end != null) {
                this.buffer = new byte[end.length];
            }
            this.index = 0;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                return -1;
            }
            int b = RoutedInputStream.this.read();
            if (b < 0) {
                this.closed = true;
                return b;
            }
            if (this.end == null) {
                return b;
            }
            this.buffer[this.index] = (byte)b;
            this.index = (this.index + 1) % this.buffer.length;
            this.closed = RoutedInputStream.equals(this.end, this.buffer, this.index);
            return b;
        }

        @Override
        public void close() throws IOException {
            while (this.read() >= 0) {
            }
            this.closed = true;
        }

        public byte[] getStart() {
            return this.start;
        }

        public byte[] getEnd() {
            return this.end;
        }
    }
}

