/*
 * Decompiled with CFR 0.152.
 */
package Programm;

public abstract class MechSystem {
    public double epsilon = 0.01;
    boolean preserveenergy = true;
    boolean constrainenergy = false;
    int oldx;
    int oldy;
    public double[] q;
    public double[] qp;
    public double[] period;
    boolean[] constrained;
    double[] oldq;
    double[] oldqp;
    double totalenergy;
    double[][] A;
    double[] rhs;
    double[] qpp;
    double[] qn;
    double[][] K;
    double[][] Kp;
    double[] qtmp;
    double[] qptmp;
    public int N;

    public MechSystem() {
    }

    public MechSystem(int dim, double eps) {
        this.epsilon = eps;
        this.N = dim;
        this.q = new double[this.N];
        this.qp = new double[this.N];
        this.period = new double[this.N];
        this.oldq = new double[this.N];
        this.oldqp = new double[this.N];
        this.A = new double[this.N][this.N];
        this.rhs = new double[this.N];
        this.qpp = new double[this.N];
        this.qn = new double[this.N];
        this.constrained = new boolean[this.N];
        this.K = new double[4][this.N];
        this.Kp = new double[4][this.N];
        this.qtmp = new double[this.N];
        this.qptmp = new double[this.N];
    }

    void toggleenergy() {
        this.constrainenergy = !this.constrainenergy;
        this.setEnergy();
    }

    public abstract double T(double[] var1, double[] var2);

    public abstract double U(double[] var1);

    double L(double[] q, double[] qp) {
        return this.T(q, qp) - this.U(q);
    }

    double E(double[] q, double[] qp) {
        return this.T(q, qp) + this.U(q);
    }

    double E() {
        return this.E(this.q, this.qp);
    }

    void adjustEnergy() {
        double kinetic = this.T(this.q, this.qp);
        double potential = this.U(this.q);
        double targetkinetic = this.totalenergy - potential;
        if (targetkinetic < 0.0) {
            this.qp[1] = 0.0;
            this.qp[0] = 0.0;
            return;
        }
        if (kinetic < this.epsilon) {
            return;
        }
        double speedup = Math.sqrt(targetkinetic / kinetic);
        for (int i = 0; i < this.N; ++i) {
            if (this.constrained[i]) continue;
            int n = i;
            this.qp[n] = this.qp[n] * speedup;
        }
    }

    void setEnergy(double target) {
        double potential = this.U(this.q);
        this.totalenergy = target < potential ? potential : target;
    }

    void setEnergy() {
        this.setEnergy(this.E());
    }

    double diffq(int i, double[] q, double[] qp) {
        int n = i;
        q[n] = q[n] + this.epsilon;
        double L1 = this.L(q, qp);
        int n2 = i;
        q[n2] = q[n2] - 2.0 * this.epsilon;
        double L0 = this.L(q, qp);
        int n3 = i;
        q[n3] = q[n3] + this.epsilon;
        return (L1 - L0) / (2.0 * this.epsilon);
    }

    double diffpp(int i, int j, double[] q, double[] qp) {
        int n = i;
        qp[n] = qp[n] + this.epsilon;
        int n2 = j;
        qp[n2] = qp[n2] + this.epsilon;
        double L11 = this.L(q, qp);
        int n3 = j;
        qp[n3] = qp[n3] - 2.0 * this.epsilon;
        double L10 = this.L(q, qp);
        int n4 = i;
        qp[n4] = qp[n4] - 2.0 * this.epsilon;
        double L00 = this.L(q, qp);
        int n5 = j;
        qp[n5] = qp[n5] + 2.0 * this.epsilon;
        double L01 = this.L(q, qp);
        int n6 = j;
        qp[n6] = qp[n6] - this.epsilon;
        int n7 = i;
        qp[n7] = qp[n7] + this.epsilon;
        return ((L11 - L01) / (2.0 * this.epsilon) - (L10 - L00) / (2.0 * this.epsilon)) / (2.0 * this.epsilon);
    }

    double diffqp(int i, int j, double[] q, double[] qp) {
        int n = i;
        q[n] = q[n] + this.epsilon;
        int n2 = j;
        qp[n2] = qp[n2] + this.epsilon;
        double L11 = this.L(q, qp);
        int n3 = j;
        qp[n3] = qp[n3] - 2.0 * this.epsilon;
        double L10 = this.L(q, qp);
        int n4 = i;
        q[n4] = q[n4] - 2.0 * this.epsilon;
        double L00 = this.L(q, qp);
        int n5 = j;
        qp[n5] = qp[n5] + 2.0 * this.epsilon;
        double L01 = this.L(q, qp);
        int n6 = j;
        qp[n6] = qp[n6] - this.epsilon;
        int n7 = i;
        q[n7] = q[n7] + this.epsilon;
        return ((L11 - L01) / (2.0 * this.epsilon) - (L10 - L00) / (2.0 * this.epsilon)) / (2.0 * this.epsilon);
    }

    double sq(double x) {
        return x * x;
    }

    public void setInitialState(double[] q, double[] qp) {
        for (int i = 0; i < this.N; ++i) {
            this.oldq[i] = this.q[i] = q[i];
            this.oldqp[i] = this.qp[i] = qp[i];
            this.constrained[i] = false;
        }
        this.setEnergy();
    }

    void resetstate() {
        for (int i = 0; i < this.N; ++i) {
            this.q[i] = this.oldq[i];
            this.qp[i] = this.oldqp[i];
            this.constrained[i] = false;
        }
        this.setEnergy();
    }

    void calc_qpp(double[] q, double[] qp, double[] qpp, boolean[] constrained) {
        for (int i = 0; i < this.N; ++i) {
            if (constrained[i]) continue;
            this.rhs[i] = this.diffq(i, q, qp);
            for (int j = 0; j < this.N; ++j) {
                if (constrained[j]) {
                    int n = i;
                    this.rhs[n] = this.rhs[n] - this.diffpp(j, i, q, qp) * qpp[j];
                } else {
                    this.A[i][j] = this.diffpp(j, i, q, qp);
                }
                int n = i;
                this.rhs[n] = this.rhs[n] - this.diffqp(j, i, q, qp) * qp[j];
            }
        }
        this.solve(this.A, this.rhs, qpp, constrained);
    }

    public synchronized void step(double dt) {
        int i;
        for (i = 0; i < this.N; ++i) {
            if (!this.constrained[i]) continue;
            double tmp = this.periodicdiff(this.qn[i], this.q[i], this.period[i]) / dt;
            this.qpp[i] = (tmp - this.qp[i]) / dt;
            this.qp[i] = tmp;
            this.q[i] = this.qn[i];
        }
        this.calc_qpp(this.q, this.qp, this.qpp, this.constrained);
        for (i = 0; i < this.N; ++i) {
            this.K[0][i] = dt * this.qp[i];
            this.Kp[0][i] = dt * this.qpp[i];
        }
        for (i = 0; i < this.N; ++i) {
            this.qtmp[i] = this.q[i] + 0.5 * this.K[0][i];
            this.qptmp[i] = this.qp[i] + 0.5 * this.Kp[0][i];
        }
        this.calc_qpp(this.qtmp, this.qptmp, this.qpp, this.constrained);
        for (i = 0; i < this.N; ++i) {
            this.K[1][i] = dt * this.qptmp[i];
            this.Kp[1][i] = dt * this.qpp[i];
        }
        for (i = 0; i < this.N; ++i) {
            this.qtmp[i] = this.q[i] + 0.5 * this.K[1][i];
            this.qptmp[i] = this.qp[i] + 0.5 * this.Kp[1][i];
        }
        this.calc_qpp(this.qtmp, this.qptmp, this.qpp, this.constrained);
        for (i = 0; i < this.N; ++i) {
            this.K[2][i] = dt * this.qptmp[i];
            this.Kp[2][i] = dt * this.qpp[i];
        }
        for (i = 0; i < this.N; ++i) {
            this.qtmp[i] = this.q[i] + this.K[2][i];
            this.qptmp[i] = this.qp[i] + this.Kp[2][i];
        }
        this.calc_qpp(this.qtmp, this.qptmp, this.qpp, this.constrained);
        for (i = 0; i < this.N; ++i) {
            this.K[3][i] = dt * this.qptmp[i];
            this.Kp[3][i] = dt * this.qpp[i];
        }
        for (i = 0; i < this.N; ++i) {
            if (this.constrained[i]) continue;
            int n = i;
            this.q[n] = this.q[n] + (this.K[0][i] + 2.0 * this.K[1][i] + 2.0 * this.K[2][i] + this.K[3][i]) / 6.0;
            int n2 = i;
            this.qp[n2] = this.qp[n2] + (this.Kp[0][i] + 2.0 * this.Kp[1][i] + 2.0 * this.Kp[2][i] + this.Kp[3][i]) / 6.0;
        }
        if (this.constrainenergy) {
            if (this.preserveenergy) {
                this.adjustEnergy();
            } else {
                this.setEnergy();
                this.preserveenergy = true;
            }
        }
    }

    void solve(double[][] A, double[] v, double[] w, boolean[] constrained) {
        int j;
        if (this.N == 2) {
            this.solve2(A, v, w, constrained);
            return;
        }
        int[] r = new int[this.N];
        int[] c = new int[this.N];
        int n = 0;
        for (int i = 0; i < this.N; ++i) {
            if (constrained[i]) continue;
            c[n] = i;
            r[n] = i;
            ++n;
        }
        for (j = 0; j < n - 1; ++j) {
            for (int i = j + 1; i < n; ++i) {
                if (Math.abs(A[r[j]][c[j]]) < Math.abs(A[r[i]][c[j]])) {
                    int tmp = r[i];
                    r[i] = r[j];
                    r[j] = tmp;
                }
                if (A[r[i]][c[j]] == 0.0) continue;
                double m = A[r[i]][c[j]] / A[r[j]][c[j]];
                for (int k = j; k < n; ++k) {
                    double[] dArray = A[r[i]];
                    int n2 = c[k];
                    dArray[n2] = dArray[n2] - m * A[r[j]][c[k]];
                }
                int n3 = r[i];
                v[n3] = v[n3] - m * v[r[j]];
            }
        }
        for (j = n - 1; j >= 0; --j) {
            double b = v[r[j]];
            for (int k = j + 1; k < n; ++k) {
                b -= w[c[k]] * A[r[j]][c[k]];
            }
            w[c[j]] = b / A[r[j]][c[j]];
        }
    }

    void solve2(double[][] A, double[] v, double[] w, boolean[] constrained) {
        if (constrained[0] && constrained[1]) {
            return;
        }
        if (constrained[0]) {
            w[1] = v[1] / A[1][1];
            return;
        }
        if (constrained[1]) {
            w[0] = v[0] / A[0][0];
            return;
        }
        double det = A[0][0] * A[1][1] - A[0][1] * A[1][0];
        w[0] = (A[1][1] * v[0] - A[0][1] * v[1]) / det;
        w[1] = (-A[1][0] * v[0] + A[0][0] * v[1]) / det;
    }

    double periodicdiff(double a, double b, double period) {
        if (period == 0.0) {
            return a - b;
        }
        return Math.IEEEremainder(a - b, period);
    }
}

