/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.DVariable;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.extensions.djep.PartialDerivative;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DeepCopyVisitor;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class DifferentiationVisitor
extends DeepCopyVisitor {
    private static final long serialVersionUID = 1100L;
    protected DJep djep;
    protected TreeUtils tu;
    Map<String, DiffRulesI> diffRules = new LinkedHashMap<String, DiffRulesI>();

    @Override
    public void init(Jep jep) {
        super.init(jep);
        this.djep = (DJep)jep;
        this.tu = ((DJep)jep).getTreeUtils();
        for (DiffRulesI diffRulesI : this.diffRules.values()) {
            diffRulesI.init(jep);
        }
    }

    void addDiffRule(DiffRulesI diffRulesI) {
        this.diffRules.put(diffRulesI.getName(), diffRulesI);
    }

    public DiffRulesI getDiffRule(String string) {
        return this.diffRules.get(string);
    }

    public void printDiffRules() {
        this.printDiffRules(System.out);
    }

    public void printDiffRules(PrintStream printStream) {
        printStream.println("Operators and their derivatives");
        for (Map.Entry<String, DiffRulesI> object : this.diffRules.entrySet()) {
            if (this.djep.getFunctionTable().containsKey(object.getKey())) continue;
            printStream.println(object.getValue().toString());
        }
        printStream.println("Standard Functions and their derivatives");
        for (Map.Entry<String, DiffRulesI> entry : this.diffRules.entrySet()) {
            if (!this.djep.getFunctionTable().containsKey(entry.getKey())) continue;
            printStream.println(entry.getValue().toString());
        }
        printStream.println("No differentation rule specified for:");
        for (String string : this.djep.getFunctionTable().keySet()) {
            DiffRulesI diffRulesI = this.diffRules.get(string);
            if (diffRulesI != null) continue;
            printStream.print(string + ",");
        }
        printStream.println();
    }

    public Node differentiate(Node node, String string) throws ParseException {
        Node node2;
        if (node == null) {
            throw new IllegalArgumentException("node parameter is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("var parameter is null");
        }
        try {
            node2 = (Node)node.jjtAccept(this, string);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        return node2;
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        return this.visit((ASTFunNode)aSTOpNode, object);
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        String string = aSTFunNode.getName();
        Node[] nodeArray = TreeUtils.getChildrenAsArray(aSTFunNode);
        Node[] nodeArray2 = this.visitChildren(aSTFunNode, object);
        if (aSTFunNode.getPFMC() instanceof DiffRulesI) {
            return ((DiffRulesI)((Object)aSTFunNode.getPFMC())).differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2);
        }
        DiffRulesI diffRulesI = this.diffRules.get(string);
        if (diffRulesI != null) {
            return diffRulesI.differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2);
        }
        throw new ParseException("Sorry I don't know how to differentiate " + aSTFunNode + "\n");
    }

    public boolean isConstantVar(XVariable xVariable) {
        if (!xVariable.hasEquation()) {
            return true;
        }
        Node node = xVariable.getEquation();
        return node instanceof ASTConstant;
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Object object2;
        String string = (String)object;
        XVariable xVariable = (XVariable)aSTVarNode.getVar();
        PartialDerivative partialDerivative = null;
        if (xVariable instanceof DVariable) {
            object2 = (DVariable)xVariable;
            if (string.equals(xVariable.getName())) {
                return this.nf.buildConstantNode(this.tu.getOne());
            }
            if (((DVariable)object2).derivativeIsTrivallyZero()) {
                return this.nf.buildConstantNode(this.tu.getZero());
            }
            try {
                partialDerivative = ((DVariable)object2).findDerivative(string, this.djep);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException);
            }
        } else if (xVariable instanceof PartialDerivative) {
            object2 = (PartialDerivative)xVariable;
            if (((PartialDerivative)object2).derivativeIsTrivallyZero()) {
                return this.nf.buildConstantNode(this.tu.getZero());
            }
            partialDerivative = ((PartialDerivative)object2).findDerivative(string, this.djep);
        } else {
            throw new ParseException("Encountered non differentiable variable " + xVariable);
        }
        object2 = partialDerivative.getEquation();
        if (object2 != null && object2 instanceof ASTVarNode) {
            return this.nf.buildVariableNode(((ASTVarNode)object2).getVar());
        }
        if (object2 != null && object2 instanceof ASTConstant) {
            return this.nf.buildConstantNode(((ASTConstant)object2).getValue());
        }
        return this.nf.buildVariableNode(partialDerivative);
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.nf.buildConstantNode(this.tu.getZero());
    }
}

