/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep.diffRules;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DeepCopyVisitor;

public class PowerDiffRule
implements DiffRulesI {
    private static final long serialVersionUID = 340L;
    private final String name;
    OperatorTableI ot;
    NumberFactory numf;
    NodeFactory nf;
    TreeUtils tu;
    FunctionTable funTab;
    DeepCopyVisitor copier = null;
    Operator pow;
    Operator add;
    Operator sub;
    Operator mul;
    Object eValue = Math.E;

    public PowerDiffRule(DJep dJep, Operator operator) {
        this.ot = dJep.getOperatorTable();
        this.nf = dJep.getNodeFactory();
        this.tu = dJep.getTreeUtils();
        this.funTab = dJep.getFunctionTable();
        this.copier = dJep.getCopier();
        this.numf = dJep.getNumberFactory();
        this.pow = operator;
        this.name = operator.getName();
        this.add = this.ot.getAdd();
        this.sub = this.ot.getSubtract();
        this.mul = this.ot.getMultiply();
    }

    @Override
    public void init(Jep jep) {
        this.ot = jep.getOperatorTable();
        this.nf = jep.getNodeFactory();
        this.tu = ((XJep)jep).getTreeUtils();
        this.funTab = jep.getFunctionTable();
        this.add = this.ot.getAdd();
        this.sub = this.ot.getSubtract();
        this.mul = this.ot.getMultiply();
        this.numf = jep.getNumberFactory();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public String toString() {
        return "diff(y^m,x) -> m * y^(m-1) * diff(y,x) + y^m * ln(m) * diff(m,x)";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node differentiate(ASTFunNode aSTFunNode, String string, Node[] nodeArray, Node[] nodeArray2) throws JepException {
        int n = aSTFunNode.jjtGetNumChildren();
        if (n != 2) {
            throw new ParseException("Too many children " + n + " for " + aSTFunNode + "\n");
        }
        if (this.tu.isConstant(nodeArray[1])) {
            ASTConstant aSTConstant = (ASTConstant)nodeArray[1];
            Object object = aSTConstant.getValue();
            if (object instanceof Double) {
                return this.nf.buildOperatorNode(this.mul, this.copier.deepCopy(nodeArray[1]), this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.nf.buildConstantNode(this.numf.createNumber((Double)object - 1.0))), nodeArray2[0]));
            }
            return this.nf.buildOperatorNode(this.mul, this.copier.deepCopy(nodeArray[1]), this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.nf.buildOperatorNode(this.sub, this.copier.deepCopy(nodeArray[1]), this.nf.buildConstantNode(this.tu.getOne()))), nodeArray2[0]));
        }
        if (this.tu.isConstant(nodeArray[0]) || this.tu.isConstantVariable(nodeArray[0])) {
            Object object = nodeArray[0].getValue();
            if (this.eValue.equals(object)) {
                return this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.copier.deepCopy(nodeArray[1])), nodeArray2[1]);
            }
            return this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.copier.deepCopy(nodeArray[1])), this.copier.getNodeFactory().buildFunctionNode("ln", this.funTab.getFunction("ln"), this.copier.deepCopy(nodeArray[0]))), nodeArray2[1]);
        }
        return this.nf.buildOperatorNode(this.add, this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.mul, this.copier.deepCopy(nodeArray[1]), this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.nf.buildOperatorNode(this.sub, this.copier.deepCopy(nodeArray[1]), this.copier.getNodeFactory().buildConstantNode(this.tu.getOne())))), nodeArray2[0]), this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.mul, this.nf.buildOperatorNode(this.pow, this.copier.deepCopy(nodeArray[0]), this.copier.deepCopy(nodeArray[1])), this.copier.getNodeFactory().buildFunctionNode("ln", this.funTab.getFunction("ln"), this.copier.deepCopy(nodeArray[0]))), nodeArray2[1]));
    }

    public Object getEvalue() {
        return this.eValue;
    }

    public void setEvalue(Object object) {
        this.eValue = object;
    }
}

