/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MObjStore;
import com.singularsys.extensions.fastmatrix.MatObj;
import com.singularsys.extensions.fastmatrix.MrpEval;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.jep.Variable;
import java.util.ArrayList;
import java.util.List;

final class MatStore
extends MObjStore {
    private static final long serialVersionUID = 350L;
    MatObj[] stack;
    List<MatObj> heap = new ArrayList<MatObj>();
    MatObj[] vars = new MatObj[0];
    MatObj[] cnst = new MatObj[0];

    MatStore(MrpEval mrpEval) {
        super(mrpEval);
    }

    @Override
    final void copyFromJepVar(int n, Variable variable) {
        this.setVarValue(n, (MatrixI)variable.getValue());
    }

    @Override
    final void alloc() {
        this.stack = new MatObj[this.stackMax];
    }

    @Override
    final int expandVarArray(Dimensions dimensions) {
        MatObj[] matObjArray = new MatObj[this.vars.length + 1];
        System.arraycopy(this.vars, 0, matObjArray, 0, this.vars.length);
        matObjArray[this.vars.length] = new MatObj(dimensions.getFirstDim(), dimensions.getLastDim());
        this.vars = matObjArray;
        return this.vars.length - 1;
    }

    @Override
    void cleanUp() {
        this.jepVarIndex.clear();
        this.vars = new MatObj[0];
        this.cnst = new MatObj[0];
        this.stackMax = 0;
        this.heapMax = 0;
        this.heap.clear();
        this.stack = null;
    }

    final void add(short s) {
        MatObj matObj = this.stack[--this.sp];
        MatObj matObj2 = this.stack[--this.sp];
        MatObj matObj3 = this.heap.get(s);
        for (int i = 0; i < matObj2.len; ++i) {
            matObj3.data[i] = matObj2.data[i] + matObj.data[i];
        }
        this.stack[this.sp++] = matObj3;
    }

    final void sub(short s) {
        MatObj matObj = this.stack[--this.sp];
        MatObj matObj2 = this.stack[--this.sp];
        MatObj matObj3 = this.heap.get(s);
        for (int i = 0; i < matObj2.len; ++i) {
            matObj3.data[i] = matObj2.data[i] - matObj.data[i];
        }
        this.stack[this.sp++] = matObj3;
    }

    final void neg(short s) {
        MatObj matObj = this.stack[--this.sp];
        MatObj matObj2 = this.heap.get(s);
        for (int i = 0; i < matObj.len; ++i) {
            matObj2.data[i] = -matObj.data[i];
        }
        this.stack[this.sp++] = matObj2;
    }

    final void mulS(short s) {
        MatObj matObj = this.stack[--this.sp];
        double d = this.scalerStore.popDouble();
        MatObj matObj2 = this.heap.get(s);
        for (int i = 0; i < matObj.len; ++i) {
            matObj2.data[i] = d * matObj.data[i];
        }
        this.stack[this.sp++] = matObj2;
    }

    final void divS(short s) {
        MatObj matObj = this.stack[--this.sp];
        double d = this.scalerStore.popDouble();
        MatObj matObj2 = this.heap.get(s);
        for (int i = 0; i < matObj.len; ++i) {
            matObj2.data[i] = matObj.data[i] / d;
        }
        this.stack[this.sp++] = matObj2;
    }

    @Override
    final void assign(int n) {
        MatObj matObj = this.stack[this.sp - 1];
        MatObj matObj2 = this.vars[n];
        for (int i = 0; i < matObj.len; ++i) {
            matObj2.data[i] = matObj.data[i];
        }
    }

    @Override
    final void eq() {
        MatObj matObj = this.stack[--this.sp];
        MatObj matObj2 = this.stack[--this.sp];
        for (int i = 0; i < matObj.len; ++i) {
            if (matObj2.data[i] == matObj.data[i]) continue;
            this.scalerStore.pushDouble(0.0);
            return;
        }
        this.scalerStore.pushDouble(1.0);
    }

    @Override
    final void ne() {
        MatObj matObj = this.stack[--this.sp];
        MatObj matObj2 = this.stack[--this.sp];
        for (int i = 0; i < matObj.len; ++i) {
            if (matObj2.data[i] == matObj.data[i]) continue;
            this.scalerStore.pushDouble(1.0);
            return;
        }
        this.scalerStore.pushDouble(0.0);
    }

    @Override
    final MatObj getVarValue(int n) {
        return this.vars[n];
    }

    @Override
    final int getNVars() {
        return this.vars.length;
    }

    final void setVarValue(int n, MatrixI matrixI) {
        this.vars[n].fromMat(matrixI);
    }

    @Override
    void removeVarAt(int n) {
        this.vars[n] = null;
    }

    @Override
    void modifyVarDim(int n, Dimensions dimensions) {
        this.vars[n] = new MatObj(dimensions.getFirstDim(), dimensions.getLastDim());
    }

    @Override
    final void pushVariable(int n) {
        this.stack[this.sp++] = this.vars[n];
    }

    final short addConstant(MatrixI matrixI) {
        int n = matrixI.getNRows();
        int n2 = matrixI.getNCols();
        MatObj matObj = new MatObj(n, n2);
        matObj.fromMat(matrixI);
        int n3 = this.cnst.length;
        MatObj[] matObjArray = new MatObj[n3 + 1];
        System.arraycopy(this.cnst, 0, matObjArray, 0, n3);
        matObjArray[n3] = matObj;
        this.cnst = matObjArray;
        return (short)n3;
    }

    @Override
    final void pushConstant(int n) {
        this.stack[this.sp++] = this.cnst[n];
    }

    final MatObj popMatObj() {
        return this.stack[--this.sp];
    }

    final MatObj nextMatObj() {
        throw new UnsupportedOperationException("nextMatObj is not defined for MnnStore and should not b called");
    }

    final void pushMatObj(MatObj matObj) {
        this.stack[this.sp++] = matObj;
    }

    @Override
    protected final void incHeap() {
        throw new IllegalStateException("incHeap should be called with a specied length");
    }

    final short incHeap(int n, int n2) {
        ++this.heapMax;
        MatObj matObj = new MatObj(n, n2);
        this.heap.add(matObj);
        return (short)(this.heap.size() - 1);
    }

    final MatObj getHeapObj(short s) {
        return this.heap.get(s);
    }

    @Override
    final Dimensions getStoreDimensions() {
        return Dimensions.valueOf(10, 10);
    }
}

