/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastreal;

import com.singularsys.extensions.fastreal.RpCommandList;
import com.singularsys.extensions.fastreal.RpEval;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.parser.Node;

public class RpEvaluator
implements Evaluator {
    private static final long serialVersionUID = 330L;
    RpEval rpe;
    boolean updateJepVariables;

    public RpEvaluator(boolean bl) {
        this.updateJepVariables = bl;
    }

    @Override
    public Object eval(Node node) throws EvaluationException {
        RpCommandList rpCommandList = (RpCommandList)node.getHook(RpeKey.RPE);
        if (rpCommandList == null) {
            try {
                rpCommandList = this.rpe.compile(node);
                node.setHook(RpeKey.RPE, rpCommandList);
            }
            catch (EvaluationException evaluationException) {
                throw evaluationException;
            }
            catch (JepException jepException) {
                throw new EvaluationException(jepException);
            }
        }
        Double d = this.rpe.evaluate(rpCommandList);
        return d;
    }

    @Override
    public Object evaluate(Node node) throws EvaluationException {
        Object object = this.eval(node);
        if (this.updateJepVariables) {
            this.rpe.updateJepVariables();
        }
        return object;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        RpEvaluator rpEvaluator = new RpEvaluator(this.updateJepVariables);
        rpEvaluator.rpe = this.rpe.duplicate();
        return rpEvaluator;
    }

    @Override
    public void init(Jep jep) {
        if (this.rpe != null) {
            this.rpe.cleanUp();
        }
        this.rpe = new RpEval(jep);
    }

    public RpEval getRpe() {
        return this.rpe;
    }

    public void updateJepVariables() {
        this.rpe.updateJepVariables();
    }

    static enum RpeKey implements Node.HookKey
    {
        RPE;

    }
}

