/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastreal;

import com.singularsys.extensions.fastreal.ObjStore;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import java.util.Map;
import java.util.Stack;

final class ScalerStore
extends ObjStore {
    private static final long serialVersionUID = 330L;
    private double[] stack = new double[0];
    private double[] vars = new double[0];
    private double[] constVals = new double[0];

    ScalerStore() {
    }

    @Override
    public void reset() {
        this.sp = -1;
    }

    @Override
    public void decStack() throws ParseException {
        --this.sp;
        if (this.sp < -1) {
            throw new ParseException("RPEval: stack error");
        }
    }

    @Override
    public final void alloc() {
        this.stack = new double[this.stackMax + 1];
    }

    @Override
    public final void expandVarArray(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.vars, 0, dArray, 0, this.vars.length);
        this.vars = dArray;
    }

    @Override
    public void updateJepVariables() {
        int n = this.jepVarIndex.length;
        for (int i = 0; i < n; ++i) {
            Variable variable = this.jepVarIndex[i];
            Object object = variable.getValue();
            double d = this.vars[i];
            if (object != null && object instanceof Number && ((Number)object).doubleValue() == d) continue;
            variable.setValue(d, this);
        }
    }

    @Override
    public final void copyFromVar(int n, Variable variable) throws JepException {
        if (variable.hasValidValue()) {
            Object object = variable.getValue();
            if (object instanceof Number) {
                this.vars[n] = ((Number)object).doubleValue();
            } else {
                throw new JepException("Variable value cannot be converted to a double " + object);
            }
        }
    }

    public final void pushDouble(double d) {
        this.stack[++this.sp] = d;
    }

    @Override
    public void pushObject(Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new EvaluationException("Result must be a Double " + object);
        }
        this.stack[++this.sp] = ((Number)object).doubleValue();
    }

    @Override
    public final Object popObject() {
        return this.stack[this.sp--];
    }

    public final double popDouble() {
        return this.stack[this.sp--];
    }

    @Override
    public final void pushVariable(int n) {
        this.stack[++this.sp] = this.vars[n];
    }

    @Override
    public final void pushConstant(int n) {
        this.stack[++this.sp] = this.constVals[n];
    }

    @Override
    public final void add() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] + d;
    }

    @Override
    public final void sub() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] - d;
    }

    @Override
    public final void neg() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = -d;
    }

    @Override
    public final void recroprical() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = 1.0 / d;
    }

    @Override
    public final void mul() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] * d;
    }

    @Override
    public final void div() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] / d;
    }

    @Override
    public final void mod() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] % d;
    }

    @Override
    public final void pow() {
        double d;
        short s = (short)d;
        if ((d = this.stack[this.sp--]) == (double)s) {
            if (d >= 0.0) {
                this.powN(s);
                return;
            }
            this.powN(-s);
            this.recroprical();
            return;
        }
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = Math.pow(d2, d);
    }

    @Override
    public final void powN(short s) {
        double d = this.stack[this.sp];
        switch (s) {
            case 0: {
                d = 1.0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                d *= d;
                break;
            }
            case 3: {
                d *= d * d;
                break;
            }
            case 4: {
                double d2 = d * d;
                d = d2 * d2;
                break;
            }
            case 5: {
                double d3 = d * d;
                d *= d3 * d3;
                break;
            }
            case 6: {
                double d4 = d * d;
                double d5 = d4 * d4;
                d = d4 * d5;
                break;
            }
            case 7: {
                double d6 = d * d;
                double d7 = d6 * d6;
                d *= d6 * d7;
                break;
            }
            case 8: {
                double d8 = d * d;
                double d9 = d8 * d8;
                d = d9 * d9;
                break;
            }
            default: {
                short s2 = s;
                double d10 = d;
                double d11 = (s2 & 1) != 0 ? d : 1.0;
                for (s2 = (short)(s2 >>> 1); s2 != 0; s2 = (short)(s2 >>> 1)) {
                    d10 *= d10;
                    if ((s2 & 1) == 0) continue;
                    d11 *= d10;
                }
                d = d11;
            }
        }
        this.stack[this.sp] = d;
    }

    @Override
    public final void assign(int n) {
        this.vars[n] = this.stack[this.sp];
    }

    @Override
    public final void and() {
        double d = this.stack[this.sp--];
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != 0.0 && d != 0.0 ? 1.0 : 0.0;
    }

    @Override
    public final void or() {
        double d = this.stack[this.sp--];
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != 0.0 || d != 0.0 ? 1.0 : 0.0;
    }

    @Override
    public final void not() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = d == 0.0 ? 1.0 : 0.0;
    }

    @Override
    public final void lt() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 < (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public final void gt() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 > (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public final void le() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 <= (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public final void ge() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 >= (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public final void eq() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 == (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public final void ne() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    public ScalerStore duplicate() {
        ScalerStore scalerStore = new ScalerStore();
        scalerStore.sp = this.sp;
        scalerStore.stackMax = this.stackMax;
        for (Map.Entry entry : this.varRefs.entrySet()) {
            scalerStore.varRefs.put(entry.getKey(), entry.getValue());
            ((Variable)entry.getKey()).addObserver(scalerStore);
        }
        scalerStore.stack = (double[])this.stack.clone();
        scalerStore.vars = (double[])this.vars.clone();
        scalerStore.constVals = (double[])this.constVals.clone();
        return scalerStore;
    }

    @Override
    public short addConstant(Object object) throws ParseException {
        if (!(object instanceof Double)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double d = (Double)object;
        for (short s = 0; s < this.constVals.length; s = (short)(s + 1)) {
            if (d != this.constVals[s]) continue;
            return s;
        }
        double[] dArray = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, dArray, 0, this.constVals.length);
        dArray[this.constVals.length] = d;
        this.constVals = dArray;
        return (short)(this.constVals.length - 1);
    }

    @Override
    public Object getConstant(int n) {
        return this.constVals[n];
    }

    public void setVarValue(int n, double d) {
        this.vars[n] = d;
    }

    @Override
    public Double getVarValue(int n) {
        return this.vars[n];
    }

    @Override
    public void popN(int n, Stack<Object> stack) {
        this.sp -= n;
        for (int i = 1; i <= n; ++i) {
            stack.push(this.stack[this.sp + i]);
        }
    }

    @Override
    public int getNConst() {
        return this.constVals.length;
    }

    @Override
    public int getNVars() {
        return this.vars.length;
    }
}

