/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.LazyLogical;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.StandardOperatorTable2;

public class FieldOperatorTable
extends StandardOperatorTable2 {
    private static final long serialVersionUID = 303L;
    final NaryBinaryFunction addFunction = new AddFunction();
    final BinaryFunction subFunction = new SubFunction();
    final UnaryFunction negFunction = new NegFunction();
    final NaryBinaryFunction mulFunction = new MulFunction();
    final BinaryFunction divFunction = new DivFunction();
    final BinaryFunction modFunction = new ModFunction();
    final BinaryFunction powFunction = new PowFunction();
    final BinaryFunction eqFunction = new EqFunction();
    final BinaryFunction neFunction = new NeFunction();
    final BinaryFunction gtFunction = new GTFunction();
    final BinaryFunction ltFunction = new LtFunction();
    final BinaryFunction geFunction = new GeFunction();
    final BinaryFunction leFunction = new LeFunction();
    final LazyLogical andFunction = new AndFunction();
    final LazyLogical orFunction = new OrFunction();
    final UnaryFunction notFunction = new NotFunction();
    protected FieldI field;

    public FieldOperatorTable(FieldI fieldI) {
        this.field = fieldI;
        this.setBasicPfmcs();
        super.setPsudoPfmcs();
    }

    public FieldOperatorTable(OperatorTable2 operatorTable2, FieldI fieldI) {
        super(operatorTable2);
        this.field = fieldI;
        this.setBasicPfmcs();
    }

    @Override
    protected void setSpecialPfmcs() {
    }

    @Override
    protected void setPsudoPfmcs() {
    }

    @Override
    protected void setBasicPfmcs() {
        this.getOperator(OperatorTable2.BasicOperators.ADD).setPFMC(this.getAddFunction());
        this.getOperator(OperatorTable2.BasicOperators.SUB).setPFMC(this.getSubFunction());
        this.getOperator(OperatorTable2.BasicOperators.NEG).setPFMC(this.getNegFunction());
        this.getOperator(OperatorTable2.BasicOperators.MUL).setPFMC(this.getMulFunction());
        this.getOperator(OperatorTable2.BasicOperators.DIV).setPFMC(this.getDivFunction());
        this.getOperator(OperatorTable2.BasicOperators.MOD).setPFMC(this.getModFunction());
        this.getOperator(OperatorTable2.BasicOperators.POW).setPFMC(this.getPowFunction());
        this.getOperator(OperatorTable2.BasicOperators.GT).setPFMC(this.getGtFunction());
        this.getOperator(OperatorTable2.BasicOperators.LT).setPFMC(this.getLtFunction());
        this.getOperator(OperatorTable2.BasicOperators.EQ).setPFMC(this.getEqFunction());
        this.getOperator(OperatorTable2.BasicOperators.LE).setPFMC(this.getLeFunction());
        this.getOperator(OperatorTable2.BasicOperators.GE).setPFMC(this.getGeFunction());
        this.getOperator(OperatorTable2.BasicOperators.NE).setPFMC(this.getNeFunction());
        this.getOperator(OperatorTable2.BasicOperators.AND).setPFMC(this.getAndFunction());
        this.getOperator(OperatorTable2.BasicOperators.OR).setPFMC(this.getOrFunction());
        this.getOperator(OperatorTable2.BasicOperators.NOT).setPFMC(this.getNotFunction());
    }

    public FieldI getField() {
        return this.field;
    }

    public NaryBinaryFunction getAddFunction() {
        return this.addFunction;
    }

    public BinaryFunction getSubFunction() {
        return this.subFunction;
    }

    public UnaryFunction getNegFunction() {
        return this.negFunction;
    }

    public NaryBinaryFunction getMulFunction() {
        NaryBinaryFunction naryBinaryFunction = this.mulFunction;
        return naryBinaryFunction;
    }

    public BinaryFunction getDivFunction() {
        return this.divFunction;
    }

    public BinaryFunction getModFunction() {
        return this.modFunction;
    }

    public BinaryFunction getPowFunction() {
        return this.powFunction;
    }

    public BinaryFunction getEqFunction() {
        return this.eqFunction;
    }

    public BinaryFunction getNeFunction() {
        return this.neFunction;
    }

    public BinaryFunction getGtFunction() {
        return this.gtFunction;
    }

    public BinaryFunction getLtFunction() {
        return this.ltFunction;
    }

    public BinaryFunction getGeFunction() {
        return this.geFunction;
    }

    public BinaryFunction getLeFunction() {
        return this.leFunction;
    }

    public LazyLogical getAndFunction() {
        return this.andFunction;
    }

    public LazyLogical getOrFunction() {
        return this.orFunction;
    }

    public UnaryFunction getNotFunction() {
        return this.notFunction;
    }

    private final class NotFunction
    extends UnaryFunction {
        private static final long serialVersionUID = 330L;

        private NotFunction() {
        }

        @Override
        public Object eval(Object object) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.not(object);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
        }
    }

    private final class OrFunction
    extends LazyLogical {
        private static final long serialVersionUID = 330L;

        public OrFunction() {
            super(1);
        }

        @Override
        public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
            Object object = evaluator.eval(node.jjtGetChild(0));
            if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                return object;
            }
            Object object2 = evaluator.eval(node.jjtGetChild(1));
            if (object2 == null) {
                return null;
            }
            return FieldOperatorTable.this.field.or(object, object2);
        }
    }

    private final class AndFunction
    extends LazyLogical {
        private static final long serialVersionUID = 330L;

        public AndFunction() {
            super(0);
        }

        @Override
        public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
            Object object = evaluator.eval(node.jjtGetChild(0));
            if (object != null && object instanceof Boolean && !((Boolean)object).booleanValue()) {
                return object;
            }
            Object object2 = evaluator.eval(node.jjtGetChild(1));
            if (object2 == null) {
                return null;
            }
            return FieldOperatorTable.this.field.and(object, object2);
        }
    }

    private final class EqFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private EqFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.eq(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class NeFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private NeFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.ne(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class GTFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private GTFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.gt(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class LtFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private LtFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.lt(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class GeFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private GeFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.ge(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class LeFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private LeFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Boolean bl = FieldOperatorTable.this.field.le(object, object2);
            if (bl != null) {
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class PowFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private PowFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.pow(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class ModFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private ModFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.mod(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class DivFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private DivFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.div(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class MulFunction
    extends NaryBinaryFunction {
        private static final long serialVersionUID = 330L;

        private MulFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.mul(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class NegFunction
    extends UnaryFunction {
        private static final long serialVersionUID = 330L;

        private NegFunction() {
        }

        @Override
        public Object eval(Object object) throws EvaluationException {
            Object object2 = FieldOperatorTable.this.field.neg(object);
            if (object2 != null) {
                return object2;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
        }
    }

    private final class SubFunction
    extends BinaryFunction {
        private static final long serialVersionUID = 330L;

        private SubFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.sub(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }

    private final class AddFunction
    extends NaryBinaryFunction {
        private static final long serialVersionUID = 330L;

        private AddFunction() {
        }

        @Override
        public Object eval(Object object, Object object2) throws EvaluationException {
            Object object3 = FieldOperatorTable.this.field.add(object, object2);
            if (object3 != null) {
                return object3;
            }
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
    }
}

