/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.functions;

import com.singularsys.extensions.field.implementations.Rational;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.UnaryFunction;
import java.math.BigInteger;
import java.math.RoundingMode;

public class RationalRound
extends UnaryFunction {
    private static final long serialVersionUID = 350L;
    RoundingMode mode;

    public RationalRound(RoundingMode roundingMode) {
        this.mode = roundingMode;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        Rational rational = (Rational)object;
        if (rational.equals(Rational.ZERO)) {
            return rational;
        }
        if (rational.getDenominator().equals(BigInteger.ONE)) {
            return rational;
        }
        BigInteger[] bigIntegerArray = rational.getNumerator().divideAndRemainder(rational.getDenominator());
        boolean bl = rational.getNumerator().signum() > 0;
        switch (this.mode) {
            case CEILING: {
                return bl ? new Rational(bigIntegerArray[0].add(BigInteger.ONE)) : new Rational(bigIntegerArray[0]);
            }
            case DOWN: {
                return new Rational(bigIntegerArray[0]);
            }
            case FLOOR: {
                return bl ? new Rational(bigIntegerArray[0]) : new Rational(bigIntegerArray[0].subtract(BigInteger.ONE));
            }
            case UP: {
                return bl ? new Rational(bigIntegerArray[0].add(BigInteger.ONE)) : new Rational(bigIntegerArray[0].subtract(BigInteger.ONE));
            }
        }
        if (!bl) {
            bigIntegerArray[0] = bigIntegerArray[0].subtract(BigInteger.ONE);
            bigIntegerArray[1] = bigIntegerArray[1].add(rational.getDenominator());
        }
        BigInteger bigInteger = bigIntegerArray[1].shiftLeft(1);
        int n = bigInteger.compareTo(rational.getDenominator());
        switch (this.mode) {
            case HALF_DOWN: {
                return n < 0 || n == 0 && bl ? new Rational(bigIntegerArray[0]) : new Rational(bigIntegerArray[0].add(BigInteger.ONE));
            }
            case HALF_UP: {
                return n < 0 || n == 0 && !bl ? new Rational(bigIntegerArray[0]) : new Rational(bigIntegerArray[0].add(BigInteger.ONE));
            }
            case HALF_EVEN: {
                boolean bl2 = bigIntegerArray[0].testBit(0);
                return n < 0 || n == 0 && !bl2 ? new Rational(bigIntegerArray[0]) : new Rational(bigIntegerArray[0].add(BigInteger.ONE));
            }
            case UNNECESSARY: {
                throw new ArithmeticException("Attempt to round non integer with mode UNNECESSARY");
            }
        }
        return null;
    }
}

