/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.jep.EvaluationException;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalField
extends GenericField<BigDecimal> {
    private static final long serialVersionUID = 330L;
    MathContext mc;

    public BigDecimalField(MathContext mathContext) {
        this.mc = mathContext;
    }

    @Override
    public BigDecimal cast(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return null;
    }

    @Override
    public BigDecimal addG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        try {
            return bigDecimal.add(bigDecimal2, this.mc);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public BigDecimal subG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        try {
            return bigDecimal.subtract(bigDecimal2, this.mc);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public BigDecimal negG(BigDecimal bigDecimal) throws EvaluationException {
        return bigDecimal.negate();
    }

    @Override
    public BigDecimal mulG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        try {
            return bigDecimal.multiply(bigDecimal2, this.mc);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public BigDecimal divG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        try {
            return bigDecimal.divide(bigDecimal2, this.mc);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public BigDecimal modG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        return null;
    }

    @Override
    public BigDecimal powG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        try {
            int n = bigDecimal2.intValueExact();
            return bigDecimal.pow(n, this.mc);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException("power: only integer powers allowed, found " + bigDecimal2);
        }
    }

    @Override
    public Integer cmpG(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        return bigDecimal.compareTo(bigDecimal2);
    }

    @Override
    public BigDecimal getOne() {
        return BigDecimal.ONE;
    }

    @Override
    public BigDecimal getZero() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal convertFromInt(Integer n) throws EvaluationException {
        return BigDecimal.valueOf(n.intValue());
    }

    @Override
    public Integer convertToIntE(BigDecimal bigDecimal) throws EvaluationException {
        try {
            int n = bigDecimal.intValueExact();
            return n;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }
}

