/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.jep.EvaluationException;
import java.math.BigInteger;

public class BigIntegerField
extends GenericField<BigInteger> {
    private static final long serialVersionUID = 330L;

    @Override
    public BigInteger cast(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        return null;
    }

    @Override
    public BigInteger addG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.add(bigInteger2);
    }

    @Override
    public BigInteger subG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.subtract(bigInteger2);
    }

    @Override
    public BigInteger negG(BigInteger bigInteger) throws EvaluationException {
        return bigInteger.negate();
    }

    @Override
    public BigInteger modG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.mod(bigInteger2);
    }

    @Override
    public BigInteger mulG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.multiply(bigInteger2);
    }

    @Override
    public BigInteger divG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.divide(bigInteger2);
    }

    @Override
    public BigInteger powG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        long l = bigInteger2.longValue();
        int n = (int)l;
        if ((long)n != l) {
            throw new EvaluationException("BigInt, power, exponent too large " + n);
        }
        if (n < 0) {
            throw new EvaluationException("BigInt, power, exponent too large " + n);
        }
        return bigInteger.pow(n);
    }

    @Override
    public Integer cmpG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.compareTo(bigInteger2);
    }

    @Override
    public BigInteger getOne() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger getZero() {
        return BigInteger.ZERO;
    }

    @Override
    public Integer convertToIntE(BigInteger bigInteger) throws EvaluationException {
        try {
            int n = bigInteger.intValueExact();
            return n;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    @Override
    public BigInteger convertFromInt(Integer n) throws EvaluationException {
        return BigInteger.valueOf(n.intValue());
    }
}

