/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;
import java.math.BigInteger;

public class BigIntegerNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 350L;
    private BigInteger MINUSONE = BigInteger.valueOf(-1L);
    private BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    @Override
    public Object createNumber(String string) throws ParseException {
        if (string.equals("0")) {
            return BigInteger.ZERO;
        }
        if (string.equals("1")) {
            return BigInteger.ONE;
        }
        if (string.equals("-1")) {
            return this.MINUSONE;
        }
        if (string.equals("2")) {
            return this.TWO;
        }
        return new BigInteger(string);
    }

    @Override
    public Object createNumber(double d) throws ParseException {
        return BigInteger.valueOf(((Number)d).longValue());
    }

    @Override
    public Object createNumber(int n) throws ParseException {
        return BigInteger.valueOf(n);
    }

    @Override
    public Object createNumber(short s) throws ParseException {
        return BigInteger.valueOf(s);
    }

    @Override
    public Object createNumber(long l) throws ParseException {
        return BigInteger.valueOf(l);
    }

    @Override
    public Object createNumber(float f) throws ParseException {
        return BigInteger.valueOf(((Number)Float.valueOf(f)).longValue());
    }

    @Override
    public Object createNumber(boolean bl) throws ParseException {
        return bl ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public Object createNumber(Number number) throws ParseException {
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public Object createNumber(Complex complex) throws ParseException {
        if (complex.im() == 0.0) {
            return this.createNumber(complex.re());
        }
        throw new ParseException("Cannot convert a complex number " + complex + " to a BigInteger");
    }

    @Override
    public Object getZero() {
        return BigInteger.ZERO;
    }

    @Override
    public Object getOne() {
        return BigInteger.ONE;
    }

    @Override
    public Object getMinusOne() {
        return this.MINUSONE;
    }

    @Override
    public Object getTwo() {
        return this.TWO;
    }
}

