/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.extensions.field.implementations.PowerImplementations;
import com.singularsys.jep.EvaluationException;

public final class IntegerField
extends GenericField<Integer> {
    private static final long serialVersionUID = 330L;

    @Override
    public Integer cast(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return null;
    }

    @Override
    public Integer addG(Integer n, Integer n2) throws EvaluationException {
        return n + n2;
    }

    @Override
    public Integer subG(Integer n, Integer n2) throws EvaluationException {
        return n - n2;
    }

    @Override
    public Integer negG(Integer n) throws EvaluationException {
        return -n.intValue();
    }

    @Override
    public Integer mulG(Integer n, Integer n2) throws EvaluationException {
        return n * n2;
    }

    @Override
    public Integer modG(Integer n, Integer n2) throws EvaluationException {
        return n % n2;
    }

    @Override
    public Integer divG(Integer n, Integer n2) throws EvaluationException {
        return n / n2;
    }

    @Override
    public Integer powG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n;
        int n4 = n2;
        if (n4 == 0) {
            return 1;
        }
        if (n4 == 1) {
            return n;
        }
        if (n3 == 0 && n4 > 0) {
            return 0;
        }
        if (n3 == 0 && n4 < 0) {
            throw new EvaluationException(new ArithmeticException("Pow: Overflow: " + n3 + "^" + n4));
        }
        if (n3 == 1) {
            return 1;
        }
        if (n3 == -1) {
            boolean bl = (n4 & 1) == 0;
            return bl ? 1 : -1;
        }
        if (n4 < 0) {
            return 0;
        }
        int n5 = PowerImplementations.intpower(n3, n4);
        return n5;
    }

    @Override
    public Integer cmpG(Integer n, Integer n2) throws EvaluationException {
        return n.compareTo(n2);
    }

    @Override
    public Integer getOne() {
        return 1;
    }

    @Override
    public Integer getZero() {
        return 0;
    }

    @Override
    public Integer convertToIntE(Integer n) throws EvaluationException {
        return n;
    }

    @Override
    public Integer convertFromInt(Integer n) throws EvaluationException {
        return n;
    }
}

