/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.implementations.FieldDecorator;
import com.singularsys.jep.EvaluationException;
import java.math.BigInteger;

public class IntegerToBigIntegerDecorator
extends FieldDecorator {
    private static final long serialVersionUID = 330L;
    boolean simplifyResults = false;

    public IntegerToBigIntegerDecorator(FieldI fieldI) {
        super(fieldI);
    }

    public IntegerToBigIntegerDecorator(FieldI fieldI, boolean bl) {
        super(fieldI);
        this.simplifyResults = bl;
    }

    @Override
    public Object convertInput(Object object) throws EvaluationException {
        if (object instanceof Integer) {
            return BigInteger.valueOf(((Integer)object).intValue());
        }
        if (object instanceof Short) {
            return BigInteger.valueOf(((Short)object).shortValue());
        }
        if (object instanceof Long) {
            return BigInteger.valueOf((Long)object);
        }
        return object;
    }

    @Override
    public Object convertOutput(Object object) throws EvaluationException {
        int n;
        BigInteger bigInteger;
        if (this.simplifyResults && object instanceof BigInteger && (bigInteger = (BigInteger)object).equals(BigInteger.valueOf(n = bigInteger.intValue()))) {
            return n;
        }
        return object;
    }
}

