/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import java.math.BigInteger;

public class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 330L;
    final BigInteger numerator;
    final BigInteger denominator;
    public static final Rational ZERO = new Rational();
    public static final Rational ONE = new Rational(1);
    public static final Rational TWO = new Rational(2);
    public static final Rational MINUSONE = new Rational(-1);
    public static final Rational HALF = new Rational(1, 2);

    public Rational() {
        this.numerator = BigInteger.ZERO;
        this.denominator = BigInteger.ONE;
    }

    public Rational(int n, int n2) {
        if (n2 == 0) {
            throw new ArithmeticException("Rational: Division by zero " + n + "/0");
        }
        if (n > 0 && n2 > 0) {
            int n3 = Rational.gcd(n, n2);
            this.numerator = BigInteger.valueOf(n / n3);
            this.denominator = BigInteger.valueOf(n2 / n3);
        } else if (n > 0 && n2 < 0) {
            int n4 = Rational.gcd(n, -n2);
            this.numerator = BigInteger.valueOf(-n / n4);
            this.denominator = BigInteger.valueOf(-n2 / n4);
        } else if (n < 0 && n2 > 0) {
            int n5 = Rational.gcd(-n, n2);
            this.numerator = BigInteger.valueOf(n / n5);
            this.denominator = BigInteger.valueOf(n2 / n5);
        } else if (n < 0 && n2 < 0) {
            int n6 = Rational.gcd(-n, -n2);
            this.numerator = BigInteger.valueOf(-n / n6);
            this.denominator = BigInteger.valueOf(-n2 / n6);
        } else {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
        }
    }

    public Rational(int n) {
        this.numerator = BigInteger.valueOf(n);
        this.denominator = BigInteger.ONE;
    }

    public Rational(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        int n = bigInteger2.signum();
        int n2 = bigInteger.signum();
        if (n == 0) {
            throw new ArithmeticException("Rational: Division by zero " + bigInteger.toString() + "/0");
        }
        if (n2 > 0 && n > 0) {
            this.numerator = bigInteger.divide(bigInteger3);
            this.denominator = bigInteger2.divide(bigInteger3);
        } else if (n2 > 0 && n < 0) {
            this.numerator = bigInteger.negate().divide(bigInteger3);
            this.denominator = bigInteger2.negate().divide(bigInteger3);
        } else if (n2 < 0 && n > 0) {
            this.numerator = bigInteger.divide(bigInteger3);
            this.denominator = bigInteger2.divide(bigInteger3);
        } else if (n2 < 0 && n < 0) {
            this.numerator = bigInteger.negate().divide(bigInteger3);
            this.denominator = bigInteger2.negate().divide(bigInteger3);
        } else {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
        }
    }

    public Rational(long l) {
        this.numerator = BigInteger.valueOf(l);
        this.denominator = BigInteger.ONE;
    }

    public Rational(BigInteger bigInteger) {
        this.numerator = bigInteger;
        this.denominator = BigInteger.ONE;
    }

    static int gcd(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n4 != 0) {
            int n5 = n4;
            n4 = n3 % n4;
            n3 = n5;
        }
        return n3;
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public boolean equals(Object object) {
        if (object instanceof Rational) {
            Rational rational = (Rational)object;
            return this.numerator.equals(rational.numerator) && this.denominator.equals(rational.denominator);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.numerator.hashCode();
        n = 37 * n + this.denominator.hashCode();
        return n;
    }

    public String toString() {
        if (this.denominator.equals(BigInteger.ONE)) {
            return this.numerator.toString();
        }
        return this.numerator.toString() + "/" + this.denominator.toString();
    }

    public Rational add(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = rational.numerator.multiply(this.denominator);
        return new Rational(bigInteger.add(bigInteger2), this.denominator.multiply(rational.denominator));
    }

    public Rational sub(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = rational.numerator.multiply(this.denominator);
        return new Rational(bigInteger.subtract(bigInteger2), this.denominator.multiply(rational.denominator));
    }

    public Rational mul(Rational rational) {
        return new Rational(this.numerator.multiply(rational.numerator), this.denominator.multiply(rational.denominator));
    }

    public Rational div(Rational rational) {
        return new Rational(this.numerator.multiply(rational.denominator), this.denominator.multiply(rational.numerator));
    }

    public Rational neg() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    @Override
    public int compareTo(Rational rational) {
        if (this.denominator.equals(rational.denominator)) {
            return this.numerator.compareTo(rational.numerator);
        }
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.numerator);
        return bigInteger.compareTo(bigInteger2);
    }

    public static Rational valueOf(int n) {
        switch (n) {
            case -1: {
                return MINUSONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
        }
        return new Rational(n);
    }

    public static Rational valueOf(long l) {
        if (l == -1L) {
            return MINUSONE;
        }
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return ONE;
        }
        if (l == 2L) {
            return TWO;
        }
        return new Rational(l);
    }

    public static Rational valueOf(int n, int n2) {
        return new Rational(n, n2);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        double d = this.getNumerator().doubleValue() / this.getDenominator().doubleValue();
        return d;
    }
}

