/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.builder;

import com.singularsys.extensions.mathml.builder.ApplyConstructor;
import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.jep.JepException;
import com.singularsys.jep.parser.Node;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class FunctionBuilder
extends ApplyConstructor
implements MathMLFragmentBuilder {
    protected MathMLFragmentBuilder unknownFunctionBuilder = new ErrorBuilder();
    protected Map<String, String> functions = new HashMap<String, String>();
    protected Map<String, MathMLFragmentBuilder> specialFunctions = new HashMap<String, MathMLFragmentBuilder>();

    @Override
    public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
        if (this.functions.containsKey(node.getName())) {
            return this.buildStandardFunction(node, document, mathMLDocumentBuilder);
        }
        if (this.specialFunctions.containsKey(node.getName())) {
            MathMLFragmentBuilder mathMLFragmentBuilder = this.specialFunctions.get(node.getName());
            Element element = mathMLFragmentBuilder.build(node, document, mathMLDocumentBuilder);
            return element;
        }
        return this.unknownFunctionBuilder.build(node, document, mathMLDocumentBuilder);
    }

    protected Element buildStandardFunction(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
        String string = node.getName();
        String string2 = this.functions.get(string);
        Element element = this.buildApplyElement(string2, node, document, mathMLDocumentBuilder);
        return element;
    }

    public String putFunction(String string, String string2) {
        return this.functions.put(string, string2);
    }

    public MathMLFragmentBuilder putSpecialFunction(String string, MathMLFragmentBuilder mathMLFragmentBuilder) {
        return this.specialFunctions.put(string, mathMLFragmentBuilder);
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public Map<String, MathMLFragmentBuilder> getSpecialFunctions() {
        return this.specialFunctions;
    }

    public MathMLFragmentBuilder getUnknownFunctionBuilder() {
        return this.unknownFunctionBuilder;
    }

    public void setUnknownFunctionBuilder(MathMLFragmentBuilder mathMLFragmentBuilder) {
        this.unknownFunctionBuilder = mathMLFragmentBuilder;
    }

    public static class ErrorBuilder
    implements MathMLFragmentBuilder {
        @Override
        public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
            throw new JepException("No builder for function " + node.getName());
        }
    }

    public static class FnBuilder
    extends ApplyConstructor
    implements MathMLFragmentBuilder {
        @Override
        public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
            String string = node.getName();
            Element element = mathMLDocumentBuilder.createElement("fn", document);
            Element element2 = mathMLDocumentBuilder.createElement("ci", document);
            Text text = document.createTextNode(string);
            element2.appendChild(text);
            element.appendChild(element2);
            Element element3 = this.buildApplyElement(element, node, document, mathMLDocumentBuilder);
            return element3;
        }
    }

    public static class CSymbolBuilder
    extends ApplyConstructor
    implements MathMLFragmentBuilder {
        @Override
        public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
            String string = node.getName();
            Element element = mathMLDocumentBuilder.createElement("csymbol", document);
            Text text = document.createTextNode(string);
            element.appendChild(text);
            Element element2 = this.buildApplyElement(element, node, document, mathMLDocumentBuilder);
            return element2;
        }
    }
}

