/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.builder;

import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.parser.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListBuilder
implements MathMLFragmentBuilder {
    boolean useMatrixVector = true;
    Operator list = null;

    public ListBuilder(Jep jep) {
        this.list = jep.getOperatorTable().getList();
    }

    protected boolean isMatrix(Node node) {
        if (!this.useMatrixVector) {
            return false;
        }
        int n = -1;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node node2 = node.jjtGetChild(i);
            if (!this.list.equals(node2.getOperator())) {
                return false;
            }
            if (i == 0) {
                n = node2.jjtGetNumChildren();
            } else if (n != node2.jjtGetNumChildren()) {
                return false;
            }
            for (int j = 0; j < node2.jjtGetNumChildren(); ++j) {
                if (!this.list.equals(node2.jjtGetChild(j).getOperator())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isVector(Node node) {
        if (!this.useMatrixVector) {
            return false;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node node2 = node.jjtGetChild(i);
            if (!this.list.equals(node2.getOperator())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
        if (this.isMatrix(node)) {
            Element element = mathMLDocumentBuilder.createElement("matrix", document);
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node node2 = node.jjtGetChild(i);
                Element element2 = mathMLDocumentBuilder.createElement("matrixrow", document);
                for (int j = 0; j < node2.jjtGetNumChildren(); ++j) {
                    Element element3 = mathMLDocumentBuilder.buildChild(node2.jjtGetChild(j), document);
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
            }
            return element;
        }
        if (this.isVector(node)) {
            Element element = mathMLDocumentBuilder.createElement("vector", document);
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node node3 = node.jjtGetChild(i);
                Element element4 = mathMLDocumentBuilder.buildChild(node3, document);
                element.appendChild(element4);
            }
            return element;
        }
        Element element = mathMLDocumentBuilder.createElement("list", document);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Element element5 = mathMLDocumentBuilder.buildChild(node.jjtGetChild(i), document);
            element.appendChild(element5);
        }
        return element;
    }

    public boolean isUseMatrixVector() {
        return this.useMatrixVector;
    }

    public void setUseMatrixVector(boolean bl) {
        this.useMatrixVector = bl;
    }
}

