/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.builder;

import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.jep.JepException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class NumberBuilder
implements MathMLFragmentBuilder {
    DoubleBehaviour doubleBehaviour = DoubleBehaviour.NO_DECIMALPOINT;

    public Element buildAsInteger(long l, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) {
        Element element = mathMLDocumentBuilder.createElement("cn", document);
        mathMLDocumentBuilder.setAttribute(element, "type", "integer");
        Text text = document.createTextNode(Long.toString(l));
        element.appendChild(text);
        return element;
    }

    public Element buildAsDouble(double d, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) {
        if (Double.isNaN(d)) {
            Element element = mathMLDocumentBuilder.createElement("notanumber", document);
            return element;
        }
        if (Double.isInfinite(d) && d > 0.0) {
            Element element = mathMLDocumentBuilder.createElement("infinity", document);
            return element;
        }
        if (Double.isInfinite(d) && d < 0.0) {
            Element element = mathMLDocumentBuilder.createElement("apply", document);
            Element element2 = mathMLDocumentBuilder.createElement("minus", document);
            Element element3 = mathMLDocumentBuilder.createElement("infinity", document);
            element.appendChild(element2);
            element.appendChild(element3);
            return element;
        }
        String string = Double.toString(d);
        int n = string.indexOf(69);
        if (n >= 0) {
            Element element = mathMLDocumentBuilder.createElement("cn", document);
            mathMLDocumentBuilder.setAttribute(element, "type", "e-notation");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Text text = document.createTextNode(string2);
            Element element4 = mathMLDocumentBuilder.createElement("sep", document);
            Text text2 = document.createTextNode(string3);
            element.appendChild(text);
            element.appendChild(element4);
            element.appendChild(text2);
            return element;
        }
        if (this.doubleBehaviour == DoubleBehaviour.NO_DECIMALPOINT && string.endsWith(".0")) {
            Element element = mathMLDocumentBuilder.createElement("cn", document);
            Text text = document.createTextNode(string.substring(0, string.length() - 2));
            element.appendChild(text);
            return element;
        }
        Element element = mathMLDocumentBuilder.createElement("cn", document);
        Text text = document.createTextNode(string);
        element.appendChild(text);
        return element;
    }

    public Element buildAsComplex(Complex complex, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) {
        Element element = mathMLDocumentBuilder.createElement("cn", document);
        mathMLDocumentBuilder.setAttribute(element, "type", "complex-cartesian");
        Text text = document.createTextNode("" + complex.re());
        Element element2 = mathMLDocumentBuilder.createElement("sep", document);
        Text text2 = document.createTextNode("" + complex.im());
        element.appendChild(text);
        element.appendChild(element2);
        element.appendChild(text2);
        return element;
    }

    @Override
    public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
        assert (node instanceof ASTConstant);
        Object object = node.getValue();
        if (this.isInteger(object)) {
            return this.buildAsInteger(((Number)object).longValue(), document, mathMLDocumentBuilder);
        }
        if (object instanceof Complex) {
            return this.buildAsComplex((Complex)object, document, mathMLDocumentBuilder);
        }
        if (object instanceof Number) {
            return this.buildAsDouble(((Number)object).doubleValue(), document, mathMLDocumentBuilder);
        }
        if (object instanceof Boolean) {
            return this.buildAsBoolean((Boolean)object, document, mathMLDocumentBuilder);
        }
        throw new JepException("Cannot convert " + object.toString() + "(" + object.getClass().getSimpleName() + ") to a constant node");
    }

    private Element buildAsBoolean(Boolean bl, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) {
        if (bl.booleanValue()) {
            Element element = mathMLDocumentBuilder.createElement("true", document);
            return element;
        }
        Element element = mathMLDocumentBuilder.createElement("false", document);
        return element;
    }

    protected boolean isInteger(Object object) {
        if (object instanceof Integer || object instanceof Short || object instanceof Long) {
            return true;
        }
        if (this.doubleBehaviour == DoubleBehaviour.TYPE_INTEGER && (object instanceof Double || object instanceof Float)) {
            double d;
            if (object instanceof Double && ((Double)object).isInfinite()) {
                return false;
            }
            if (object instanceof Float && ((Float)object).isInfinite()) {
                return false;
            }
            double d2 = ((Number)object).doubleValue();
            if (d2 == (d = Math.rint(d2))) {
                return true;
            }
        }
        return false;
    }

    public DoubleBehaviour getDoubleBehaviour() {
        return this.doubleBehaviour;
    }

    public void setDoubleBehaviour(DoubleBehaviour doubleBehaviour) {
        this.doubleBehaviour = doubleBehaviour;
    }

    public static enum DoubleBehaviour {
        ALLWAYS_DOUBLE,
        NO_DECIMALPOINT,
        TYPE_INTEGER;

    }
}

