/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.builder;

import com.singularsys.extensions.mathml.builder.ApplyConstructor;
import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperatorBuilder
extends ApplyConstructor
implements MathMLFragmentBuilder {
    Map<Operator, String> operators = new HashMap<Operator, String>();
    Map<Operator, MathMLFragmentBuilder> specialOps = new HashMap<Operator, MathMLFragmentBuilder>();

    @Override
    public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) throws JepException {
        assert (node instanceof ASTOpNode);
        Operator operator = node.getOperator();
        if (this.operators.containsKey(operator)) {
            String string = this.operators.get(operator);
            Element element = this.buildApplyElement(string, node, document, mathMLDocumentBuilder);
            return element;
        }
        if (this.specialOps.containsKey(operator)) {
            MathMLFragmentBuilder mathMLFragmentBuilder = this.specialOps.get(operator);
            Element element = mathMLFragmentBuilder.build(node, document, mathMLDocumentBuilder);
            return element;
        }
        throw new JepException("No builder for operator " + operator.getName());
    }

    public String put(Operator operator, String string) {
        return this.operators.put(operator, string);
    }

    public MathMLFragmentBuilder put(Operator operator, MathMLFragmentBuilder mathMLFragmentBuilder) {
        return this.specialOps.put(operator, mathMLFragmentBuilder);
    }

    public Map<Operator, String> getOperators() {
        return this.operators;
    }

    public Map<Operator, MathMLFragmentBuilder> getSpecialOps() {
        return this.specialOps;
    }
}

