/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.builder;

import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class VariableBuilder
implements MathMLFragmentBuilder {
    Map<String, String> constants = new HashMap<String, String>();
    Map<String, String> entities = new HashMap<String, String>();
    int version = 2;

    @Override
    public Element build(Node node, Document document, MathMLDocumentBuilder mathMLDocumentBuilder) {
        if (this.version == 1) {
            if (this.entities.containsKey(node.getName())) {
                String string = this.entities.get(node.getName());
                Element element = mathMLDocumentBuilder.createElement("cn", document);
                mathMLDocumentBuilder.setAttribute(element, "type", "constant");
                Text text = document.createTextNode(string);
                element.appendChild(text);
                return element;
            }
        } else if (this.version == 2 && this.constants.containsKey(node.getName())) {
            String string = this.constants.get(node.getName());
            Element element = mathMLDocumentBuilder.createElement(string.toLowerCase(), document);
            return element;
        }
        Element element = mathMLDocumentBuilder.createElement("ci", document);
        Variable variable = ((ASTVarNode)node).getVar();
        Text text = document.createTextNode(variable.getName());
        element.appendChild(text);
        return element;
    }

    public String putConstant(String string, String string2) {
        return this.constants.put(string, string2);
    }

    public String putEntity(String string, String string2) {
        return this.entities.put(string, string2);
    }

    public int getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(int n) {
        this.version = n;
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public Map<String, String> getEntities() {
        return this.entities;
    }
}

