/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.extensions.mathml.parser.TagHandler;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.Node;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public abstract class AbstractHandler
implements TagHandler {
    protected Jep jep;
    protected NodeFactory nf;
    protected OperatorTableI ot;
    protected NumberFactory numf;
    protected FunctionTable ft;
    protected VariableTable vt;

    public AbstractHandler(Jep jep) {
        this.jep = jep;
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.numf = jep.getNumberFactory();
        this.ft = jep.getFunctionTable();
        this.vt = jep.getVariableTable();
    }

    protected Node convertToNode(StackFrame stackFrame, Object object, Locator locator) throws SAXParseException {
        if (object instanceof Node) {
            return (Node)object;
        }
        throw new SAXParseException("&lt;" + stackFrame.getName() + "&gt; Argument " + object + "should have been of type node", locator);
    }

    protected Node[] convertChildrenToNodes(StackFrame stackFrame, int n, Locator locator) throws SAXParseException {
        int n2 = stackFrame.getNumChildren() - n;
        Node[] nodeArray = new Node[n2];
        for (int i = 0; i < n2; ++i) {
            nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i + n), locator);
        }
        return nodeArray;
    }

    protected Node[] jepNodesAsArray(StackFrame stackFrame, Locator locator) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Object object : stackFrame.getChildren()) {
            if (!(object instanceof Node)) continue;
            arrayList.add((Node)object);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    protected Node[] jepNodesToFlatArray(StackFrame stackFrame, Locator locator) {
        List<Node> list = this.jepNodesToFlatList(stackFrame);
        return list.toArray(new Node[list.size()]);
    }

    protected List<Node> jepNodesToFlatList(StackFrame stackFrame) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Object object : stackFrame.getChildren()) {
            this.addNodeToList(arrayList, object);
        }
        return arrayList;
    }

    private void addNodeToList(List<Node> list, Object object) {
        if (object instanceof Node) {
            list.add((Node)object);
        }
        if (object instanceof Node[]) {
            for (Node node : (Node[])object) {
                this.addNodeToList(list, node);
            }
        }
    }

    public Jep getJep() {
        return this.jep;
    }

    public NodeFactory getNf() {
        return this.nf;
    }

    public OperatorTableI getOt() {
        return this.ot;
    }

    public NumberFactory getNumf() {
        return this.numf;
    }

    public FunctionTable getFt() {
        return this.ft;
    }
}

