/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.AbstractHandler;
import com.singularsys.extensions.mathml.parser.FunctionElement;
import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.jep.Jep;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTVarNode;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class IdentifierHandler
extends AbstractHandler {
    public IdentifierHandler(Jep jep) {
        super(jep);
    }

    @Override
    public Object handle(StackFrame stackFrame, Locator locator) throws SAXParseException {
        if (stackFrame.getNumChildren() != 1) {
            throw new SAXParseException("Only one child for <ci> nodes supported", locator);
        }
        Object object = stackFrame.getChild(0);
        if (!(object instanceof String)) {
            throw new SAXParseException("Child of <ci> node must be a string its a " + object.getClass().getSimpleName(), locator);
        }
        String string = (String)object;
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new SAXParseException("Only java format identifiers supported as identifiers, found '" + string + "'", locator);
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new SAXParseException("Only java format identifiers supported as identifiers, found '" + string + "'", locator);
        }
        String string2 = stackFrame.getAttributeValue("type");
        if (string2 != null && (string2.equals("fn") || string2.equals("function"))) {
            PostfixMathCommandI postfixMathCommandI = this.ft.getFunction(string);
            if (postfixMathCommandI == null) {
                throw new SAXParseException("<ci type=\"" + string2 + "\"> unknown function '" + string + "'", locator);
            }
            return new FunctionElement(string, postfixMathCommandI);
        }
        try {
            ASTVarNode aSTVarNode = this.jep.getNodeFactory().buildVariableNode(string);
            return aSTVarNode;
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessage(), locator, parseException);
        }
    }
}

