/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.extensions.mathml.parser.StartTagHandler;
import com.singularsys.extensions.mathml.parser.TagHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class MathMLDocumentHandler
extends DefaultHandler {
    static final boolean DEBUG = false;
    Map<String, StartTagHandler> startHandlers = new HashMap<String, StartTagHandler>();
    Map<String, TagHandler> handlers = new HashMap<String, TagHandler>();
    TagHandler unknownHandler;
    List<Object> results;
    Locator locator;
    Stack<StackFrame> stack = new Stack();
    StringBuilder sb = new StringBuilder();

    @Override
    public void startDocument() throws SAXException {
        StackFrame stackFrame = new StackFrame(null, new AttributesImpl());
        this.stack.clear();
        this.stack.push(stackFrame);
        for (StartTagHandler startTagHandler : this.startHandlers.values()) {
            startTagHandler.startDoc();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.stack.size() != 1) {
            throw new SAXException("Stack corupted at end of document");
        }
        this.results = this.stack.pop().getChildren();
        for (StartTagHandler startTagHandler : this.startHandlers.values()) {
            startTagHandler.endDoc();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.processChars();
        StackFrame stackFrame = new StackFrame(string2, attributes);
        this.stack.push(stackFrame);
        StartTagHandler startTagHandler = this.startHandlers.get(stackFrame.getName());
        if (startTagHandler != null) {
            startTagHandler.start(stackFrame, this.locator);
        }
        this.resetChars();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.processChars();
        StackFrame stackFrame = this.stack.pop();
        TagHandler tagHandler = this.handlers.get(stackFrame.getName());
        Object object = null;
        if (tagHandler != null) {
            object = tagHandler.handle(stackFrame, this.locator);
        } else if (this.unknownHandler != null) {
            object = this.unknownHandler.handle(stackFrame, this.locator);
        } else {
            throw new SAXParseException("No handler for element <" + string2 + ">", this.locator);
        }
        StackFrame stackFrame2 = this.stack.peek();
        stackFrame2.addChild(object);
        this.resetChars();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.sb.append(cArray, n, n2);
    }

    protected void processChars() {
        String string = this.sb.toString().trim();
        if (string.length() > 0) {
            string = string.replaceAll("\\s\\s+", " ");
            StackFrame stackFrame = this.stack.peek();
            stackFrame.addChild(string);
        }
    }

    protected void resetChars() {
        this.sb = new StringBuilder();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public List<Object> getResults() {
        return this.results;
    }

    public TagHandler put(String string, TagHandler tagHandler) {
        if (tagHandler instanceof StartTagHandler) {
            this.startHandlers.put(string, (StartTagHandler)tagHandler);
        }
        return this.handlers.put(string, tagHandler);
    }

    public TagHandler remove(Object object) {
        if (this.startHandlers.containsKey(object)) {
            this.startHandlers.remove(object);
        }
        return this.handlers.remove(object);
    }

    public Map<String, StartTagHandler> getStartHandlers() {
        return this.startHandlers;
    }

    public Map<String, TagHandler> getHandlers() {
        return this.handlers;
    }

    public TagHandler get(Object object) {
        return this.handlers.get(object);
    }

    public TagHandler getUnknownHandler() {
        return this.unknownHandler;
    }

    public void setUnknownHandler(TagHandler tagHandler) {
        this.unknownHandler = tagHandler;
    }
}

