/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.AbstractHandler;
import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.jep.Jep;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class MatrixHandler
extends AbstractHandler {
    @Override
    public Object handle(StackFrame stackFrame, Locator locator) throws SAXParseException {
        if (stackFrame.getName().equals("matrix")) {
            return this.handleMatrix(stackFrame, locator);
        }
        if (stackFrame.getName().equals("matrixrow")) {
            return this.handleVector(stackFrame, locator);
        }
        if (stackFrame.getName().equals("vector")) {
            return this.handleList(stackFrame, locator);
        }
        if (stackFrame.getName().equals("list")) {
            return this.handleList(stackFrame, locator);
        }
        if (stackFrame.getName().equals("set")) {
            return this.handleList(stackFrame, locator);
        }
        return null;
    }

    public MatrixHandler(Jep jep) {
        super(jep);
    }

    private Object handleList(StackFrame stackFrame, Locator locator) throws SAXParseException {
        Node[] nodeArray = new Node[stackFrame.getNumChildren()];
        int n = stackFrame.getNumChildren();
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i), locator);
        }
        try {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getList(), nodeArray);
            return aSTOpNode;
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessage(), locator, parseException);
        }
    }

    private Object handleVector(StackFrame stackFrame, Locator locator) throws SAXParseException {
        Node[] nodeArray = new Node[stackFrame.getNumChildren()];
        int n = stackFrame.getNumChildren();
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i), locator);
            if (!(nodeArray[i] instanceof ASTOpNode) || !((ASTOpNode)nodeArray[i]).getOperator().equals(this.ot.getList())) continue;
            throw new SAXParseException("Elements of at <" + stackFrame.getName() + "> cannot be lists", locator);
        }
        try {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getList(), nodeArray);
            return aSTOpNode;
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessage(), locator, parseException);
        }
    }

    private Object handleMatrix(StackFrame stackFrame, Locator locator) throws SAXParseException {
        Node[] nodeArray = new Node[stackFrame.getNumChildren()];
        int n = stackFrame.getNumChildren();
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i), locator);
            if (nodeArray[i] instanceof ASTOpNode && ((ASTOpNode)nodeArray[i]).getOperator().equals(this.ot.getList())) continue;
            throw new SAXParseException("Elements of at <matrix> must be lists", locator);
        }
        try {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getList(), nodeArray);
            return aSTOpNode;
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessage(), locator, parseException);
        }
    }
}

