/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix;

import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFieldI;
import com.singularsys.extensions.matrix.functions.MatrixDet;
import com.singularsys.extensions.matrix.functions.MatrixId;
import com.singularsys.extensions.matrix.functions.MatrixInv;
import com.singularsys.extensions.matrix.functions.MatrixSize;
import com.singularsys.extensions.matrix.functions.MatrixSolve;
import com.singularsys.extensions.matrix.functions.MatrixTrace;
import com.singularsys.extensions.matrix.functions.MatrixTrans;
import com.singularsys.extensions.matrix.functions.MatrixZeroMat;
import com.singularsys.extensions.matrix.functions.MatrixZeroVec;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.standard.StandardFunctionTable;
import java.util.Map;

public class MatrixFunctionTable
extends FunctionTable {
    private static final long serialVersionUID = 340L;

    public MatrixFunctionTable(MatrixFactoryI matrixFactoryI, MatrixFieldI matrixFieldI) {
        this(new StandardFunctionTable(), matrixFactoryI, matrixFieldI);
    }

    public MatrixFunctionTable(FunctionTable functionTable, MatrixFactoryI matrixFactoryI, MatrixFieldI matrixFieldI) {
        for (Map.Entry<String, PostfixMathCommandI> entry : functionTable.entrySet()) {
            this.addFunction(entry.getKey(), entry.getValue());
        }
        this.addMatrixFunctions(matrixFactoryI, matrixFieldI);
    }

    public void addMatrixFunctions(MatrixFactoryI matrixFactoryI, MatrixFieldI matrixFieldI) {
        this.addFunction("det", new MatrixDet(matrixFieldI));
        this.addFunction("trace", new MatrixTrace(matrixFieldI));
        this.addFunction("trans", new MatrixTrans(matrixFieldI));
        this.addFunction("id", new MatrixId(matrixFactoryI, matrixFieldI));
        this.addFunction("inv", new MatrixInv(matrixFactoryI, matrixFieldI));
        this.addFunction("solve", new MatrixSolve(matrixFactoryI, matrixFieldI));
        this.addFunction("zeroMat", new MatrixZeroMat(matrixFactoryI, matrixFieldI));
        this.addFunction("zeroVec", new MatrixZeroVec(matrixFactoryI, matrixFieldI));
        this.addFunction("size", new MatrixSize(matrixFactoryI, matrixFieldI));
    }
}

