/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix;

import com.singularsys.extensions.field.FieldOperatorTable;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFieldI;
import com.singularsys.extensions.matrix.functions.MatrixAdd;
import com.singularsys.extensions.matrix.functions.MatrixCross;
import com.singularsys.extensions.matrix.functions.MatrixDiv;
import com.singularsys.extensions.matrix.functions.MatrixDot;
import com.singularsys.extensions.matrix.functions.MatrixEle;
import com.singularsys.extensions.matrix.functions.MatrixList;
import com.singularsys.extensions.matrix.functions.MatrixMod;
import com.singularsys.extensions.matrix.functions.MatrixMul;
import com.singularsys.extensions.matrix.functions.MatrixNeg;
import com.singularsys.extensions.matrix.functions.MatrixPow;
import com.singularsys.extensions.matrix.functions.MatrixSub;
import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.functions.Assign;

public class MatrixOperatorTable
extends FieldOperatorTable {
    private static final long serialVersionUID = 340L;
    MatrixFieldI mfield;
    MatrixFactoryI mfact;

    public MatrixOperatorTable(MatrixFactoryI matrixFactoryI, MatrixFieldI matrixFieldI) {
        super(matrixFieldI);
        this.mfact = matrixFactoryI;
        this.mfield = matrixFieldI;
        this.setMatrixPfmcs();
    }

    public MatrixOperatorTable(OperatorTable2 operatorTable2, MatrixFactoryI matrixFactoryI, MatrixFieldI matrixFieldI) {
        super(operatorTable2, matrixFieldI);
        this.mfact = matrixFactoryI;
        this.mfield = matrixFieldI;
        this.setMatrixPfmcs();
    }

    @Override
    protected void setBasicPfmcs() {
    }

    @Override
    protected void setSpecialPfmcs() {
    }

    protected void setMatrixPfmcs() {
        this.getOperator(OperatorTable2.BasicOperators.ADD).setPFMC(new MatrixAdd(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.SUB).setPFMC(new MatrixSub(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.NEG).setPFMC(new MatrixNeg(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.MUL).setPFMC(new MatrixMul(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.MUL).setFlag(32, false);
        this.getOperator(OperatorTable2.BasicOperators.DIV).setPFMC(new MatrixDiv(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.MOD).setPFMC(new MatrixMod(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.POW).setPFMC(new MatrixPow(this.mfield));
        this.getOperator(OperatorTable2.BasicOperators.GT).setPFMC(this.getGtFunction());
        this.getOperator(OperatorTable2.BasicOperators.LT).setPFMC(this.getLtFunction());
        this.getOperator(OperatorTable2.BasicOperators.EQ).setPFMC(this.getEqFunction());
        this.getOperator(OperatorTable2.BasicOperators.LE).setPFMC(this.getLeFunction());
        this.getOperator(OperatorTable2.BasicOperators.GE).setPFMC(this.getGeFunction());
        this.getOperator(OperatorTable2.BasicOperators.NE).setPFMC(this.getNeFunction());
        this.getOperator(OperatorTable2.BasicOperators.AND).setPFMC(this.getAndFunction());
        this.getOperator(OperatorTable2.BasicOperators.OR).setPFMC(this.getOrFunction());
        this.getOperator(OperatorTable2.BasicOperators.NOT).setPFMC(this.getNotFunction());
        this.getOperator(OperatorTable2.SpecialOperators.ASSIGN).setPFMC(new Assign());
        this.getOperator(OperatorTable2.SpecialOperators.DOT).setPFMC(new MatrixDot(this.mfield));
        this.getOperator(OperatorTable2.SpecialOperators.CROSS).setPFMC(new MatrixCross(this.mfield));
        this.getOperator(OperatorTable2.SpecialOperators.LIST).setPFMC(new MatrixList(this.mfact));
        this.getOperator(OperatorTable2.SpecialOperators.ELEMENT).setPFMC(new MatrixEle(this.mfact, this.mfield));
    }

    public MatrixFieldI getMatrixField() {
        return this.mfield;
    }

    public MatrixFactoryI getMatrixFactory() {
        return this.mfact;
    }
}

