/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.doublemat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.jep.EvaluationException;
import java.util.Arrays;

public final class DoubleMatrix
implements MatrixI {
    double[][] data;
    int nrows;
    int ncols;

    public DoubleMatrix(double[][] dArray) {
        this.data = dArray;
        this.nrows = dArray.length;
        this.ncols = dArray[0].length;
    }

    public static DoubleMatrix newInstance(Double[][] doubleArray) {
        int n = doubleArray.length;
        int n2 = doubleArray[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Double d = doubleArray[i][j];
                dArray[i][j] = ((Number)d).doubleValue();
            }
        }
        return new DoubleMatrix(dArray);
    }

    public static DoubleMatrix newInstance(DoubleVector[] doubleVectorArray) {
        int n = doubleVectorArray.length;
        int n2 = doubleVectorArray[0].getNEles();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(doubleVectorArray[i].data, 0, dArray[i], 0, n2);
        }
        return new DoubleMatrix(dArray);
    }

    @Override
    public Double getEle(int n, int n2) {
        return this.data[n][n2];
    }

    public double getDEle(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public int getNRows() {
        return this.nrows;
    }

    @Override
    public int getNCols() {
        return this.ncols;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.nrows, this.ncols);
    }

    public double[][] toArrayMat() {
        return (double[][])this.data.clone();
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.data);
    }

    public void setEle(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    @Override
    public void setEle(int n, int n2, Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new EvaluationException("Double Matrix set ele: Value must be a number its " + object);
        }
        this.data[n][n2] = ((Number)object).doubleValue();
    }

    @Override
    public Object[][] toArray(Object[][] objectArray) throws EvaluationException {
        if (objectArray == null || objectArray.length != this.nrows || objectArray[0].length != this.ncols) {
            throw new EvaluationException("Null matrix or matrix of wrong size.");
        }
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                objectArray[i][j] = this.data[i][j];
            }
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode((Object[])this.data);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleMatrix doubleMatrix = (DoubleMatrix)object;
        if (this.ncols != doubleMatrix.ncols) {
            return false;
        }
        if (this.nrows != doubleMatrix.nrows) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.data, (Object[])doubleMatrix.data);
    }

    public boolean eq(DoubleMatrix doubleMatrix) {
        if (this.nrows != doubleMatrix.nrows || this.ncols != doubleMatrix.ncols) {
            return false;
        }
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                if (this.data[i][j] == doubleMatrix.data[i][j]) continue;
                return false;
            }
        }
        return true;
    }
}

