/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.doublemat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import java.text.MessageFormat;
import java.util.Arrays;

public final class DoubleVector
implements VectorI {
    public final double[] data;
    public final int nrows;

    public DoubleVector(double[] dArray) {
        this.data = dArray;
        this.nrows = dArray.length;
    }

    public static DoubleVector newInstance(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return new DoubleVector(dArray);
    }

    public static DoubleVector newInstance(double[] dArray) {
        return new DoubleVector(dArray);
    }

    @Override
    public Double getEle(int n) {
        return this.data[n];
    }

    @Override
    public void setEle(int n, Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new EvaluationException("Double Vector set ele: Value must be a number its " + object);
        }
        this.data[n] = ((Number)object).doubleValue();
    }

    @Override
    public int getNEles() {
        return this.nrows;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.nrows);
    }

    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public boolean eq(DoubleVector doubleVector) {
        if (this == doubleVector) {
            return true;
        }
        if (doubleVector == null) {
            return false;
        }
        if (this.nrows != doubleVector.nrows) {
            return false;
        }
        for (int i = 0; i < this.nrows; ++i) {
            if (this.data[i] == doubleVector.data[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public Object[] toArray(Object[] objectArray) throws EvaluationException {
        if (objectArray == null) {
            throw new EvaluationException("DoubleVector.toArray null vector");
        }
        if (objectArray.length != this.nrows) {
            throw new EvaluationException(MessageFormat.format("DoubleVector.toArray wrong size for supplied vector expected %d got %d", this.nrows, objectArray.length));
        }
        for (int i = 0; i < this.nrows; ++i) {
            objectArray[i] = this.data[i];
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.data);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleVector doubleVector = (DoubleVector)object;
        if (this.nrows != doubleVector.nrows) {
            return false;
        }
        return Arrays.equals(this.data, doubleVector.data);
    }
}

