/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.ExtMessages;
import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.text.MessageFormat;

public class MatrixMul
extends NaryBinaryFunction
implements MatrixFunctionI {
    private static final long serialVersionUID = 340L;
    FieldI mfield;

    public MatrixMul(FieldI fieldI) {
        this.mfield = fieldI;
    }

    public Object mul(Object object, Object object2) throws EvaluationException {
        Object object3 = this.mfield.mul(object, object2);
        if (object3 != null) {
            return object3;
        }
        throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) throws ParseException {
        int n = dimensionsArray.length;
        if (n <= 0) {
            throw new ParseException(String.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), this.getName(), n));
        }
        Dimensions dimensions = dimensionsArray[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            dimensions = this.calcMultiplyDim(dimensionsArray[i], dimensions);
        }
        return dimensions;
    }

    public Dimensions calcMultiplyDim(Dimensions dimensions, Dimensions dimensions2) throws ParseException {
        int n = dimensions.order();
        int n2 = dimensions2.order();
        block0 : switch (n) {
            case 0: {
                return dimensions2;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                    case 1: {
                        return Dimensions.valueOf(dimensions.getFirstDim(), dimensions2.getFirstDim());
                    }
                    case 2: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions2.getLastDim());
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                    case 1: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions.getFirstDim());
                    }
                    case 2: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions.getFirstDim(), dimensions2.getLastDim());
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                }
            }
        }
        throw new ParseException(MessageFormat.format(ExtMessages.getString("DimensionMissmatch"), this.getName(), dimensions, dimensions2));
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.mul(object, object2);
    }
}

