/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.genericmat;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.genericmat.GenericMatrix;
import com.singularsys.extensions.matrix.genericmat.GenericVector;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;

public class GenericMatrixFactory<E>
implements MatrixFactoryI {
    private static final long serialVersionUID = 350L;
    protected final E ZERO;
    protected final E ONE;

    public GenericMatrixFactory(GenericField<E> genericField) {
        this.ZERO = genericField.getZero();
        this.ONE = genericField.getOne();
    }

    public GenericMatrixFactory(E e, E e2) {
        this.ZERO = e;
        this.ONE = e2;
    }

    public E elementValue(Object object) throws EvaluationException {
        return (E)object;
    }

    protected GenericMatrix<E> cast(MatrixI matrixI) {
        return (GenericMatrix)matrixI;
    }

    protected GenericVector<E> cast(VectorI vectorI) {
        return (GenericVector)vectorI;
    }

    protected E zeroEement() {
        return this.ZERO;
    }

    public E getONE() {
        return this.ONE;
    }

    protected Object[][] buildDataArray(int n, int n2) {
        return new Object[n][n2];
    }

    protected Object[] buildDataArray(int n) {
        return new Object[n];
    }

    public GenericMatrix<E> newMatrixUnchecked(Object[][] objectArray) {
        return new GenericMatrix(objectArray);
    }

    @Override
    public GenericMatrix<E> newMatrix(Object[][] objectArray) throws EvaluationException {
        int n = objectArray.length;
        int n2 = objectArray[0].length;
        Object[][] objectArray2 = this.buildDataArray(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                E e = this.elementValue(objectArray[i][j]);
                if (e == null) {
                    throw new EvaluationException("Matrix element (" + i + "," + j + ") = " + objectArray[i][j] + " cannot be converted to " + this.ZERO.getClass().getSimpleName());
                }
                objectArray2[i][j] = e;
            }
        }
        return this.newMatrixUnchecked(objectArray2);
    }

    public GenericVector<E> newVectorUnchecked(Object[] objectArray) {
        return new GenericVector(objectArray);
    }

    @Override
    public GenericVector<E> newVector(Object ... objectArray) throws EvaluationException {
        int n = objectArray.length;
        Object[] objectArray2 = this.buildDataArray(n);
        for (int i = 0; i < n; ++i) {
            E e = this.elementValue(objectArray[i]);
            if (e == null) {
                throw new EvaluationException("Vector element (" + i + ") = " + objectArray[i] + " cannot be converted to " + this.ZERO.getClass().getSimpleName());
            }
            objectArray2[i] = e;
        }
        return this.newVectorUnchecked(objectArray2);
    }

    @Override
    public GenericMatrix<E> identity(int n) throws EvaluationException {
        return this.identity(n, n);
    }

    @Override
    public GenericMatrix<E> identity(int n, int n2) throws EvaluationException {
        Object[][] objectArray = this.buildDataArray(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = i == j ? this.ONE : this.ZERO;
            }
        }
        return this.newMatrixUnchecked(objectArray);
    }

    public GenericMatrix<E> zeroMat(int n) throws EvaluationException {
        return this.zeroMat(n, n);
    }

    @Override
    public GenericMatrix<E> zeroMat(int n, int n2) throws EvaluationException {
        Object[][] objectArray = this.buildDataArray(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = this.ZERO;
            }
        }
        return this.newMatrixUnchecked(objectArray);
    }

    @Override
    public GenericMatrix<E> zeroMat(Dimensions dimensions) throws EvaluationException {
        if (dimensions.order() != 2) {
            throw new EvaluationException("Dimensions must be of order two, found" + dimensions);
        }
        return this.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
    }

    @Override
    public GenericVector<E> zeroVec(int n) throws EvaluationException {
        Object[] objectArray = this.buildDataArray(n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.ZERO;
        }
        return this.newVectorUnchecked(objectArray);
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

