/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.sequencemat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.jep.EvaluationException;
import java.util.Arrays;

public final class SequenceMatrix
implements MatrixI {
    double[] data;
    int nrows;
    int ncols;

    SequenceMatrix(double[] dArray, int n, int n2) {
        this.data = dArray;
        this.nrows = n;
        this.ncols = n2;
    }

    public static SequenceMatrix newInstance(Double[][] doubleArray) {
        int n = doubleArray.length;
        int n2 = doubleArray[0].length;
        double[] dArray = new double[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[n3] = doubleArray[i][j];
                ++n3;
            }
        }
        return new SequenceMatrix(dArray, n, n2);
    }

    public static SequenceMatrix newInstance(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[n3] = dArray[i][j];
                ++n3;
            }
        }
        return new SequenceMatrix(dArray2, n, n2);
    }

    public static SequenceMatrix newInstance(DoubleVector[] doubleVectorArray) {
        int n = doubleVectorArray.length;
        int n2 = doubleVectorArray[0].getNEles();
        double[] dArray = new double[n * n2];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(doubleVectorArray[i].data, 0, dArray[i], i * n2, n2);
        }
        return new SequenceMatrix(dArray, n, n2);
    }

    @Override
    public Double getEle(int n, int n2) {
        return this.data[n * this.ncols + n2];
    }

    public double getDEle(int n, int n2) {
        return this.data[n * this.ncols + n2];
    }

    @Override
    public int getNRows() {
        return this.nrows;
    }

    @Override
    public int getNCols() {
        return this.ncols;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.nrows, this.ncols);
    }

    public double[][] toArrayMat() {
        double[][] dArray = new double[this.nrows][this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            System.arraycopy(this.data, i * this.ncols, dArray[i], 0, this.ncols);
        }
        return dArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('[');
            for (int j = 0; j < this.ncols; ++j) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.valueOf(this.data[n]));
                ++n;
            }
            stringBuilder.append(']');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void setEle(int n, int n2, Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new EvaluationException("Double Matrix set ele: Value must be a number its " + object);
        }
        this.data[n * this.ncols + n2] = ((Number)object).doubleValue();
    }

    @Override
    public Object[][] toArray(Object[][] objectArray) throws EvaluationException {
        if (objectArray == null || objectArray.length != this.nrows || objectArray[0].length != this.ncols) {
            throw new EvaluationException("Null matrix or matrix of wrong size.");
        }
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                objectArray[i][j] = this.data[n++];
            }
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.data);
        n = 31 * n + this.ncols;
        n = 31 * n + this.nrows;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SequenceMatrix sequenceMatrix = (SequenceMatrix)object;
        if (this.ncols != sequenceMatrix.ncols) {
            return false;
        }
        if (this.nrows != sequenceMatrix.nrows) {
            return false;
        }
        return Arrays.equals(this.data, sequenceMatrix.data);
    }

    public boolean eq(SequenceMatrix sequenceMatrix) {
        if (this == sequenceMatrix) {
            return true;
        }
        if (sequenceMatrix == null) {
            return false;
        }
        if (this.ncols != sequenceMatrix.ncols) {
            return false;
        }
        if (this.nrows != sequenceMatrix.nrows) {
            return false;
        }
        for (int i = 0; i < this.nrows; ++i) {
            if (this.data[i] == sequenceMatrix.data[i]) continue;
            return false;
        }
        return true;
    }
}

