/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrixdiff;

import com.singularsys.extensions.djep.DifferentiationVisitor;
import com.singularsys.extensions.matrix.DimensionVisitor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;

public class MatrixDifferentiationVisitor
extends DifferentiationVisitor {
    private static final long serialVersionUID = 350L;
    MatrixFactoryI mfact;

    public MatrixDifferentiationVisitor(MatrixFactoryI matrixFactoryI) {
        this.mfact = matrixFactoryI;
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        try {
            Dimensions dimensions = DimensionVisitor.getDimByValue(aSTConstant.getValue());
            if (dimensions.is0D()) {
                return this.nf.buildConstantNode(this.tu.getZero());
            }
            if (dimensions.is1D()) {
                VectorI vectorI = this.mfact.zeroVec(dimensions.getFirstDim());
                return this.nf.buildConstantNode(vectorI);
            }
            if (dimensions.is2D()) {
                MatrixI matrixI = this.mfact.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
                return this.nf.buildConstantNode(matrixI);
            }
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
        return super.visit(aSTConstant, object);
    }
}

