/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.MutablePolynomial;
import com.singularsys.extensions.polynomials.PConstant;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.POperator;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class Polynomial
extends AbstractPNode {
    final PNodeI[] terms;

    private Polynomial(PolynomialCreator polynomialCreator, PNodeI[] pNodeIArray) {
        super(polynomialCreator);
        this.terms = pNodeIArray;
    }

    public static PNodeI valueOf(PolynomialCreator polynomialCreator, PNodeI[] pNodeIArray) throws ParseException {
        PNodeI[] pNodeIArray2 = new PNodeI[pNodeIArray.length];
        for (int i = 0; i < pNodeIArray.length; ++i) {
            pNodeIArray2[i] = pNodeIArray[i];
        }
        MutablePolynomial mutablePolynomial = new MutablePolynomial(polynomialCreator, pNodeIArray2);
        return mutablePolynomial.toPNode();
    }

    MutablePolynomial toMutiablePolynomial() {
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            pNodeIArray[i] = this.terms[i];
        }
        return new MutablePolynomial(this.pc, pNodeIArray);
    }

    static PNodeI fromMutiablePolynomial(MutablePolynomial mutablePolynomial) {
        if (mutablePolynomial.terms.length == 0) {
            return mutablePolynomial.pc.zeroConstant;
        }
        if (mutablePolynomial.terms.length == 1) {
            return mutablePolynomial.terms[0];
        }
        return new Polynomial(mutablePolynomial.pc, mutablePolynomial.terms);
    }

    @Override
    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof Polynomial) {
            return this.add((Polynomial)pNodeI);
        }
        MutablePolynomial mutablePolynomial = this.toMutiablePolynomial();
        mutablePolynomial.add(pNodeI);
        return mutablePolynomial.toPNode();
    }

    @Override
    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof Polynomial) {
            return this.sub((Polynomial)pNodeI);
        }
        MutablePolynomial mutablePolynomial = this.toMutiablePolynomial();
        mutablePolynomial.add(pNodeI.negate());
        return mutablePolynomial.toPNode();
    }

    public PNodeI add(Polynomial polynomial) throws ParseException {
        MutablePolynomial mutablePolynomial = this.toMutiablePolynomial();
        for (int i = 0; i < polynomial.terms.length; ++i) {
            mutablePolynomial.add(polynomial.terms[i]);
        }
        return mutablePolynomial.toPNode();
    }

    public PNodeI sub(Polynomial polynomial) throws ParseException {
        MutablePolynomial mutablePolynomial = this.toMutiablePolynomial();
        for (int i = 0; i < polynomial.terms.length; ++i) {
            mutablePolynomial.add(polynomial.terms[i].negate());
        }
        return mutablePolynomial.toPNode();
    }

    @Override
    public PNodeI negate() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            pNodeIArray[i] = this.terms[i].negate();
        }
        return new Polynomial(this.pc, pNodeIArray);
    }

    @Override
    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            PConstant pConstant = (PConstant)pNodeI;
            if (pConstant.isZero()) {
                return this.pc.zeroConstant;
            }
            if (pConstant.isOne()) {
                return this;
            }
            if (pConstant.isInfinity()) {
                return this.pc.infConstant;
            }
        }
        return super.mul(pNodeI);
    }

    @Override
    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            PConstant pConstant = (PConstant)pNodeI;
            if (pConstant.isZero()) {
                if (this.pc.tu.hasInfinity()) {
                    return this.pc.infConstant;
                }
                return new POperator(this.pc, this.pc.ot.getDivide(), new PNodeI[]{this, pConstant});
            }
            if (pConstant.isOne()) {
                return this;
            }
            PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                pNodeIArray[i] = this.terms[i].div(pConstant);
            }
            return new Polynomial(this.pc, pNodeIArray);
        }
        return super.div(pNodeI);
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        if (!(pNodeI instanceof Polynomial)) {
            return false;
        }
        Polynomial polynomial = (Polynomial)pNodeI;
        if (this.terms.length != polynomial.terms.length) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equalsPNode(polynomial.terms[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(PNodeI pNodeI) {
        if (pNodeI instanceof Polynomial) {
            return this.compareTo((Polynomial)pNodeI);
        }
        int n = this.terms[this.terms.length - 1].compareTo(pNodeI);
        if (n != 0) {
            return n;
        }
        if (this.terms.length == 1) {
            return 0;
        }
        n = this.terms[this.terms.length - 2].compareTo(this.pc.zeroConstant);
        return n;
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        int n;
        int n2;
        int n3 = this.terms.length - 1;
        for (n2 = polynomial.terms.length - 1; n3 >= 0 && n2 >= 0; --n3, --n2) {
            n = this.terms[n3].compareTo(polynomial.terms[n2]);
            if (n == 0) continue;
            return n;
        }
        if (this.terms.length < polynomial.terms.length) {
            n = this.pc.zeroConstant.compareTo(polynomial.terms[n2]);
            return n;
        }
        if (this.terms.length > polynomial.terms.length) {
            n = this.terms[n3].compareTo(this.pc.zeroConstant);
            return n;
        }
        return 0;
    }

    private boolean isNegative(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return ((PConstant)pNodeI).isNegative();
        }
        if (pNodeI instanceof Monomial) {
            return ((Monomial)pNodeI).negativeCoefficient();
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.terms.length == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0 && !this.isNegative(this.terms[i])) {
                stringBuffer.append('+');
            }
            stringBuffer.append(this.terms[i].toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        NodeFactory nodeFactory = this.pc.getNodeFactory();
        if (this.terms.length == 0) {
            return nodeFactory.buildConstantNode(this.pc.tu.getZero());
        }
        Node node = this.terms[0].toNode();
        for (int i = 1; i < this.terms.length; ++i) {
            node = this.terms[i] instanceof Monomial && ((Monomial)this.terms[i]).getCoeff().isNegative() ? nodeFactory.buildOperatorNode(this.pc.getOperatorTable().getSubtract(), node, this.terms[i].negate().toNode()) : nodeFactory.buildOperatorNode(this.pc.getOperatorTable().getAdd(), node, this.terms[i].toNode());
        }
        return node;
    }

    @Override
    public Node toCompactNode() throws ParseException {
        if (this.terms.length == 0) {
            return this.pc.getNodeFactory().buildConstantNode(this.pc.tu.getZero());
        }
        Node[] nodeArray = new Node[this.terms.length];
        int[] nArray = new int[this.terms.length];
        int n = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            nArray[i] = 1;
            if (this.terms[i] instanceof Monomial) {
                if (((Monomial)this.terms[i]).getCoeff().isNegative()) {
                    nArray[i] = -1;
                    ++n;
                    nodeArray[i] = this.terms[i].negate().toNode();
                    continue;
                }
                nodeArray[i] = this.terms[i].toNode();
                continue;
            }
            nodeArray[i] = this.terms[i].toNode();
        }
        if (n == 0) {
            if (this.terms.length == 1 && n == 0) {
                return nodeArray[0];
            }
            return this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getAdd(), nodeArray);
        }
        if (this.terms.length == 1) {
            return this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getUMinus(), nodeArray[0]);
        }
        if (this.terms.length == n) {
            ASTOpNode aSTOpNode = this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getUMinus(), nodeArray[0]);
            for (int i = 1; i < this.terms.length; ++i) {
                aSTOpNode = this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getSubtract(), aSTOpNode, nodeArray[i]);
            }
            return aSTOpNode;
        }
        Node[] nodeArray2 = new Node[this.terms.length - n];
        Node[] nodeArray3 = new Node[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            if (nArray[i] > 0) {
                nodeArray2[n2++] = nodeArray[i];
                continue;
            }
            nodeArray3[n3++] = nodeArray[i];
        }
        Node node = n2 == 1 ? nodeArray2[0] : this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getAdd(), nodeArray2);
        for (int i = 0; i < n3; ++i) {
            node = this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getSubtract(), node, nodeArray3[i]);
        }
        return node;
    }

    @Override
    public PNodeI expand() throws ParseException {
        MutablePolynomial mutablePolynomial = new MutablePolynomial(this.pc, new PNodeI[]{this.pc.zeroConstant});
        for (int i = 0; i < this.terms.length; ++i) {
            PNodeI pNodeI = this.terms[i].expand();
            mutablePolynomial.add(pNodeI);
        }
        return mutablePolynomial.toPNode();
    }

    public int getNTerms() {
        return this.terms.length;
    }

    public PNodeI getTerm(int n) {
        return this.terms[n];
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        for (int i = 0; i < this.terms.length; ++i) {
            this.terms[i].convertToPolyArray(string, map);
        }
    }
}

