/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import java.lang.reflect.Array;
import java.util.Stack;

public abstract class ArgumentExpander {
    public void doStack(Stack<Object> stack, int n) throws EvaluationException {
        for (int i = 0; i < n; ++i) {
            this.doArg(stack.pop());
        }
    }

    public void doArg(Object object) throws EvaluationException {
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.doArg(t);
            }
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                this.doArg(object2);
            }
        } else if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            for (int i = 0; i < vectorI.getNEles(); ++i) {
                this.doArg(vectorI.getEle(i));
            }
        } else if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            for (int i = 0; i < matrixI.getNRows(); ++i) {
                for (int j = 0; j < matrixI.getNCols(); ++j) {
                    this.doArg(matrixI.getEle(i, j));
                }
            }
        } else {
            this.doSingleArg(object);
        }
    }

    protected abstract void doSingleArg(Object var1) throws EvaluationException;
}

