/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.extensions.statistical.FieldComparator;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class Percentile
extends PostfixMathCommand
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI fm;
    NumberFactory numf;
    Type type;

    public Percentile(FieldI fieldI, Type type) {
        super(-1);
        this.fm = fieldI;
        this.type = type;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Processor processor = new Processor();
        Object object = stack.pop();
        if (!(object instanceof Number)) {
            throw new EvaluationException("Percent argument needs to be a Number type");
        }
        double d = ((Number)object).doubleValue();
        processor.doStack(stack, this.curNumberOfParameters - 1);
        Collections.sort(processor.set, new FieldComparator(this.fm, true));
        Object object2 = null;
        double d2 = 1.0;
        int n = 0;
        double d3 = 0.0;
        switch (this.type) {
            case NEAREST: {
                n = (int)Math.ceil((double)processor.neles * d);
                break;
            }
            case INCLUSIVE: {
                d2 = (double)(processor.neles - 1) * d + 1.0;
                n = (int)Math.floor(d2);
                d3 = d2 - (double)n;
                break;
            }
            case MID: {
                d2 = (double)processor.neles * d + 0.5;
                n = (int)Math.floor(d2);
                d3 = d2 - (double)n;
                break;
            }
            case MEDIAN: {
                d2 = ((double)processor.neles + 0.3333333333333333) * d + 0.3333333333333333;
                n = (int)Math.floor(d2);
                d3 = d2 - (double)n;
                break;
            }
            case EXCLUSIVE: {
                d2 = (double)(processor.neles + 1) * d;
                n = (int)Math.floor(d2);
                d3 = d2 - (double)n;
            }
        }
        if (n < 1) {
            object2 = processor.set.get(0);
        } else if (n >= processor.neles) {
            object2 = processor.set.get(processor.neles - 1);
        } else if (d3 == 0.0) {
            object2 = processor.set.get(n - 1);
        } else {
            try {
                object2 = this.fm.add(this.fm.mul(processor.set.get(n - 1), this.numf.createNumber(1.0 - d3)), this.fm.mul(processor.set.get(n), this.numf.createNumber(d3)));
            }
            catch (ParseException parseException) {
                throw new EvaluationException(parseException.getMessage());
            }
        }
        stack.push(object2);
    }

    @Override
    public void init(Jep jep) {
        this.numf = jep.getNumberFactory();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new Percentile(this.fm, this.type);
    }

    static class Processor
    extends ArgumentExpander {
        int neles = 0;
        List<Object> set = new ArrayList<Object>();

        Processor() {
        }

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            ++this.neles;
            this.set.add(object);
        }
    }

    public static enum Type {
        NEAREST,
        INCLUSIVE,
        EXCLUSIVE,
        MID,
        MEDIAN;

    }
}

