/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.BinaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Rank
extends BinaryFunction
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI fm;
    NumberFactory numf;
    Type type;
    boolean descending = true;

    public Rank(Type type, boolean bl, FieldI fieldI) {
        this.fm = fieldI;
        this.type = type;
        this.descending = bl;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        Collection<Object> collection;
        Processor processor = new Processor();
        processor.doArg(object2);
        if (this.type == Type.DENSE) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(processor.data);
            collection = hashSet;
        } else {
            collection = processor.data;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Object e : collection) {
            if (this.fm.lt(e, object).booleanValue()) {
                ++n;
                continue;
            }
            if (this.fm.gt(e, object).booleanValue()) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n3 == 0) {
            return this.numf.getMinusOne();
        }
        try {
            switch (this.type) {
                case COMPETITION: 
                case DENSE: {
                    if (this.descending) {
                        return this.numf.createNumber(n2 + 1);
                    }
                    return this.numf.createNumber(n + 1);
                }
                case FRACTIONAL: {
                    if (this.descending) {
                        return this.numf.createNumber((double)n2 + (1.0 + (double)n3) / 2.0);
                    }
                    return this.numf.createNumber((double)n + (1.0 + (double)n3) / 2.0);
                }
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    @Override
    public void init(Jep jep) {
        this.numf = jep.getNumberFactory();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new Rank(this.type, this.descending, this.fm);
    }

    static class Processor
    extends ArgumentExpander {
        int neles = 0;
        List<Object> data = new ArrayList<Object>();

        Processor() {
        }

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            ++this.neles;
            this.data.add(object);
        }
    }

    public static enum Type {
        COMPETITION,
        DENSE,
        FRACTIONAL;

    }
}

