/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.functions.FieldSqrt;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

public class Variance
extends PostfixMathCommand
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI field;
    Type type;
    Object one;
    FieldSqrt sqrt;

    public Variance(Type type, FieldI fieldI) {
        super(-1);
        this.field = fieldI;
        this.type = type;
        this.sqrt = new FieldSqrt(fieldI, 10);
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Processor processor = new Processor(this.field);
        processor.doStack(stack, this.curNumberOfParameters);
        if (processor.sum instanceof Double && processor.sumSq instanceof Double) {
            double d = (Double)processor.sum;
            double d2 = (Double)processor.sumSq;
            double d3 = d * d;
            double d4 = d3 / (double)processor.neles;
            double d5 = d2 - d4;
            double d6 = 0.0;
            switch (this.type) {
                case POPVAR: {
                    d6 = d5 / (double)processor.neles;
                    break;
                }
                case SAMPLEVAR: {
                    d6 = d5 / (double)(processor.neles - 1);
                    break;
                }
                case POPSD: {
                    d6 = Math.sqrt(d5 / (double)processor.neles);
                    break;
                }
                case SAMPLESD: {
                    d6 = Math.sqrt(d5 / (double)(processor.neles - 1));
                    break;
                }
                case DEVSQ: {
                    d6 = d5;
                }
            }
            stack.push(d6);
            return;
        }
        Object object = this.field.mul(processor.sum, processor.sum);
        Object object2 = this.field.div(object, processor.count);
        Object object3 = this.field.sub(processor.sumSq, object2);
        Object object4 = null;
        switch (this.type) {
            case POPVAR: {
                object4 = this.field.div(object3, processor.count);
                break;
            }
            case SAMPLEVAR: {
                Object object5 = this.field.sub(processor.count, this.field.getOne());
                object4 = this.field.div(object3, object5);
                break;
            }
            case POPSD: {
                Object object6 = this.field.div(object3, processor.count);
                object4 = this.sqrt.eval(object6);
                break;
            }
            case SAMPLESD: {
                Object object7 = this.field.sub(processor.count, this.field.getOne());
                Object object8 = this.field.div(object3, object7);
                object4 = this.sqrt.eval(object8);
                break;
            }
            case DEVSQ: {
                object4 = object3;
            }
        }
        stack.push(object4);
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    static class Processor
    extends ArgumentExpander {
        Object sum;
        Object sumSq;
        int neles;
        FieldI fm;
        Object count;

        public Processor(FieldI fieldI) {
            this.fm = fieldI;
            this.count = fieldI.getZero();
        }

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            ++this.neles;
            if (this.sum == null) {
                this.sum = object;
                this.sumSq = this.fm.mul(object, object);
            } else {
                this.sum = this.fm.add(object, this.sum);
                Object object2 = this.fm.mul(object, object);
                this.sumSq = this.fm.add(object2, this.sumSq);
                if (this.sum == null) {
                    throw new EvaluationException("Average: could not add " + object);
                }
            }
            this.count = this.fm.add(this.count, this.fm.getOne());
        }
    }

    public static enum Type {
        POPVAR,
        SAMPLEVAR,
        POPSD,
        SAMPLESD,
        DEVSQ;

    }
}

