/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical.distributions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.NaryFunction;

public class NormalDist
extends NaryFunction {
    private static final long serialVersionUID = 350L;
    private Type type;

    public NormalDist(Type type) {
        super(type == Type.FOURARG ? -1 : 3);
        this.type = type;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        double d = this.asDouble(0, objectArray[0]);
        double d2 = this.asDouble(1, objectArray[1]);
        double d3 = this.asDouble(2, objectArray[2]);
        if (this.type == Type.FOURARG && objectArray.length == 4 && this.asInt(3, objectArray[3]) != 0) {
            double d4 = NormalDist.pdf(d, d2, d3);
            return d4;
        }
        if (this.type == Type.PDF) {
            double d5 = NormalDist.pdf(d, d2, d3);
            return d5;
        }
        double d6 = NormalDist.cdf(d, d2, d3);
        return d6;
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = (d - d2) / d3;
        double d5 = NormalDist.phi(d4);
        return d5;
    }

    public static double phi(double d) {
        return Math.exp(-d * d / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double cdf(double d, double d2, double d3) {
        double d4 = (d - d2) / d3;
        double d5 = NormalDist.Phi(d4);
        return d5;
    }

    public static double Phi(double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = d;
        double d5 = d * d;
        double d6 = 1.0;
        while (d2 != d3) {
            d3 = d2;
            d2 = d3 + (d4 *= d5 / (d6 += 2.0));
        }
        return 0.5 + d2 * Math.exp(-0.5 * d5 - 0.9189385332046728);
    }

    public static enum Type {
        CDF,
        PDF,
        FOURARG;

    }
}

