/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.extensions.rewrite.RewriteRuleI;
import com.singularsys.extensions.rewrite.RewriteVisitor;
import com.singularsys.extensions.xjep.CommandVisitor;
import com.singularsys.extensions.xjep.EquationExtractor;
import com.singularsys.extensions.xjep.ExpressionCleaner;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.extensions.xjep.XComponents;
import com.singularsys.extensions.xjep.XEvaluator;
import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.ComponentSet;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DeepCopyVisitor;
import com.singularsys.jep.walkers.SubstitutionVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class XJep
extends Jep {
    private static final long serialVersionUID = 340L;
    protected TreeUtils tu = null;
    protected DeepCopyVisitor copier = null;
    protected SubstitutionVisitor subv = null;
    protected ExpressionCleaner cleaner = null;
    protected CommandVisitor commandv = null;
    protected PolynomialCreator polyv = null;
    protected RewriteVisitor rewritev = null;
    protected EquationExtractor extractor = null;

    public XJep() {
        this(new XComponents());
    }

    public XJep(JepComponent ... jepComponentArray) {
        this(new XComponents(jepComponentArray));
    }

    public XJep(ComponentSet componentSet) {
        super(componentSet.getComponents());
        for (JepComponent jepComponent : this.additionalComponents) {
            this.setXComponentInternal(jepComponent);
        }
        this.reinitializeComponents();
    }

    protected void setXComponentInternal(JepComponent jepComponent) {
        if (jepComponent instanceof TreeUtils) {
            this.tu = (TreeUtils)jepComponent;
        }
        if (jepComponent instanceof ExpressionCleaner) {
            this.cleaner = (ExpressionCleaner)jepComponent;
        }
        if (jepComponent instanceof EquationExtractor) {
            this.extractor = (EquationExtractor)jepComponent;
        } else if (jepComponent instanceof DeepCopyVisitor) {
            this.copier = (DeepCopyVisitor)jepComponent;
        }
        if (jepComponent instanceof SubstitutionVisitor) {
            this.subv = (SubstitutionVisitor)jepComponent;
        }
        if (jepComponent instanceof CommandVisitor) {
            this.commandv = (CommandVisitor)jepComponent;
        }
        if (jepComponent instanceof PolynomialCreator) {
            this.polyv = (PolynomialCreator)jepComponent;
        }
        if (jepComponent instanceof RewriteVisitor) {
            this.rewritev = (RewriteVisitor)jepComponent;
        }
    }

    public Node preprocess(Node node) throws ParseException {
        return this.commandv.process(node);
    }

    public Node deepCopy(Node node) throws ParseException {
        return this.copier.deepCopy(node);
    }

    public Node clean(Node node) throws ParseException {
        Node node2 = this.copier.deepCopy(node);
        return this.cleaner.clean(node2);
    }

    public Node simplify(Node node) throws ParseException {
        Node node2 = this.polyv.simplify(node);
        return node2;
    }

    public Node expand(Node node) throws ParseException {
        Node node2 = this.polyv.expand(node);
        return node2;
    }

    public boolean equals(Node node, Node node2) throws ParseException {
        boolean bl = this.polyv.equals(node, node2);
        return bl;
    }

    public Node substitute(Node node, String string, Object object) throws ParseException {
        return this.subv.substitute(node, string, object);
    }

    public Node substitute(Node node, String string, Node node2) throws ParseException {
        return this.subv.substitute(node, string, node2);
    }

    public Node substitute(Node node, Node node2) throws ParseException {
        return this.subv.substitute(node, node2);
    }

    public Node substitute(Node node, String[] stringArray, Object[] objectArray) throws ParseException {
        return this.subv.substitute(node, stringArray, objectArray);
    }

    public Node substitute(Node node, Node[] nodeArray) throws ParseException {
        return this.subv.substitute(node, nodeArray);
    }

    public Node substitute(Node node, String[] stringArray, Node[] nodeArray) throws ParseException {
        return this.subv.substitute(node, stringArray, nodeArray);
    }

    public Node substituteConstantVariables(Node node) throws ParseException {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (Variable objectArray2 : this.getVariableTable().getVariables()) {
            if (!objectArray2.isConstant()) continue;
            arrayList.add(objectArray2);
        }
        String[] stringArray = new String[arrayList.size()];
        Object[] objectArray = new Object[arrayList.size()];
        int n = 0;
        for (Variable variable : arrayList) {
            stringArray[n] = variable.getName();
            objectArray[n] = variable.getValue();
            ++n;
        }
        return this.subv.substitute(node, stringArray, objectArray);
    }

    public Node replaceRHSVariablesByEquations(Node node) throws JepException {
        return this.extractor.replaceRHSVariablesByEquations(node);
    }

    public Node replaceVariableByExpressions(Node node) throws JepException {
        return this.extractor.visit(node);
    }

    public Object calcVarValue(String string, boolean bl) throws EvaluationException {
        XVariable xVariable = (XVariable)this.getVariable(string);
        return xVariable.calcValue((XEvaluator)this.getEvaluator(), bl);
    }

    public Set<Variable> getVarsInEquation(Node node) {
        return this.getVarsInEquation(node, new HashSet<Variable>());
    }

    public Set<Variable> getVarsInEquation(Node node, Set<Variable> set) {
        if (node instanceof ASTVarNode) {
            Variable variable = ((ASTVarNode)node).getVar();
            set.add(variable);
        } else if (node instanceof ASTFunNode) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.getVarsInEquation(node.jjtGetChild(i), set);
            }
        }
        return set;
    }

    public Set<XVariable> recursiveGetVarsInEquation(Node node, Set<XVariable> set) throws ParseException {
        if (node instanceof ASTVarNode) {
            XVariable xVariable = (XVariable)((ASTVarNode)node).getVar();
            if (!set.contains(xVariable)) {
                if (xVariable.hasEquation()) {
                    this.recursiveGetVarsInEquation(xVariable.getEquation(), set);
                }
                if (set.contains(xVariable)) {
                    throw new ParseException("Recursive definition for " + xVariable.getName());
                }
                set.add(xVariable);
            }
        } else if (node instanceof ASTFunNode) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.recursiveGetVarsInEquation(node.jjtGetChild(i), set);
            }
        }
        return set;
    }

    public Node rewrite(Node node, boolean bl) throws ParseException {
        return this.rewritev.rewrite(node, bl);
    }

    public boolean addRewriteRule(RewriteRuleI rewriteRuleI) {
        return this.rewritev.add(rewriteRuleI);
    }

    public TreeUtils getTreeUtils() {
        return this.tu;
    }

    public DeepCopyVisitor getCopier() {
        return this.copier;
    }

    public SubstitutionVisitor getSubstitutionVisitor() {
        return this.subv;
    }

    public ExpressionCleaner getExpressionCleaner() {
        return this.cleaner;
    }

    public CommandVisitor getCommandVisitor() {
        return this.commandv;
    }

    public PolynomialCreator getPolynomialCreator() {
        return this.polyv;
    }

    public RewriteVisitor getRewriteVisitor() {
        return this.rewritev;
    }

    public EquationExtractor getExtractor() {
        return this.extractor;
    }
}

