/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.ComponentSubset;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.Parser;
import com.singularsys.jep.PrintVisitor;
import com.singularsys.jep.VariableFactory;
import com.singularsys.jep.VariableTable;
import java.util.List;

public class ComponentSet {
    protected NumberFactory numFac;
    protected VariableFactory varFac;
    protected NodeFactory nodeFac;
    protected VariableTable varTab;
    protected FunctionTable funTab;
    protected OperatorTableI opTab;
    protected Parser parser;
    protected Evaluator evaluator;
    protected PrintVisitor pv;
    protected JepComponent[] auxComps = new JepComponent[0];

    public ComponentSet() {
    }

    public ComponentSet(Jep jep) {
        this.numFac = jep.getNumberFactory();
        this.varFac = jep.getVariableFactory();
        this.nodeFac = jep.getNodeFactory();
        this.varTab = jep.getVariableTable();
        this.funTab = jep.getFunctionTable();
        this.opTab = jep.getOperatorTable();
        this.parser = jep.getParser();
        this.evaluator = jep.getEvaluator();
        this.pv = jep.getPrintVisitor();
        List<JepComponent> list = jep.getAdditionalComponents();
        this.auxComps = list.toArray(this.auxComps);
    }

    public ComponentSet(JepComponent[] jepComponentArray) {
        this.addComponents(jepComponentArray);
    }

    public void addComponents(JepComponent[] jepComponentArray) {
        for (JepComponent jepComponent : jepComponentArray) {
            if (jepComponent instanceof NumberFactory) {
                this.numFac = (NumberFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof VariableFactory) {
                this.varFac = (VariableFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof NodeFactory) {
                this.nodeFac = (NodeFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof FunctionTable) {
                this.funTab = (FunctionTable)jepComponent;
                continue;
            }
            if (jepComponent instanceof OperatorTableI) {
                this.opTab = (OperatorTableI)jepComponent;
                continue;
            }
            if (jepComponent instanceof Parser) {
                this.parser = (Parser)jepComponent;
                continue;
            }
            if (jepComponent instanceof Evaluator) {
                this.evaluator = (Evaluator)jepComponent;
                continue;
            }
            if (jepComponent instanceof PrintVisitor) {
                this.pv = (PrintVisitor)jepComponent;
                continue;
            }
            if (jepComponent instanceof ComponentSubset) {
                this.addComponents(((ComponentSubset)jepComponent).getParts());
                continue;
            }
            this.addAuxComponent(jepComponent);
        }
    }

    public JepComponent[] getComponents() {
        JepComponent[] jepComponentArray = this.getBaseComponents();
        JepComponent[] jepComponentArray2 = new JepComponent[jepComponentArray.length + this.auxComps.length];
        System.arraycopy(jepComponentArray, 0, jepComponentArray2, 0, jepComponentArray.length);
        System.arraycopy(this.auxComps, 0, jepComponentArray2, jepComponentArray.length, this.auxComps.length);
        return jepComponentArray2;
    }

    public JepComponent[] getBaseComponents() {
        return new JepComponent[]{this.numFac, this.varFac, this.nodeFac, this.varTab, this.funTab, this.opTab, this.parser, this.evaluator, this.pv};
    }

    public JepComponent[] getAuxComponents() {
        return this.auxComps;
    }

    public NumberFactory getNumberFactory() {
        return this.numFac;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFac;
    }

    public VariableFactory getVariableFactory() {
        return this.varFac;
    }

    public VariableTable getVariableTable() {
        return this.varTab;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public OperatorTableI getOperatorTable() {
        return this.opTab;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFac = nodeFactory;
    }

    public void setNumberFactory(NumberFactory numberFactory) {
        this.numFac = numberFactory;
    }

    public void setVariableFactory(VariableFactory variableFactory) {
        this.varFac = variableFactory;
    }

    public void setFunctionTable(FunctionTable functionTable) {
        this.funTab = functionTable;
    }

    public void setVariableTable(VariableTable variableTable) {
        this.varTab = variableTable;
    }

    public void setOperatorTable(OperatorTableI operatorTableI) {
        this.opTab = operatorTableI;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setPrintVisitor(PrintVisitor printVisitor) {
        this.pv = printVisitor;
    }

    public void addAuxComponent(JepComponent jepComponent) {
        JepComponent[] jepComponentArray = new JepComponent[this.auxComps.length + 1];
        System.arraycopy(this.auxComps, 0, jepComponentArray, 0, this.auxComps.length);
        jepComponentArray[this.auxComps.length] = jepComponent;
        this.auxComps = jepComponentArray;
    }

    public JepComponent[] getAuxComps() {
        return this.auxComps;
    }

    public void setAuxComps(JepComponent[] jepComponentArray) {
        this.auxComps = jepComponentArray;
    }
}

