/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.ComponentSet;
import com.singularsys.jep.ComponentSubset;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.PrintVisitor;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableFactory;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import com.singularsys.jep.standard.StandardComponents;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Jep
implements Serializable {
    private static final long serialVersionUID = 301L;
    protected NumberFactory numFac;
    protected VariableFactory varFac;
    protected NodeFactory nodeFac;
    protected VariableTable varTab;
    protected FunctionTable funTab;
    protected OperatorTableI opTab;
    protected PrintVisitor pv;
    protected transient Node lastRootNode = null;
    protected Parser parser;
    protected Evaluator evaluator;
    protected List<JepComponent> additionalComponents = new ArrayList<JepComponent>();
    protected boolean implicitMul = true;
    protected boolean allowUndeclared = true;
    protected boolean allowAssignment = true;

    public Jep() {
        this(new StandardComponents());
    }

    public Jep(ComponentSet componentSet) {
        this(componentSet.getComponents());
    }

    public Jep(JepComponent ... jepComponentArray) {
        for (JepComponent jepComponent : jepComponentArray) {
            this.setComponentInternal(jepComponent);
        }
        this.addDefaultComponents();
        this.reinitializeComponents();
    }

    public void setComponent(JepComponent jepComponent) {
        this.setComponentInternal(jepComponent);
        this.reinitializeComponents();
    }

    public void setComponents(JepComponent ... jepComponentArray) {
        for (JepComponent jepComponent : jepComponentArray) {
            this.setComponentInternal(jepComponent);
        }
        this.reinitializeComponents();
    }

    protected void addDefaultComponents() {
        if (this.numFac == null) {
            this.setComponentInternal(StandardComponents.createDefaultNumberFactory());
        }
        if (this.varFac == null) {
            this.setComponentInternal(StandardComponents.createDefaultVariableFactory());
        }
        if (this.nodeFac == null) {
            this.setComponentInternal(StandardComponents.createDefaultNodeFactory());
        }
        if (this.funTab == null) {
            this.setComponentInternal(StandardComponents.createDefaultFunctionTable());
        }
        if (this.varTab == null) {
            this.setComponentInternal(StandardComponents.createDefaultVariableTable(this.varFac));
        }
        if (this.opTab == null) {
            this.setComponentInternal(StandardComponents.createDefaultOperatorTable());
        }
        if (this.parser == null) {
            this.setComponentInternal(StandardComponents.createDefaultParser());
        }
        if (this.evaluator == null) {
            this.setComponentInternal(StandardComponents.createDefaultEvaluator());
        }
        if (this.pv == null) {
            this.setComponentInternal(StandardComponents.createDefaultPrintVisitor());
        }
    }

    protected void setComponentsInternal(ComponentSet componentSet) {
        for (JepComponent jepComponent : componentSet.getComponents()) {
            this.setComponentInternal(jepComponent);
        }
    }

    protected void setComponentInternal(JepComponent jepComponent) {
        if (jepComponent instanceof NumberFactory) {
            this.numFac = (NumberFactory)jepComponent;
        } else if (jepComponent instanceof VariableFactory) {
            this.varFac = (VariableFactory)jepComponent;
        } else if (jepComponent instanceof NodeFactory) {
            this.nodeFac = (NodeFactory)jepComponent;
        } else if (jepComponent instanceof VariableTable) {
            this.varTab = (VariableTable)jepComponent;
        } else if (jepComponent instanceof FunctionTable) {
            this.funTab = (FunctionTable)jepComponent;
        } else if (jepComponent instanceof OperatorTableI) {
            this.opTab = (OperatorTableI)jepComponent;
        } else if (jepComponent instanceof Parser) {
            this.parser = (Parser)jepComponent;
        } else if (jepComponent instanceof Evaluator) {
            this.evaluator = (Evaluator)jepComponent;
        } else if (jepComponent instanceof PrintVisitor) {
            this.pv = (PrintVisitor)jepComponent;
        } else if (jepComponent instanceof ComponentSubset) {
            for (JepComponent jepComponent2 : ((ComponentSubset)jepComponent).getParts()) {
                this.setComponentInternal(jepComponent2);
            }
        } else if (jepComponent != null) {
            this.additionalComponents.add(jepComponent);
        }
    }

    public void reinitializeComponents() {
        this.numFac.init(this);
        this.nodeFac.init(this);
        this.varFac.init(this);
        this.varTab.init(this);
        this.funTab.init(this);
        this.opTab.init(this);
        this.parser.init(this);
        this.evaluator.init(this);
        this.pv.init(this);
        for (JepComponent jepComponent : this.additionalComponents) {
            jepComponent.init(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.varTab.setVariableFactory(this.varFac);
        this.reinitializeComponents();
    }

    public NumberFactory getNumberFactory() {
        return this.numFac;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFac;
    }

    public VariableFactory getVariableFactory() {
        return this.varFac;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public OperatorTableI getOperatorTable() {
        return this.opTab;
    }

    public VariableTable getVariableTable() {
        return this.varTab;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public List<JepComponent> getAdditionalComponents() {
        return this.additionalComponents;
    }

    public JepComponent getAdditionalComponent(Class<?> clazz) {
        for (JepComponent jepComponent : this.additionalComponents) {
            if (!clazz.isInstance(jepComponent)) continue;
            return jepComponent;
        }
        return null;
    }

    public Variable addVariable(String string) {
        return this.varTab.addVariable(string);
    }

    public Variable addVariable(String string, Object object) throws JepException {
        return this.varTab.addVariable(string, object);
    }

    public Variable setVariable(String string, Object object) {
        try {
            return this.addVariable(string, object);
        }
        catch (JepException jepException) {
            return null;
        }
    }

    public Variable addVariable(String string, double d) throws JepException {
        return this.addVariable(string, new Double(d));
    }

    public Variable addVariable(String string, double d, double d2) throws JepException {
        return this.varTab.addVariable(string, new Complex(d, d2));
    }

    public Variable addConstant(String string, Object object) throws JepException {
        return this.varTab.addConstant(string, object);
    }

    public boolean tryAddConstant(String string, Object object) {
        Variable variable = this.varTab.getVariable(string);
        if (variable != null) {
            Object object2 = variable.getValue();
            return object.equals(object2);
        }
        try {
            this.varTab.addConstant(string, object);
            return true;
        }
        catch (JepException jepException) {
            return false;
        }
    }

    public boolean addStandardConstants() {
        try {
            this.varTab.addConstant("pi", this.numFac.createNumber(Math.PI));
            this.varTab.addConstant("e", this.numFac.createNumber(Math.E));
        }
        catch (ParseException parseException) {
            return false;
        }
        catch (JepException jepException) {
            return false;
        }
        return true;
    }

    public Variable getVariable(String string) {
        return this.varTab.getVariable(string);
    }

    public Object getVariableValue(String string) {
        Variable variable = this.varTab.getVariable(string);
        return variable != null ? variable.getValue() : null;
    }

    public void setAllowAssignment(boolean bl) {
        this.allowAssignment = bl;
        this.opTab.getAssign().setFlag(16384, !bl);
        this.reinitializeComponents();
    }

    public boolean getAllowAssignment() {
        return this.allowAssignment;
    }

    public void setAllowUndeclared(boolean bl) {
        this.allowUndeclared = bl;
    }

    public boolean getAllowUndeclared() {
        return this.allowUndeclared;
    }

    public void setImplicitMul(boolean bl) {
        this.implicitMul = bl;
    }

    public Object getDefaultValue() {
        return this.varFac.getDefaultValue();
    }

    public void setDefaultValue(Object object) {
        this.varFac.setDefaultValue(object);
    }

    public boolean getImplicitMul() {
        return this.implicitMul;
    }

    public PostfixMathCommandI addFunction(String string, PostfixMathCommandI postfixMathCommandI) {
        return this.funTab.addFunction(string, postfixMathCommandI);
    }

    public Node getLastRootNode() {
        return this.lastRootNode;
    }

    public Node parse(Reader reader) throws ParseException {
        this.lastRootNode = this.parser.parse(reader);
        return this.lastRootNode;
    }

    public Node parse(String string) throws ParseException {
        return this.parse(new StringReader(string));
    }

    public void initMultiParse(String string) {
        this.parser.restart(new StringReader(string));
    }

    public void initMultiParse(Reader reader) {
        this.parser.restart(reader);
    }

    public Node continueParsing() throws ParseException {
        return this.parser.continueParse();
    }

    public double evaluateD() throws EvaluationException {
        Object object = this.evaluate(this.lastRootNode);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("Jep.ResultCouldNotBeConvertedToDoubleType"), object.toString()));
    }

    public Object evaluate() throws EvaluationException {
        return this.evaluate(this.lastRootNode);
    }

    public Object evaluate(Node node) throws EvaluationException {
        if (node != null) {
            Object object = this.evaluator.evaluate(node);
            return object;
        }
        return null;
    }

    public void print(Node node, PrintStream printStream) {
        this.pv.print(node, printStream);
    }

    public void print(Node node) {
        this.pv.print(node);
    }

    public void print() {
        this.pv.print(this.lastRootNode);
    }

    public void println(Node node, PrintStream printStream) {
        this.pv.println(node, printStream);
    }

    public void println(Node node) {
        this.pv.println(node);
    }

    public void println() {
        this.pv.println(this.lastRootNode);
    }

    public String toString(Node node) {
        return this.pv.toString(node);
    }

    public String rootNodeToString() {
        return this.pv.toString(this.lastRootNode);
    }
}

